<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'abtarea_conwidth', 'about_area', 'Section Width ');

$wp_customize->add_setting('abt_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'about_area', // Replace with your actual section ID
    'settings' => 'abt_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Left Side', 'luzuk-premium' ),
        )
    )
);    


lzCustomLable($wp_customize, 'aboutarea_headingaling', 'about_area', 'Heading Alignment');

$wp_customize->add_setting('abt_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_maintitle_align', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'about_area', // Replace with your actual section ID
        'settings' => 'abt_maintitle_align',
        'choices'=>array(
           'left' => 'Left',
           'center' => 'Center',
           'right' => 'Right',
        )
    ) ) );

lzCustomLable($wp_customize, 'abtarea_headingcase', 'about_area', 'Heading Style');

$wp_customize->add_setting('abt_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'about_area', // Replace with your actual section ID
    'settings' => 'abt_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


$wp_customize->add_setting(
    'about_subHeading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_subHeading',
    array(
        'settings'      => 'about_subHeading',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_secsubtitle_clr', 'about_area', 'Sub Heading Color ', '#212121');

addColorPalatOption($wp_customize, 'about_secsubtitleicn_clr', 'about_area', 'Sub Heading Arrow Color ', '#212121');

lzCustomLable($wp_customize, 'abtarea_amcir', 'about_area', 'Animation Circle');

$wp_customize->add_setting( 'abticir_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'abticir_display', array( 'label' => 'Animation Circle Display', 'section' => 'about_area', 'settings' => 'abticir_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

addColorPalatOption($wp_customize, 'about_amcirclr', 'about_area', 'Animation Circle Color ', '#FC6441');

lzCustomLable($wp_customize, 'abtarea_subimag', 'about_area', 'Sub Heading Image');

$wp_customize->add_setting(
    'about_subimg',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_subimg',
        array(
            'section' => 'about_area',
            'settings' => 'about_subimg',
            'description' => __('Recommended Image Size: 350X275', 'luzuk-premium')
        )
    )
);

lzCustomLable($wp_customize, 'abtSec_titleclr', 'about_area' , 'Section Title');

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Your Trusted Electrical Services', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abt_titleclr', 'about_area', 'Title Color ', '#212121');


lzCustomLable($wp_customize, 'aboutarea_fristimgtxtbx', 'about_area', 'Experience Text Box');

$wp_customize->add_setting(
    'yer_num',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '14', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'yer_num',
    array(
        'settings'      => 'yer_num',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Numrical ', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'yer_exp',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Year Of Experience', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'yer_exp',
    array(
        'settings'      => 'yer_exp',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Year Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'abtdec_exnumclr', 'about_area', 'Years Number Color', '#212121');

addColorPalatOption($wp_customize, 'abtdec_exnumcirclr', 'about_area', 'Years Number Circle Color', '#FC6441');

addColorPalatOption($wp_customize, 'abtdec_extxtclr', 'about_area', 'Years Text Color', '#212121');

addColorPalatOption($wp_customize, 'abtdec_extxtbrdclr', 'about_area', 'Years Text Border Color', '#212121');


lzCustomLable($wp_customize, 'aboutarea_rightclr', 'about_area', 'Section Right Side');

lzCustomLable($wp_customize, 'abtarea_subimg', 'about_area', 'Right Side Image');

$wp_customize->add_setting(
    'about_image2',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image2',
        array(
            'section' => 'about_area',
            'settings' => 'about_image2',
            'description' => __('Recommended Image Size: 670X720', 'luzuk-premium')
        )
    )
);

lzCustomLable($wp_customize, 'aboutarea_tabclr', 'about_area', 'Section Tab');

lzCustomLable($wp_customize, 'aboutarea_tab1', 'about_area', '1St Tab');

$wp_customize->add_setting(
    'tb_name1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2010-2014', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'tb_name1',
    array(
        'settings'      => 'tb_name1',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( '1St Tab Title  ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'tb_txt1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<p>There Are Many Variations Of Passages Of Lorem Ipsum Available, But The Majority Have Suffered Alteration In Some Form, By Injected Humour, Or Randomised Words Which Do not Look Even Slightly Believable.</p>
            <li>Responsive all devices</li>
  <li>Smooth animations </li>
  <li>Modern design</li>
  <li>Clean & Clear</li>', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'tb_txt1',
    array(
        'settings'      => 'tb_txt1',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( '1St Tab Text ', 'Luzuk' )
    )
);


lzCustomLable($wp_customize, 'aboutarea_tab2', 'about_area', '2Nd Tab');

$wp_customize->add_setting(
    'tb_name2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2015-2020', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'tb_name2',
    array(
        'settings'      => 'tb_name2',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( '2Nd Tab Title ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'tb_txt2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<p>There Are Many Variations Of Passages Of Lorem Ipsum Available, But The Majority Have Suffered Alteration In Some Form, By Injected Humour, Or Randomised Words Which Do not Look Even Slightly Believable.</p>
                    <li>Responsive all devices</li>
  <li>Smooth animations </li>
  <li>Modern design</li>
  <li>Clean & Clear</li>', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'tb_txt2',
    array(
        'settings'      => 'tb_txt2',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( '2Nd Tab Text ', 'Luzuk' )
    )
);

lzCustomLable($wp_customize, 'aboutarea_tab3', 'about_area', '3Rd Tab');

$wp_customize->add_setting(
    'tb_name3',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2021-2024', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'tb_name3',
    array(
        'settings'      => 'tb_name3',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( '3Rd Tab Title ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'tb_txt3',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<p>There Are Many Variations Of Passages Of Lorem Ipsum Available, But The Majority Have Suffered Alteration In Some Form, By Injected Humour, Or Randomised Words Which Do not Look Even Slightly Believable.</p>
                    <li>Responsive all devices</li>
  <li>Smooth animations </li>
  <li>Modern design</li>
  <li>Clean & Clear</li>', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'tb_txt3',
    array(
        'settings'      => 'tb_txt3',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( '3Rd Tab Text ', 'Luzuk' )
    )
);


lzCustomLable($wp_customize, 'abtSec_listclr', 'about_area' , 'Tabs Color');

addColorPalatOption($wp_customize, 'abt_tabstitlclr', 'about_area', 'Tab Title Color', '#918f8f');

addColorPalatOption($wp_customize, 'abt_tabstitlactclr', 'about_area', 'Tab Title Active & Hover Color', '#F93A0E');

addColorPalatOption($wp_customize, 'abt_tabstitlbrdclr', 'about_area', 'Tab Title Border Color', '#6e6c6c');

addColorPalatOption($wp_customize, 'abt_tabtxtclr', 'about_area', 'Tab Text Color', '#212121');

addColorPalatOption($wp_customize, 'abt_listicnclr', 'about_area', 'List Icon Color', '#FC6441');

addColorPalatOption($wp_customize, 'abt_listtitleclr', 'about_area', 'List Title Color', '#696868');

lzCustomLable($wp_customize, 'abtsec_btnclr', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Us', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtbtn_text',
    array(
        'settings'      => 'abtbtn_text',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('abtbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abtdec_btntxtclr', 'about_area', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'abtdec_btntxthvclr', 'about_area', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_btnBGclr', 'about_area', 'Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_btnBGhvclr', 'about_area', 'Button BG Hover Color', '#FC6441');