<?php  

$wp_customize->add_section(
    'banner_area',
    array(
        'title' => __('Banner Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
  // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'banner_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'banner_area_disable',
            array(
                'settings'      => 'banner_area_disable',
                'section'       => 'banner_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'banner', 'banner_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'bannersection_padding', 'banner_area', ' Section Padding ');

$wp_customize->add_setting(
    'bannerTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bannerTpadding',
    array(
        'settings'      => 'bannerTpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'bannerBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'bannerBpadding',
    array(
        'settings'      => 'bannerBpadding',
        'section'       => 'banner_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'banner_conwidth', 'banner_area', 'Section Width ');

$wp_customize->add_setting('banner_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container-fluid'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'banner_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'banner_area', // Replace with your actual section ID
    'settings' => 'banner_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


$wp_customize->add_setting('banner_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner_npp_heading',
        array(
            'settings'      => 'banner_npp_heading',
            'section'       => 'banner_area',
            'label'         => __( 'Number Of Box To Show', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('banner_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
    'banner_npp_count',
    array(
        'settings'      => 'banner_npp_count',
        'section'       => 'banner_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Box To Show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'banner_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'banner_header'.$i,
            array(
                'settings'      => 'banner_header'.$i,
                'section'       => 'banner_area',
                'label'         => __( 'Banner ', 'Luzuk Premium' ).$i
            )
        )
    );

lzAddElement($wp_customize, 'bann_page_txt'.$i, 'banner_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='INTERIOR DESIGN');
    
}


lzCustomLable($wp_customize, 'banner_sectioncolor', 'banner_area', 'Section Color');

addColorPalatOption($wp_customize, 'banner_bxbgClr', 'banner_area', 'Box BG Color', '#FC6441');

addColorPalatOption($wp_customize, 'banner_titleClr', 'banner_area', 'Title Color', '#fff');

