<?php  

$wp_customize->add_section(
    'feature_area',
    array(
        'title' => __('Feature Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
  // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'feature_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'feature_area_disable',
            array(
                'settings'      => 'feature_area_disable',
                'section'       => 'feature_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'feature', 'feature_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'featuresection_padding', 'feature_area', ' Section Padding ');

$wp_customize->add_setting(
    'feature_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'feature_areaTpadding',
    array(
        'settings'      => 'feature_areaTpadding',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'feature_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'feature_areaBpadding',
    array(
        'settings'      => 'feature_areaBpadding',
        'section'       => 'feature_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'feaearea_conwidth', 'feature_area', 'Section Width ');

$wp_customize->add_setting('fea_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'fea_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'feature_area', // Replace with your actual section ID
    'settings' => 'fea_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


$wp_customize->add_setting('feature_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'feature_npp_heading',
        array(
            'settings'      => 'feature_npp_heading',
            'section'       => 'feature_area',
            'label'         => __( 'Number Of Feature To Show', 'Luzuk Premium' ),
        )
    )
);    
$wp_customize->add_setting('feature_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'feature_npp_count',
    array(
        'settings'      => 'feature_npp_count',
        'section'       => 'feature_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Feature To Show', 'Luzuk Premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'feature_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'feature_header'.$i,
            array(
                'settings'      => 'feature_header'.$i,
                'section'       => 'feature_area',
                'label'         => __( 'Feature Box ', 'Luzuk Premium' ).$i
            )
        )
    );

    //     $wp_customize->add_setting(
    //     'feature_page_icon'.$i,
    //     array(
    //         'default'           => 'fa fa-wrench',
    //         'sanitize_callback' => 'luzuk_sanitize_text'
    //     )
    // );        
    // $wp_customize->add_control(
    //     new luzuk_Fontawesome_Icon_Chooser(
    //         $wp_customize,
    //         'feature_page_icon'.$i,
    //         array(
    //             'settings'      => 'feature_page_icon'.$i,
    //             'section'       => 'feature_area',
    //             'type'          => 'icon',
    //             'label'         => __( 'FontAwesome Icon', 'Luzuk Premium' ),
    //         )
    //     )
    // );

     $wp_customize->add_setting(
        'feature_title_img'.$i,
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'feature_title_img'.$i,
            array(
                'section' => 'feature_area',
                'settings' => 'feature_title_img'.$i,
                'label' => 'Select Image',
                'description' => __('Recommended Image Size: 66pxX67px', 'luzuk-premium')
            )
        )
    );


lzAddElement($wp_customize, 'feature_page_title'.$i, 'feature_area', $type = 'text', $label="Feature Title", $callback ='luzuk_sanitize_text', $default='Architect');

lzAddElement($wp_customize, 'feature_page_txt'.$i, 'feature_area', $type = 'textarea', $label="Feature Text", $callback ='luzuk_sanitize_text', $default='There Are Many Of Passage Lorem Ipsum Available Slightly Believable.');
    
}


lzCustomLable($wp_customize, 'feature_sectioncolor', 'feature_area', 'Section Color');

addColorPalatOption($wp_customize, 'feature_bxbghvClr', 'feature_area', 'Box BG Hover Color', '#e9e7e7');

addColorPalatOption($wp_customize, 'feature_titleClr', 'feature_area', 'Title Color', '#212121');

addColorPalatOption($wp_customize, 'feature_txtClr', 'feature_area', 'Text Color', '#212121');
