<?php
$wp_customize->add_section(
    'newsletter_area',
    array(
        'title' => __('Newsletter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'newsletter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'newsletter_area_disable',
        array(
            'settings'      => 'newsletter_area_disable',
            'section'       => 'newsletter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'newsletter', 'newsletter_area', $color='#EEEEEE', get_template_directory_uri().'/images/newsletterbg.png', 'color');

lzCustomLable($wp_customize, 'newsletterarea_padding', 'newsletter_area', 'Section Padding');

$wp_customize->add_setting(
    'newsletter_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaTpadding',
    array(
        'settings'      => 'newsletter_areaTpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'newsletter_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaBpadding',
    array(
        'settings'      => 'newsletter_areaBpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newsarea_conwidth', 'newsletter_area', 'Section Width ');

$wp_customize->add_setting('news_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'news_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'newsletter_area', // Replace with your actual section ID
    'settings' => 'news_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

$wp_customize->add_setting(
    'newsletter_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newsletter_page_maintitle_heading',
        array(
            'settings'      => 'newsletter_page_maintitle_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);    
 

$wp_customize->add_setting(
    'newsletter_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get Updated With My Tips And News', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_maintitle',
    array(
        'settings'      => 'newsletter_page_maintitle',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletter_titleclr', 'newsletter_area', 'Section Heading Color', '#24345D');

$wp_customize->add_setting(
    'newsletter_pg_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Daily Tips for a Healthy Mind to Your Inbox', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_pg_txt',
    array(
        'settings'      => 'newsletter_pg_txt',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletter_txtclr', 'newsletter_area', 'Section Text Color', '#4D4C4C');

lzCustomLable($wp_customize, 'newsletter_Form_label', 'newsletter_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'luzuk_newsletter_shortcode', 'newsletter_area', 'text', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'news_forminputtextColor', 'newsletter_area', 'Form Input Text / Placeholder Color', '#24345D');

addColorPalatOption($wp_customize, 'news_forminputbgClr', 'newsletter_area', 'Form Input BG Color', '#fff');

addColorPalatOption($wp_customize, 'news_formlabelClr', 'newsletter_area', 'Form Label Color', '#000');

addColorPalatOption($wp_customize, 'news_formbtntxtClr', 'newsletter_area', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'news_formbtntxthvClr', 'newsletter_area', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'news_fmbnbgClr', 'newsletter_area', 'Form Button BG Color ', '#24345D');

addColorPalatOption($wp_customize, 'news_fmbnbghvClr', 'newsletter_area', 'Form Button BG Hover Color ', '#FF7617');
