<?php 
/**
 * Customiser section for ourclients
 **/
// Start ourclients section 
$wp_customize->add_section(
    'luzuk_ourclients_area',
    array(
        'title' => __( 'Clients Logo Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

// ENABLE/DISABLE ourclients SECTION
$wp_customize->add_setting(
    'ourclient_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'ourclient_area_disable',
        array(
            'settings'      => 'ourclient_area_disable',
            'section'       => 'luzuk_ourclients_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'ourclients', 'luzuk_ourclients_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'ourclientarea_padding', 'luzuk_ourclients_area', 'Section Padding');

$wp_customize->add_setting(
    'clientlogo_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'clientlogo_areaTpadding',
    array(
        'settings'      => 'clientlogo_areaTpadding',
        'section'       => 'luzuk_ourclients_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'clientlogo_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'clientlogo_areaBpadding',
    array(
        'settings'      => 'clientlogo_areaBpadding',
        'section'       => 'luzuk_ourclients_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'ourclient_conwidth', 'luzuk_ourclients_area', 'Section Width ');

$wp_customize->add_setting('ourclient_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ourclient_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'luzuk_ourclients_area', // Replace with your actual section ID
    'settings' => 'ourclient_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );




/*for note text*/
$wp_customize->add_setting('luzuk_ourclients_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_ourclients_area_lbl',
        array(
            'settings'      => 'luzuk_ourclients_area_lbl',
            'section'       => 'luzuk_ourclients_area',
            'label'         => __( 'Note:', 'luzuk-premium' ),   
            'description'   => __( 'Add Clients logo images of equal height, recommend image height of size 58px', 'luzuk-premium' ),
        )
    )
);
/*for note text*/



$wp_customize->add_setting('luzuk_ourclients_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_ourclients_npp_heading',
        array(
            'settings'      => 'luzuk_ourclients_npp_heading',
            'section'       => 'luzuk_ourclients_area',
            'label'         => __( 'Set Number Of Clients Logo To show', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('ourclient_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 6));
$wp_customize->add_control(
    'ourclient_npp_count',
    array(
        'settings'      => 'ourclient_npp_count',
        'section'       => 'luzuk_ourclients_area',
        'type'          => 'select',
        'label'         => __( 'Number of Clients logo to show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

//ourclients PAGES
for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'luzuk_ourclients_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_ourclients_header'.$i,
            array(
                'settings'      => 'luzuk_ourclients_header'.$i,
                'section'       => 'luzuk_ourclients_area',
                'label'         => __( 'Logo ', 'luzuk-premium' ).$i
            )
        )
    );

    lzAddImageElement($wp_customize, 'ourclient_page_icon'.$i, 'luzuk_ourclients_area', $label="Recommended Image Size: 185X185px");
    lzAddElement($wp_customize, 'ourclient_page_url_'.$i, 'luzuk_ourclients_area', $type = 'text', $label="Link", $callback ='esc_url', $default='Add link here');
}
// End Our Clients section 

lzCustomLable($wp_customize, 'ourclientarea_color', 'luzuk_ourclients_area', '  Section Color');

addColorPalatOption($wp_customize, 'ourclients_bxbgclr', 'luzuk_ourclients_area', 'Section Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_ourclients_imghvrborderColorone', 'luzuk_ourclients_area', 'Section Logo Hover Border Color One', '#000');

addColorPalatOption($wp_customize, 'luzuk_ourclients_imghvrborderColortwo', 'luzuk_ourclients_area', 'Section Logo Hover Border Color Two', '#000');