<?php  

$wp_customize->add_section(
    'plan_area',
    array(
        'title' => __('Plan Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
  // ENABLE/DISABLE planD SECTION
    $wp_customize->add_setting(
        'plan_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'plan_area_disable',
            array(
                'settings'      => 'plan_area_disable',
                'section'       => 'plan_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'plan', 'plan_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'plansection_padding', 'plan_area', ' Section Padding ');

$wp_customize->add_setting(
    'plan_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'plan_areaTpadding',
    array(
        'settings'      => 'plan_areaTpadding',
        'section'       => 'plan_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'plan_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'plan_areaBpadding',
    array(
        'settings'      => 'plan_areaBpadding',
        'section'       => 'plan_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'planarea_conwidth', 'plan_area', 'Section Width ');

$wp_customize->add_setting('plan_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'plan_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'plan_area', // Replace with your actual section ID
    'settings' => 'plan_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'planarea_headingaling', 'plan_area', 'Heading Alignment');

$wp_customize->add_setting('plan_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'plan_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'plan_area', // Replace with your actual section ID
    'settings' => 'plan_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'planarea_headingcase', 'plan_area', 'Heading Style');

$wp_customize->add_setting('plan_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'plan_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'plan_area', // Replace with your actual section ID
    'settings' => 'plan_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );

// ***********
$wp_customize->add_setting(
    'plan_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'plan_subtitle_heading',
        array(
            'settings'      => 'plan_subtitle_heading',
            'section'       => 'plan_area',
            'label'         => __( 'Section Sub Heading & Heading', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'plan_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Building Plan', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'plan_subtitle',
    array(
        'settings'      => 'plan_subtitle',
        'section'       => 'plan_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'plan_subHeading', 'plan_area', 'Sub Heading Color', '#212121');

addColorPalatOption($wp_customize, 'plan_subHeadingicn', 'plan_area', 'Sub Heading Arrow Color', '#212121');

$wp_customize->add_setting(
    'plan_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum ', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'plan_title',
    array(
        'settings'      => 'plan_title',
        'section'       => 'plan_area',
        'type'          => 'text',
        'label'         => __( 'Heading ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'plan_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Available', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'plan_title2',
    array(
        'settings'      => 'plan_title2',
        'section'       => 'plan_area',
        'type'          => 'text',
        'label'         => __( 'Extra Heading ', 'luzuk-premium' )
    )
);
addColorPalatOption($wp_customize, 'plan_Heading', 'plan_area', 'Heading Color', '#212121');


lzCustomLable($wp_customize, 'plan_secimg', 'plan_area', 'Section Image');

$wp_customize->add_setting(
    'plan_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'plan_image',
        array(
            'section' => 'plan_area',
            'settings' => 'plan_image',
            'description' => __('Recommended Image Size: 1200X958', 'luzuk-premium')
        )
    )
);


lzCustomLable($wp_customize, 'plan_Form_label', 'plan_area', 'Form Shortcode');

lzAddElement($wp_customize, 'plan_shortcode', 'plan_area', 'text', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'plan_frminputtxtClr', 'plan_area', 'Form Input Text / Placeholder Color', '#212121');

addColorPalatOption($wp_customize, 'plan_frminputbgClr', 'plan_area', 'Form Input BG Color', '#fff');

addColorPalatOption($wp_customize, 'plan_frminputbrdClr', 'plan_area', 'Form Input Border Color', '#FC6441');

addColorPalatOption($wp_customize, 'plan_frmlabelClr', 'plan_area', 'Form Label Color', '#212121');

addColorPalatOption($wp_customize, 'plan_frmbtntxtClr', 'plan_area', 'Form Button Text Color', '#FC6441');

addColorPalatOption($wp_customize, 'plan_frmbtntxthvClr', 'plan_area', 'Form Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'plan_fmbnbrdClr', 'plan_area', 'Form Button Border Color', '#FC6441');

addColorPalatOption($wp_customize, 'plan_fmbnbgClr', 'plan_area', 'Form Button BG Color ', '#FC64411A');

addColorPalatOption($wp_customize, 'plan_fmbnbghvClr', 'plan_area', 'Form Button BG Hover Color ', '#000');
