<?php 
$wp_customize->add_section(
    'project_area',
    array(
        'title'         => __( 'Project Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'project_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'project_area_disable',
        array(
            'settings'      => 'project_area_disable',
            'section'       => 'project_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'project', 'project_area', $color='#fff', get_template_directory_uri().'/images/projectbg.png', 'color');


lzCustomLable($wp_customize, 'luzuk_sec_projectssectionpadding', 'project_area', 'Section Padding');

$wp_customize->add_setting(
    'project_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'project_areaTpadding',
    array(
        'settings'      => 'project_areaTpadding',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'project_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'project_areaBpadding',
    array(
        'settings'      => 'project_areaBpadding',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'projectarea_conwidth', 'project_area', 'Section Width ');

$wp_customize->add_setting('proj_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'proj_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'project_area', // Replace with your actual section ID
    'settings' => 'proj_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'projectarea_headingaling', 'project_area', 'Heading Alignment');

$wp_customize->add_setting('proj_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'proj_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'project_area', // Replace with your actual section ID
    'settings' => 'proj_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'projectarea_headingcase', 'project_area', 'Heading Style');

$wp_customize->add_setting('proj_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'proj_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'project_area', // Replace with your actual section ID
    'settings' => 'proj_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


lzCustomLable($wp_customize, 'project_secheading', 'project_area', 'Section Sub Heading & Heading ');

$wp_customize->add_setting(
    'proj_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Project', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'proj_subtitle',
    array(
        'settings'      => 'proj_subtitle',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'project_subHeading', 'project_area', 'Sub Heading Color', '#212121');

addColorPalatOption($wp_customize, 'project_secsubtitleicn_clr', 'project_area', 'Sub Heading Arrow Color ', '#212121');


$wp_customize->add_setting(
    'proj_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum available', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'proj_title',
    array(
        'settings'      => 'proj_title',
        'section'       => 'project_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'project_Heading', 'project_area', 'Heading Color', '#212121');


$wp_customize->add_setting('project_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'project_area_lbl2',
        array(
            'settings'      => 'project_area_lbl2',
            'section'       => 'project_area',
            'label'         => __( 'Note :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [PROJECT] to show all projects in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('project_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'project_npp_heading',
        array(
            'settings'      => 'project_npp_heading',
            'section'       => 'project_area',
            'label'         => __( 'Number Of Projects To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('project_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' =>8));
$wp_customize->add_control(
    'project_npp_count',
    array(
        'settings'      => 'project_npp_count',
        'section'       => 'project_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Projects To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8)
    )
);

lzCustomLable($wp_customize, 'project_selctproject', 'project_area', 'Select Project ');

$projectsSingleChoice[] = 'Select';

for( $i = 1; $i <= 8; $i++ ){ 
    $wp_customize->add_setting(
        'projects_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'projects_heading'.$i,
            array(
                'settings'      => 'projects_heading'.$i,
                'section'       => 'project_area',
                'label'         => __( 'Project Box ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($projectsSingleChoice)){
        $wp_customize->add_setting(
            'projects_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'projects_page'.$i,
            array(
                'settings'      => 'projects_page'.$i,
                'section'       => 'project_area',
                'type'=> 'select',
                'label'         => __( 'Select A Project Box ', 'luzuk' ),
                'choices' => $projectsSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'projects_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-user-o',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'projects_page_icon1'.$i,
//             array(
//                 'settings'      => 'projects_page_icon1'.$i,
//                 'section'       => 'project_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );

    }else{
        $wp_customize->add_setting('project_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'project_area_lbl'.$i,
                array(
                    'settings'      => 'project_area_lbl'.$i,
                    'section'       => 'project_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the project Page.</strong> <br/>Please add the projects from "projects menu" and then select projects to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'projectsec_clr', 'project_area', 'Section Color');

addColorPalatOption($wp_customize, 'project_secactcattitlclr', 'project_area', 'Active Categories Title Color', '#F93A0E');

addColorPalatOption($wp_customize, 'project_seccattitlclr', 'project_area', 'Categories Title Color', '#000');

addColorPalatOption($wp_customize, 'project_sectitlclr', 'project_area', 'Image Title Color', '#fff');

addColorPalatOption($wp_customize, 'project_sectitlbgclr', 'project_area', 'Image Title BG Color', '#FC6441');


lzCustomLable($wp_customize, 'pjSec_btnclr', 'project_area' , 'Section Button Icon');

addColorPalatOption($wp_customize, 'pjdec_btnicnclr', 'project_area', 'Button Icon Color', '#000');

addColorPalatOption($wp_customize, 'pjdec_btnicnhvclr', 'project_area', 'Button Icon BG Hover Color', '#FC6441');

addColorPalatOption($wp_customize, 'pjdec_btnicnBGclr', 'project_area', 'Button Icon BG Color', '#fff');


