<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'servicearea_conwidth', 'service_area', 'Section Heading Width ');

$wp_customize->add_setting('ser_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );



lzCustomLable($wp_customize, 'servicearea_headingaling', 'service_area', 'Heading Alignment');

$wp_customize->add_setting('ser_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'serarea_headingcase', 'service_area', 'Heading Style');

$wp_customize->add_setting('ser_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );



$wp_customize->add_setting(
    'ser_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ser_title_heading',
        array(
            'settings'      => 'ser_title_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Sub Heading & Heading', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'ser_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Service', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_subtitle',
    array(
        'settings'      => 'ser_subtitle',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'ser_subHeading', 'service_area', 'Sub Heading Color', '#212121');

addColorPalatOption($wp_customize, 'ser_subHeadingicn', 'service_area', 'Sub Heading Arrow Color', '#212121');

$wp_customize->add_setting(
    'ser_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum available', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_title',
    array(
        'settings'      => 'ser_title',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'ser_Heading', 'service_area', 'Heading Color', '#212121');

lzCustomLable($wp_customize, 'serheading_subimag', 'service_area', 'Heading Image');

$wp_customize->add_setting(
    'ser_subimg',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'ser_subimg',
        array(
            'section' => 'service_area',
            'settings' => 'ser_subimg',
            'description' => __('Recommended Image Size: 510X490', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting('sersublink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('sersublink',
    array(
        'settings'      => 'sersublink',
        'section'       => 'service_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'ser_secimgbtnbgclr', 'service_area', 'Image Button Bg Color', '#fff');

addColorPalatOption($wp_customize, 'ser_secimgbtnicnclr', 'service_area', 'Image Button Icon Color', '#FC6441');

addColorPalatOption($wp_customize, 'ser_secimgbtnicnhvclr', 'service_area', 'Image Button Icon Hover Color', '#212121');


lzCustomLable($wp_customize, 'servicearea_sliderconwidth', 'service_area', 'Section Slider Width ');

$wp_customize->add_setting('ser_slider_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container-fluid'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_slider_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_slider_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        )
    )
);    

$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'service_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'service_area', // Replace with your actual section ID
        'settings' => 'service_npp_count',
        'choices'=>array(1,2,3,4,5,6,7,8)
    ) ) );


$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service Box ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Box ', 'luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-wrench',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_servicesclr', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'services_secbxbgClr', 'service_area', 'Box Color ', '#fff');

addColorPalatOption($wp_customize, 'services_secTitleClr', 'service_area', 'Title Color ', '#F93A0E');

addColorPalatOption($wp_customize, 'services_secTitlehvClr', 'service_area', 'Title Hover Color ', '#000');

addColorPalatOption($wp_customize, 'ser_sectxtClr', 'service_area', 'Title Text Color ', '#212121');


lzCustomLable($wp_customize, 'sersec_sliderclr', 'service_area', 'Slider Button ');

addColorPalatOption($wp_customize, 'ser_secslidbtnbgClr', 'service_area', 'Slider Button BG Color ', '#FC6441');

addColorPalatOption($wp_customize, 'ser_secslidbtnicnClr', 'service_area', 'Slider Button Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'ser_secslidbtnicnhvClr', 'service_area', 'Slider Button Icon Hover Color ', '#000');