<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
    'slider_section',
    array(
        'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
        'priority' =>18
    )
);
$wp_customize->add_setting(
    'slider_section_show_content',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'slider_section_show_content',
        array(
            'settings'      => 'slider_section_show_content',
            'section'       => 'slider_section',
            'label'         => __( 'Hide Title And Description On Slider', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'No', 'Luzuk' ),
                'off' => __( 'Yes', 'Luzuk' )
            ),
        )
    )
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'slider_section_lbl',
        array(
            'settings'      => 'slider_section_lbl',
            'section'       => 'slider_section',
            'label'         => __( 'Note:', 'Luzuk' ),  
            'description'   => __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1050X900', 'Luzuk' ),
        )
    )
);

lzCustomLable($wp_customize, 'luzuk_slirover', 'slider_section', 'Image Overlay & Opacity');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'sli_imgolyclr', 'slider_section', 'Image Overlay Color ', '#000');

lzCustomLable($wp_customize, 'luzuk_aniciecle', 'slider_section', 'Animation Circle');

$wp_customize->add_setting( 'seccrib_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'seccrib_display', array( 'label' => 'Section Circle Display', 'section' => 'slider_section', 'settings' => 'seccrib_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 
addColorPalatOption($wp_customize, 'slider_anicirClr', 'slider_section', 'Animation Circle Color', '#f4f5f7');

lzCustomLable($wp_customize, 'luzuk_sliderclr', 'slider_section', 'Slider Color');

addColorPalatOption($wp_customize, 'slider_titleClr', 'slider_section', 'Title Color', '#000');

addColorPalatOption($wp_customize, 'slider_titlebrdClr', 'slider_section', 'Title Border Color', '#000');

addColorPalatOption($wp_customize, 'slider_BtntxtClr', 'slider_section', 'Button Text Color', '#FC6441');

addColorPalatOption($wp_customize, 'slider_BtntxthvClr', 'slider_section', 'Button Text Hover Color', '#fff');


addColorPalatOption($wp_customize, 'slider_Btnbrd', 'slider_section', 'Button Border Color', '#000');


addColorPalatOption($wp_customize, 'slider_Btnbg', 'slider_section', 'Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'slider_Btnbghv', 'slider_section', 'Button BG Hover Color', '#FC6441');


lzCustomLable($wp_customize, 'luzuk_sliderbutnclrs', 'slider_section', 'Slider Buttton Color ');


addColorPalatOption($wp_customize, 'sli_btnbgclr', 'slider_section', 'Slider Slide Dots Color', '#000');

addColorPalatOption($wp_customize, 'sli_btnarowhvclr', 'slider_section', 'Slider Slide Active Dot  Color', '#FC6441');
