<?php 
    $wp_customize->add_section(
        'video_area',
        array(
            'title' => __( 'Video Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'video_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'video_area_disable',
            array(
                'settings'      => 'video_area_disable',
                'section'       => 'video_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'videous', 'video_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'videoarea_padding', 'video_area', 'Section Padding');

$wp_customize->add_setting(
    'videosec_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'videosec_toppadding',
    array(
        'settings'      => 'videosec_toppadding',
        'section'       => 'video_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'videosec_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'videosec_bottompadding',
    array(
        'settings'      => 'videosec_bottompadding',
        'section'       => 'video_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'videoarea_headingaling', 'video_area', 'Heading Alignment');

$wp_customize->add_setting('vdio_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'right'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'vdio_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'video_area', // Replace with your actual section ID
    'settings' => 'vdio_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'video_headingcase', 'video_area', 'Heading Style');

$wp_customize->add_setting('vdio_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'vdio_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'video_area', // Replace with your actual section ID
    'settings' => 'vdio_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


lzCustomLable($wp_customize, 'facivideosec_padding', 'video_area', ' Video URL ');

// Add setting for the video URL
$wp_customize->add_setting('luzuk_premium_faci_video_iframe', array(
    'default'   => '',
    'transport' => 'refresh', // or 'postMessage' for live preview
));

// Add control for the video URL
$wp_customize->add_control('luzuk_premium_faci_video_iframe', array(
    'label'    => __('Video URL HERE', 'luzuk premium'),
    'section'  => 'video_area',
    'type'     => 'textarea', // Use 'textarea' if you need to support embed codes
    'settings' => 'luzuk_premium_faci_video_iframe',
));

// 

$wp_customize->add_setting(
    'videosubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'projects World-wide', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'videosubtitle',
    array(
        'settings'      => 'videosubtitle',
        'section'       => 'video_area',
        'type'          => 'text',
        'label'         => __( 'Sub Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'video_subHeading', 'video_area', 'Sub Heading Color', '#fff');

$wp_customize->add_setting(
    'videotitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '$430 millions', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'videotitle',
    array(
        'settings'      => 'videotitle',
        'section'       => 'video_area',
        'type'          => 'text',
        'label'         => __( ' Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'video_Heading', 'video_area', 'Heading Color', '#fff');


$wp_customize->add_setting(
    'videotext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'We Invested.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'videotext',
    array(
        'settings'      => 'videotext',
        'section'       => 'video_area',
        'type'          => 'text',
        'label'         => __( ' Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'video_text', 'video_area', 'Text Color', '#fff');