/*
 * Theme Name: Lz Software Company
*/

/*----------------------------------------------------
/* Responsive Navigation
/*--------------------------------------------------*/
jQuery(document).ready(function($){
    $('.primary-navigation').append('<div id="mobile-menu-overlay" />');

    $('.toggle-mobile-menu').click(function(e) {
        e.preventDefault();
        e.stopPropagation();
        $('body').toggleClass('mobile-menu-active');

        if ( $('body').hasClass('mobile-menu-active') ) {
            if ( $(document).height() > $(window).height() ) {
                var scrollTop = ( $('html').scrollTop() ) ? $('html').scrollTop() : $('body').scrollTop();
                $('html').addClass('noscroll').css( 'top', -scrollTop );
            }
            $('#mobile-menu-overlay').fadeIn();
        } else {
            var scrollTop = parseInt( $('html').css('top') );
            $('html').removeClass('noscroll');
            $('html,body').scrollTop( -scrollTop );
            $('#mobile-menu-overlay').fadeOut();
        }
    });
}).on('click', function(event) {

    var $target = jQuery(event.target);
    if ( ( $target.hasClass("publishable-icon") && $target.parent().hasClass("toggle-caret") ) ||  $target.hasClass("toggle-caret") ) {// allow clicking on menu toggles
        return;
    }
    jQuery('body').removeClass('mobile-menu-active');
    jQuery('html').removeClass('noscroll');
    jQuery('#mobile-menu-overlay').fadeOut();
});

/*----------------------------------------------------
/*  Dropdown menu
/* ------------------------------------------------- */
jQuery(document).ready(function($) {
    
    function mtsDropdownMenu() {
        var wWidth = $(window).width();
        if(wWidth > 865) {
            $('#navigation ul.sub-menu, #navigation ul.children').hide();
            var timer;
            var delay = 100;
            $('#navigation li').hover( 
              function() {
                var $this = $(this);
                timer = setTimeout(function() {
                    $this.children('ul.sub-menu, ul.children').slideDown('fast');
                }, delay);
                
              },
              function() {
                $(this).children('ul.sub-menu, ul.children').hide();
                clearTimeout(timer);
              }
            );
        } else {
            $('#navigation li').unbind('hover');
            $('#navigation li.active > ul.sub-menu, #navigation li.active > ul.children').show();
        }
    }

    mtsDropdownMenu();

    $(window).resize(function() {
        mtsDropdownMenu();
    });
});

/*---------------------------------------------------
/*  Vertical menus toggles
/* -------------------------------------------------*/
jQuery(document).ready(function($) {

    $('.widget_nav_menu, #navigation .menu').addClass('toggle-menu');
    $('.toggle-menu ul.sub-menu, .toggle-menu ul.children').addClass('toggle-submenu');
    $('.toggle-menu ul.sub-menu').parent().addClass('toggle-menu-item-parent');

    $('.toggle-menu .toggle-menu-item-parent').append('<span class="toggle-caret"><i class="publishable-icon icon-plus"></i></span>');

    $('.toggle-caret').click(function(e) {
        e.preventDefault();
        $(this).parent().toggleClass('active').children('.toggle-submenu').slideToggle('fast');
    });
});

/*----------------------------------------------------
/* Back to top smooth scrolling
/*--------------------------------------------------*/
jQuery(document).ready(function($) {
    jQuery('a[href=#top]').click(function(){
        jQuery('html, body').animate({scrollTop:0}, 'slow');
        return false;
    });
});

// Gallery 

Fancybox.bind("[data-fancybox]", {
    buttons: [
    "slideShow",
    "thumbs",
    "fullScreen",
    "close"
  ],
  loop: false,
  protect: true
}); 


// Gallery image popup

$(function () {
    "use strict";
    
    $(".popup img").click(function () {
        var $src = $(this).attr("src");
        $(".show").fadeIn();
        $(".img-show img").attr("src", $src);
    });
    
    $("span, .overlay").click(function () {
        $(".show").fadeOut();
    });
    
});

// gallery tab

jQuery(document).ready(function($) {
    // Initially show all items
    $('.gallery-item').show();

    // Handle tab click event
    $('.gallery-tab').on('click', function(e) {
        e.preventDefault(); // Prevent default behavior

        var termId = $(this).data('term-id'); // Get the term ID from the clicked tab

        // Remove active class from all tabs and add it to the clicked one
        $('.gallery-tab').removeClass('active');
        $(this).addClass('active');

        // If "All" is clicked (assuming termId 0 for "All")
        if (termId === 0) {
            $('.gallery-item').show(); // Show all items
        } else {
            // Hide all items, then show only items that match the selected category
            $('.gallery-item').hide();
            $('.category-' + termId).show();
        }
    });
});

// 
// Gallery image popup with zoom effect
$(function () {
    "use strict";

    $(".popup img").click(function () {
        var $src = $(this).attr("src");
        
        $(".show").fadeIn();
        $(".img-show img").attr("src", $src);
        
        // Add zoom effect to the popup image
        $(".img-show img").addClass("img-zoom");

        // Remove the zoom effect after the animation ends
        $(".img-show img").on("animationend", function() {
            $(this).removeClass("img-zoom");
        });
    });
    
    $("span, .overlay").click(function () {
        $(".show").fadeOut();
    });
});

// Gallery tab with zoom effect
jQuery(document).ready(function($) {
    // Initially show all items with zoom effect
    $('.gallery-item').show().addClass("img-zoom");

    // Handle tab click event
    $('.gallery-tab').on('click', function(e) {
        e.preventDefault(); // Prevent default behavior

        var termId = $(this).data('term-id'); // Get the term ID from the clicked tab

        // Remove active class from all tabs and add it to the clicked one
        $('.gallery-tab').removeClass('active');
        $(this).addClass('active');

        // If "All" is clicked (assuming termId 0 for "All")
        if (termId === 0) {
            $('.gallery-item').show().addClass("img-zoom"); // Show all items
        } else {
            // Hide all items, then show only items that match the selected category with zoom effect
            $('.gallery-item').hide();
            $('.category-' + termId).show().addClass("img-zoom");
        }

        // Remove zoom class after animation for retriggering
        $('.gallery-item').on("animationend", function() {
            $(this).removeClass("img-zoom");
        });
    });
});


// prject catergires {}
// project tab

document.addEventListener("DOMContentLoaded", function () {
    const tabs = document.querySelectorAll(".projects-tab");
    const projects = document.querySelectorAll(".single-project-bx");

    tabs.forEach((tab) => {
        tab.addEventListener("click", function (e) {
            e.preventDefault();

            // Remove "active" class from all tabs
            tabs.forEach((t) => t.classList.remove("active"));

            // Add "active" class to clicked tab
            tab.classList.add("active");

            // Get the term ID of the clicked tab
            const termId = tab.getAttribute("data-term-id");

            // Show or hide projects based on the term ID
            projects.forEach((project) => {
                const categories = project.getAttribute("data-category").split(" ");
                if (termId === "0" || categories.includes(termId)) {
                    project.style.display = "block"; // Show project
                } else {
                    project.style.display = "none"; // Hide project
                }
            });
        });
    });
});

// project mouse scroll {image scroll}

