<?php 
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package luzuk Premium
 */
get_header(); ?>
  <?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
<header class="page-main-header" >
    <div class="container">   
        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
        <div class="bdcrmbox ">
            <div class="breadcrumbbox ">
                <div class='button'>
                  <?php luzuk_lite_the_breadcrumb(); ?> </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <?php endif ?>
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?> 

        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</header>

<main id="innerpage-box">
    <?php
        // width 
        $c_width = get_theme_mod('innpg_c_width', 'container');

        if ($c_width === 'container') {
            $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
            
    ?>
	<div class="<?php echo esc_attr($c_width); ?>">
        <div class="inner_contentbox">
    		<div id="content-box" class="innerpage-whitebox main-timeline">
    			<?php while ( have_posts() ) : the_post(); ?>
    				<?php get_template_part( 'template-parts/content', 'page' ); ?>
    				<?php
    				// If comments are open or we have at least one comment, load up the comment template.
    				if ( comments_open() || get_comments_number() ) :
    					comments_template();
    				endif;
    				?>
    			<?php endwhile; // End of the loop. ?>

                <div class="clearfix"></div>
    		</div><!-- #main -->
	        <div class="clearfix"></div>
		
    		<div class="pagingation">
        		<?php lzGetPagination($query);?>
    		</div>
            <div class="clearfix"></div>
        </div>
	</div>
</main><!-- #main -->
<?php get_template_part('template-parts/section','ourclients'); ?>
<?php get_footer(); ?>

