<?php
/**
* The template for displaying search results pages.
*
* @package luzuk
*/

get_header(); ?>

<header class="page-main-header" > 
    <div class="container">   
        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
        <div class="bdcrmbox ">
            <div class="breadcrumbbox ">
                <div class='button'>
                  <?php luzuk_lite_the_breadcrumb(); ?> </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <?php endif ?>
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?> 
        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</header>
<?php
    // width 
    $c_width = get_theme_mod('innpg_c_width', 'container');

    if ($c_width === 'container') {
        $c_alignment = 'container';
    } elseif ($c_width === 'container-fluid') {
        $c_alignment = 'container-fluid';
    } else {
        $text_alignment = 'container'; // Default to 'container' if the setting is invalid
    }
        
?>
<main id="innerpage-box">
	<div class="<?php echo esc_attr($c_width); ?>">
		<div class="inner_contentbox">
		  	<div class="row mr-0">
				<div id="content-box" class="col-lg-8 col-md-7 innerpage-whitebox">
					<?php if ( have_posts() ) : ?>
						<?php /* Start the Loop */ ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php
							/**
							 * Run the loop for the search to output the results.
							 * If you want to overload this in a child theme then include a file
							 * called content-search.php and that will be used instead.
							 */
							get_template_part( 'template-parts/content', 'search' );
							?>
						<?php endwhile; ?>
						<?php 
						the_posts_pagination( 
							array(
								'prev_text' => __( 'Prev', 'total' ),
								'next_text' => __( 'Next', 'total' ),
							)
						); 
						?>
					<?php else : ?>
					<?php get_template_part( 'template-parts/content', 'none' ); ?>
					<?php endif; ?>
				</div><!-- #main -->
				<div class="col-lg-4 col-md-5">
					<?php  get_sidebar(); ?>
				</div>
			</div>
		<div class="clearfix"></div>
		<div class="row mr-0">
			<div class="col-md-12">
				<div class="pagingation">
					<?php lzGetPagination($query);?>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
	</div>
		<div class="clearfix"></div>
	</div>
</main><!-- #primary -->
<?php get_template_part('template-parts/section','ourclients'); ?>
<?php get_footer();
