<?php
/**
 *
 * @package luzuk Premium
 */
if(get_theme_mod('blog_section_disable') != 'on' ){ ?>

<div  class="blog-area" id="blog" >		
	<?php
		// width 
		$c_width = get_theme_mod('blog_c_width', 'container');

	    if ($c_width === 'container') {
		    $c_alignment = 'container';
		} elseif ($c_width === 'container-fluid') {
		    $c_alignment = 'container-fluid';
		} else {
		    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
		}

		// Heading Style
    	$heading_case = get_theme_mod('blog_maintitle_case', 'capitalize');

	    if ($heading_case === 'uppercase') {
			$text_case = 'uppercase';
		} elseif ($heading_case === 'lowercase') {
		    $text_case = 'lowercase';
		} elseif ($heading_case === 'capitalize') {
		    $text_case = 'capitalize';
		} else {
		    $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
		}
			 
		// Alientment
        $heading_alignment = get_theme_mod('blog_maintitle_align', 'left');

	    if ($heading_alignment === 'left') {
			$text_alignment = 'left';
		} elseif ($heading_alignment === 'center') {
		    $text_alignment = 'center';
		} elseif ($heading_alignment === 'right') {
		    $text_alignment = 'right';
		} else {
		    $text_alignment = 'left'; // Default to 'left' if the setting is invalid
		}
    ?>
	<?php	
		$blog_subtitle = get_theme_mod('blog_subtitle', 'Blog');		
		$blog_title2 = get_theme_mod('blog_title2', 'Lorem Ipsum Available ');
		
	?>
	
	<div class="section-title">
          <!-- <div class="container"> -->
        <div class="<?php echo esc_attr($c_width); ?>">
            <div class="titlebx">
              <?php if( $blog_subtitle ){ ?>
              <div class="sub_title" style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($blog_subtitle); ?>
                <svg viewBox="0 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg">
                  <g transform="scale(-1, 1)" transform-origin="center">
                    <path d="M 2.5 8 L 0 10.5 L 2.5 13 L 4 13 L 2 11 L 19 11 L 19 10 L 2 10 L 4 8 L 2.5 8 z" 
                      style="fill-opacity:1; stroke:none; stroke-width:0px;"></path>
                  </g>
                </svg>
              </div>
              <?php }?>
              <h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($blog_title2); ?></h3>
            </div>
        </div>
    </div>
		
	<div  class="<?php echo esc_attr($c_width); ?>">	
		<div class="blog-area-wrap">
			<div class="blog-posts">
				<div class="row mr-0">
				<?php 
					$blog_post_count = get_theme_mod('blog_post_count', 3 );
					$blog_cat_exclude = get_theme_mod('blog_cat_exclude');
					$blog_cat_exclude = explode(',', $blog_cat_exclude);
					$args = array(
						'posts_per_page' => absint($blog_post_count),
						'category__not_in' => $blog_cat_exclude
					);
					$query = new WP_Query($args);
					if($query -> have_posts()):
						while($query -> have_posts()) : $query -> the_post();
						$luzuk_blog_image = wp_get_attachment_image_src(get_post_thumbnail_id() , 'total-blog-thumb');
						?>
						<?php 
						if(has_post_thumbnail()){
							$img = esc_url($luzuk_blog_image[0]);
						}
						if(empty($luzuk_blog_image)){
							$img = get_template_directory_uri().'/images/blog.jpg';
						}
				?>
					<!-- <div class="blog-post col-lg-4 col-md-6 col-sm-6 blogbx"> -->
					<div class="blog-post  blogbx">
						<div class="box-area-S ">
							<div class="blog-thumbnail">
								<a href="<?php the_permalink(); ?>">
									<img class="blog-img" src="<?php echo $img; ?>" alt="<?php the_title(); ?>">											
								</a>
								<div class="blog-single">				
									<li>		
										<div class="blog-admbx">		
											<?php echo get_the_date( 'M j, Y' ); ?>	
										</div>
									</li>							
									<a href="<?php the_permalink(); ?>">
										<h4 class="inner-area-title"><?php the_title(); ?></h4>
									</a>
									<p>
									<?php 
										if(has_excerpt()){
											echo get_the_excerpt();
										}else{
											echo luzuk_excerpt( get_the_content() , 60 );
										}
									?>
									</p>		
									<?php
										$blogbtn_text = get_theme_mod('blogbtn_text', 'Read More');
									?>
                  					<div class="blog-btn">
										<?php if($blogbtn_text ){ ?>	
										<a href="<?php echo esc_url(get_permalink()); ?>">
													<?php echo ($blogbtn_text);  ?>
										</a>
										<?php }?>
									</div>															
									<div class="clearfix"></div>		
								</div>	
							</div>														
							<div class="clearfix"></div>
						</div>
					</div>
					<?php
						endwhile;
					endif;
					wp_reset_postdata();
					?>
				</div>
			</div>
		</div>					
		<div class="clearfix"></div>
	</div>
</div>

<?php }