<?php  

if(get_theme_mod('gallery_section_disable') != 'on' ){ ?>  
	<?php 
		if( get_theme_mod('secgalleryTpadding',true) ) {
			$secgalleryTpadding = 'padding-top:'.esc_attr(get_theme_mod('secgalleryTpadding')).';';
		}
		if( get_theme_mod('secgalleryBpadding',true) ) {
			$secgalleryBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('secgalleryBpadding')).';';
		}
	?>		

	<section id="gallery" class="gallery-area">
		<?php
			// width 
			$c_width = get_theme_mod('gall_c_width', 'container');

		    if ($c_width === 'container') {
			    $c_alignment = 'container';
			} elseif ($c_width === 'container-fluid') {
			    $c_alignment = 'container-fluid';
			} else {
			    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
			}			

			// Heading Style
        	$heading_case = get_theme_mod('gallery_maintitle_case', 'capitalize');

			if ($heading_case === 'uppercase') {
				$text_case = 'uppercase';
			} elseif ($heading_case === 'lowercase') {
			    $text_case = 'lowercase';
			} elseif ($heading_case === 'capitalize') {
			    $text_case = 'capitalize';
			} else {
			    $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
			}
					 
					// Alignment
	        $heading_alignment = get_theme_mod('gallery_maintitle_align', 'left');

		    if ($heading_alignment === 'left') {
				    $text_alignment = 'left';
			} elseif ($heading_alignment === 'center') {
			    $text_alignment = 'center';
			} elseif ($heading_alignment === 'right') {
			    $text_alignment = 'right';
			} else {
			    $text_alignment = 'left'; // Default to 'left' if the setting is invalid
			}
	    ?>

	    <?php
	    	$gallery_subtitle = get_theme_mod('gallery_subtitle', 'Gallery');							
			$gallery_title = get_theme_mod('gallery_title', 'Lorem Ipsum Available');
			
		?>
		<div class="section-title">
	          <!-- <div class="container"> -->
	        <div class="<?php echo esc_attr($c_width); ?>">
	            <div class="titlebx">
	              <?php if( $gallery_subtitle ){ ?>
	              <div class="sub_title" style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($gallery_subtitle); ?>
	                <svg viewBox="0 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg">
	                  <g transform="scale(-1, 1)" transform-origin="center">
	                    <path d="M 2.5 8 L 0 10.5 L 2.5 13 L 4 13 L 2 11 L 19 11 L 19 10 L 2 10 L 4 8 L 2.5 8 z" 
	                      style="fill-opacity:1; stroke:none; stroke-width:0px;"></path>
	                  </g>
	                </svg>
	              </div>
	              <?php }?>
	              <h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($gallery_title); ?></h3>
	            </div>
	        </div>
	    </div>
		
		<div class="<?php echo esc_attr($c_width); ?>"> 		    	
			<div class="gallery-main-box">
				<div class="gallery-tabs">
		            <ul>
		                <?php
		                // Get all gallery categories
		                $terms = get_terms(array(
		                    'taxonomy'   => 'gallery_category',
		                    'hide_empty' => true,
		                ));

		                // Output each category as a tab
		                foreach ($terms as $term) {
		                    echo '<li><a href="#" class="gallery-tab" data-term-id="' . esc_attr($term->term_id) . '">' . esc_html($term->name) . '</a></li>';
		                }
		                ?>
		            </ul>
		        </div>
				<div class="row mr-0">
					<div class="homegalry "> 
					<?php 
					$showStatic = true;
					$cols = get_theme_mod('gallery_npp_count', 10);
					$cols++;

					for( $i = 1; $i <= $cols; $i++ ){
						$gallery_page_id = get_theme_mod('gallery_page'.$i); 
						$gallery_page_icon = get_theme_mod('gallery_page_icon'.$i);
						if($gallery_page_id){
							$showStatic = false;
							echo galleryShortCode($gallery_page_id, $isCustomizer=true, $i);
						}
					}

					$args = array(
						'post_type' => 'our-gallery',
						'post_status' => 'publish'
					);
					$new = new WP_Query($args); 
					$i=1;
					if($showStatic == true){
						while ( $new->have_posts() ){
							$new->the_post(); 
							$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'medium_large' );
							if(has_post_thumbnail()) { $thumb_url = $thumb['0']; }
							$url = $thumb['0'];?>
													
							<div class="lz-gallery-images">
								<figure class="spa-gall">
									<div class="gallery-item">
										<img class="secondry-bg img-responsive" src="<?php echo esc_url($thumb_url); ?>" alt="<?php the_title(); ?>" />
										<div class="g-oly"></div>
									</div>
								</figure>						
							</div>				
							<div class="clearfix"></div>			 		  
						<?php 
						$i++; } wp_reset_query();
					} ?>
					</div>
				</div>
			</div>			
			<div class="clearfix"></div>
		</div> 	
	</section>
	<?php }