<?php

if(get_theme_mod('plan_area_disable') != 'on' ){	?>
 	
<div class="plan-area" id="plan" >
	<?php
		// Heading width 
		$c_width = get_theme_mod('plan_c_width', 'container');

	    if ($c_width === 'container') {
			    $c_alignment = 'container';
			} elseif ($c_width === 'container-fluid') {
			    $c_alignment = 'container-fluid';
			} else {
			    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
			}

			// Heading Style
		$heading_case = get_theme_mod('plan_maintitle_case', 'capitalize');

		if ($heading_case === 'uppercase') {
				$text_case = 'uppercase';
			} elseif ($heading_case === 'lowercase') {
			    $text_case = 'lowercase';
			} elseif ($heading_case === 'capitalize') {
			    $text_case = 'capitalize';
			} else {
			    $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
			}
			 
		// Alignment
		$heading_alignment = get_theme_mod('plan_maintitle_align', 'left');

		if ($heading_alignment === 'left') {
			  $text_alignment = 'left';
			} elseif ($heading_alignment === 'center') {
			    $text_alignment = 'center';
			} elseif ($heading_alignment === 'right') {
			    $text_alignment = 'right';
			} else {
			    $text_alignment = 'right'; // Default to 'left' if the setting is invalid
			}
	?>

	<?php
		$plan_subtitle = get_theme_mod('plan_subtitle', 'Building Plan');							
		$plan_title = get_theme_mod('plan_title', 'Lorem Ipsum ');
		$plan_title2 = get_theme_mod('plan_title2', 'Available');

		$plan_shortcode = get_theme_mod('plan_shortcode', '[Add Form shortcode]');
	?>	

	<div class="<?php echo esc_attr($c_width); ?>">		
		<div class="titlebx">
			<?php if( $plan_subtitle ){ ?>
			<div class="sub_title" style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($plan_subtitle); ?>
				<svg viewBox="0 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg">
				  <g transform="scale(-1, 1)" transform-origin="center">
				    <path d="M 2.5 8 L 0 10.5 L 2.5 13 L 4 13 L 2 11 L 19 11 L 19 10 L 2 10 L 4 8 L 2.5 8 z" 
				      style="fill-opacity:1; stroke:none; stroke-width:0px;"></path>
				  </g>
				</svg>
			</div>
			<?php }?>
			<h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($plan_title); ?></h3>
			<h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($plan_title2); ?></h3>
		</div>

		<div class="plan-img">
			<?php 
				$plan_image = get_theme_mod('plan_image');
				if(!empty($plan_image)){
					echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($plan_image).'" class="img-responsive secondry-bg-img" />';
				}else{
					echo '<img src="'.get_template_directory_uri().'/images/plan.png" class="img-responsive" />';
				}
			?>	
			
		</div>
		<div class="img-frm">
			<div class="pl-contact">
				<?php echo do_shortcode($plan_shortcode);?>
			</div>
		</div>
		<div class="clearfix"></div>
	</div>
</div> 
	<!-- plan Area Start -->
  

<?php } 