<?php   
if(get_theme_mod('project_area_disable') != 'on' ){ ?>

<div class="project-area " id="project" >
	<?php
		// width 
		$c_width = get_theme_mod('proj_c_width', 'container');

		    if ($c_width === 'container') {
				    $c_alignment = 'container';
				} elseif ($c_width === 'container-fluid') {
				    $c_alignment = 'container-fluid';
				} else {
				    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
				}

		// Heading Style
      	$heading_case = get_theme_mod('proj_maintitle_case', 'Capitalize');

			if ($heading_case === 'uppercase') {
					$text_case = 'uppercase';
				} elseif ($heading_case === 'lowercase') {
				    $text_case = 'lowercase';
				} elseif ($heading_case === 'capitalize') {
				    $text_case = 'capitalize';
				} else {
				    $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
				}
				 
		// Alignment
    	$heading_alignment = get_theme_mod('proj_maintitle_align', 'left');

		    if ($heading_alignment === 'left') {
				  $text_alignment = 'left';
				} elseif ($heading_alignment === 'center') {
				    $text_alignment = 'center';
				} elseif ($heading_alignment === 'right') {
				    $text_alignment = 'right';
				} else {
				    $text_alignment = 'right'; // Default to 'left' if the setting is invalid
				}
			
    ?>
   
	<div class="<?php echo esc_attr($c_width); ?> ">
		<div class="row">
		<?php	
			$proj_subtitle = get_theme_mod('proj_subtitle', 'Our Project');						
			$proj_title = get_theme_mod('proj_title', 'Lorem Ipsum available');
	
		?>
			<div class="sec-title-bx">
	    		<div class="section-title">				
	    		<?php if( $proj_subtitle ){ ?>
					<div class="sub_title"  style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;">
						<?php echo ($proj_subtitle); ?>
						<svg viewBox="0 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg">
						  <g transform="scale(-1, 1)" transform-origin="center">
						    <path d="M 2.5 8 L 0 10.5 L 2.5 13 L 4 13 L 2 11 L 19 11 L 19 10 L 2 10 L 4 8 L 2.5 8 z" 
						      style="fill-opacity:1; stroke:none; stroke-width:0px;"></path>
						  </g>
						</svg>
					</div>
				<?php }?>	
					<h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($proj_title); ?></h3>	
				</div>

				<div class="projects-tabs">
				    <ul>
				        <?php
				        // Get all categories for the 'projects_category' taxonomy
				        $terms = get_terms(array(
				            'taxonomy'   => 'projects_category',
				            'hide_empty' => false, // Show all categories, including those with no posts
				        ));

				        // Get the total number of published posts for 'our-projects'
				        $all_posts_count = wp_count_posts('our-projects')->publish;

				        if (!empty($terms)) {
				            // "All" Tab with total count of posts
				            echo '<li> <a href="#" class="projects-tab active" data-term-id="0">All Projects <sup>(' . esc_html($all_posts_count) . ') </sup> </a> </li>';

				            // Tabs for each category with post counts
				            foreach ($terms as $term) {
				                $term_post_count = $term->count;  // Get the number of posts in this category
				                echo '<li><a href="#" class="projects-tab" data-term-id="' . esc_attr($term->term_id) . '">' . esc_html($term->name) . ' (' . esc_html($term_post_count) . ')</a></li>';
				            }
				        }
				        ?>
				    </ul>
				</div>
 	 		</div>
<!-- -------- -->
		 	<div class="project-single-area marquee-wrapper">
			    <div class="project-R-bx  ">	        
		            <div class="row">
		                <?php
		                $showStatic = true;
		                $cols = absint(get_theme_mod('project_npp_count', 8)); // Default to 5 if not set

		                // Loop through project settings
		                for ($i = 1; $i <= $cols; $i++) {
		                    $projects_page_id = get_theme_mod('projects_page' . $i);
		                    $projects_page_icon = get_theme_mod('projects_page_icon' . $i);
		                    $projects_page_icon1 = get_theme_mod('projects_page_icon1' . $i);

		                    if ($projects_page_id) {
		                        $showStatic = false;
		                        echo projectShortCode($projects_page_id, $isCustomizer = true, $i);
		                    }
		                }

		                // Static fallback content if no project settings are found
		                if ($showStatic === true) {
		                    for ($i = 1; $i <= $cols; $i++) { ?>
                        <div class="<?php echo esc_attr($colCls); ?> single-project-bx marquee-item">
                            <div class="single-project">
                                <div class="project-icon">
                                    <a href="#">
                                        <img class="img-responsive" src="<?php echo esc_url(get_template_directory_uri() . '/images/project.jpg'); ?>" alt="Project Image" />
                                        <div class="pj_conbx">
                                            <div class="pj_con">
                                                <h3 class="title">Landscape Lighting</h3>
                                                <div class="txt">There are many variations</div>
                                                <div class="bttn">
                                                    <div class="icn">
                                                        <i class="fa fa-long-arrow-right"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
		                <?php }
		                	}
		                ?>
		            </div>
			       
			    </div>
			</div>

			<!--  -->
		</div>			
	</div>
</div>

<?php }