<?php   
if(get_theme_mod('service_area_disable') != 'on' ){ ?>
<div class="service-area " id="service" >	
<?php
	// Heading width 
	$c_width = get_theme_mod('ser_c_width', 'container');

    if ($c_width === 'container') {
		    $c_alignment = 'container';
		} elseif ($c_width === 'container-fluid') {
		    $c_alignment = 'container-fluid';
		} else {
		    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
		}

	// slider width 
	$sliderc_width = get_theme_mod('ser_slider_width', 'container-fluid');

    if ($sliderc_width === 'container') {
		    $sliderc_alignment = 'container';
		} elseif ($sliderc_width === 'container-fluid') {
		    $sliderc_alignment = 'container-fluid';
		} else {
		    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
		}

		// Heading Style
	$heading_case = get_theme_mod('ser_maintitle_case', 'capitalize');

	  if ($heading_case === 'uppercase') {
			$text_case = 'uppercase';
		} elseif ($heading_case === 'lowercase') {
		    $text_case = 'lowercase';
		} elseif ($heading_case === 'capitalize') {
		    $text_case = 'capitalize';
		} else {
		    $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
		}
		 
	// Alignment
	$heading_alignment = get_theme_mod('ser_maintitle_align', 'left');

if ($heading_alignment === 'left') {
	  $text_alignment = 'left';
	} elseif ($heading_alignment === 'center') {
	    $text_alignment = 'center';
	} elseif ($heading_alignment === 'right') {
	    $text_alignment = 'right';
	} else {
	    $text_alignment = 'right'; // Default to 'left' if the setting is invalid
	}
?>

<?php
	$ser_subtitle = get_theme_mod('ser_subtitle', 'Our Service');							
	$ser_title = get_theme_mod('ser_title', 'Lorem Ipsum available');

	$sersublink = get_theme_mod('sersublink', '#');	
?>	
	<div class="section-title">
		<!-- <div class="container"> -->
		<div class="<?php echo esc_attr($c_width); ?>">
			<div class="row mr-0">
				<div class="titlebx">
					<?php if( $ser_subtitle ){ ?>
					<div class="sub_title" style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($ser_subtitle); ?>
						<svg viewBox="0 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg">
						  <g transform="scale(-1, 1)" transform-origin="center">
						    <path d="M 2.5 8 L 0 10.5 L 2.5 13 L 4 13 L 2 11 L 19 11 L 19 10 L 2 10 L 4 8 L 2.5 8 z" 
						      style="fill-opacity:1; stroke:none; stroke-width:0px;"></path>
						  </g>
						</svg>
					</div>
					<?php }?>
					<h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($ser_title); ?></h3>
				</div>
				<div class="sub-imgbx">
					<a href="<?php echo ($sersublink);  ?>" >
					<?php 
						$ser_subimg = get_theme_mod('ser_subimg');
						if(!empty($ser_subimg)){
							echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($ser_subimg).'" class="img-responsive secondry-bg-img" />';
						}else{
							echo '<img src="'.get_template_directory_uri().'/images/ser-subtitle.jpg" class="img-responsive" />';
						}
					?>		
					</a>
					<!-- img button  -->
					<div class="ser-sub-btn">						
						<a href="<?php echo ($sersublink);  ?>" >
							<i class="fa fa-long-arrow-left"></i>
						</a>					
					</div>					
				</div>
			</div>
		</div>
	</div>
	
	<div class="<?php echo esc_attr($sliderc_width); ?>">
		<div class="service-single-area " > 
			<div class="serbx">
				<div class=" swiper" >
					<div class="swiper-wrapper"> 
						<?php 
						$showStatic = true;
						$cols = get_theme_mod('service_npp_count', 5);
						$cols++;
						switch($cols){
							case 1:
							$colCls = 'col-lg-12 col-md-12 col-sm-12';
							break;
							case 2:	
							$colCls = 'col-lg-6 col-md-6 col-sm-6';
							break;
							case 3:
							case 5:
							case 6:
							case 9:
							case 11:
							case 13:
							case 15:
							$colCls = 'col-lg-4 col-md-6 col-sm-6';
							break;
							default: 
							$colCls = 'col-lg-4 col-md-6 col-sm-6';
							break;
						}
							
					for( $i = 1; $i <= $cols; $i++ ){
						$services_page_id = get_theme_mod('services_page'.$i); 
						$services_page_icon = get_theme_mod('services_page_icon'.$i);
						$services_page_icon1 = get_theme_mod('services_page_icon1'.$i);
						if($services_page_id){
							$showStatic = false;
							echo serviceShortCode($services_page_id, $isCustomizer=true, $i);
						}
					}
				if($showStatic === true){
					for( $i = 1; $i <= $cols; $i++ ){ ?>
					<div class="swiper-slide  single-service-bx"> 
						<div class="single-service ">
							<div class="service-icon">
								<a href="#">
									<img class="img-responsive" src="<?php echo esc_url(get_template_directory_uri().'/images/ser2.jpg');?>" alt="services" /> 
								</a>
								<div class="sertxbx">										
									<a href="#">
										<h4 class="post-title inner-area-title ">Electrical Repairs</h4>
									</a>
									<p class="section-area-text">
										There are many variations of passages of Lorem Ipsum available, but the slightly believable.
									</p>	
								</div>	
							</div>							
						</div>
						<div class="clearfix"></div>	
					</div>
					<?php 
						}
					} ?>
				</div>
				<div class="nav-btn">
				 	<div class="swiper-button-next"> <i class="fa fa-angle-right"></i></div>
  					<div class="swiper-button-prev"> <i class="fa fa-angle-left"></i></div>
  				</div>
			</div>
			</div>
		</div>
	</div>
</div>
<script type="text/javascript">
const swiper = new Swiper(".swiper", {
  direction: "horizontal",
  loop: true,
  speed: 1500,
  spaceBetween: 0,
  mousewheel: false,
  parallax: true,
  centeredSlides: true,
  autoplay: true,
  effect: "coverflow",
  coverflowEffect: {
    rotate: 0,
    slideShadows: true
  },
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
  breakpoints: {
    0: {
      slidesPerView: 1,
      spaceBetween: 20
    },
    600: {
      slidesPerView: 2,
      spaceBetween: 20
    },
    991: {
      slidesPerView: 3,
      spaceBetween: 10
    },
    1400: {
      slidesPerView: 4,
      spaceBetween: 90
    },
    2300: {
      slidesPerView: 4,
      spaceBetween: 90
    },
    2900: {
      slidesPerView: 4,
      spaceBetween: 90
    }
  }
});

</script>
<?php }