<?php
/**
 *
 * @package Slider Premium
 */
?>
<?php $showContent = get_theme_mod('slider_section_show_content', 'on'); ?>
<div class="slider_section" id="slider">
    <div class="owl-slider">
        <div id="carousel" class="owl-carousel">
            <?php
            $args = array( 'post_type' => 'slider', 'orderby'   => 'id', 'order' => 'DESC',);
            if(!empty($pageId)){
                $args['page_id'] = absint($pageId);

            }
            $text = '';
            $query = new WP_Query($args);
            if($query->have_posts()){
                while($query->have_posts()) : $query->the_post(); 
                
                if( get_theme_mod('slider_areaOpacity',true) ) {
                    $slider_areaOpacity = 'opacity:'.esc_attr(get_theme_mod('slider_areaOpacity')).';';
                }
                if( get_theme_mod('slider_Tfontsize',true) ) {
                    $slider_Tfontsize = 'font-size:'.esc_attr(get_theme_mod('slider_Tfontsize')).';';
                }

                $pageLink = '';
                $slider_btn_link = get_post_meta($post->ID,'slider_btn_link',false);
                $sliderBtnTxt = get_post_meta($post->ID,'sliderBtnTxt',false);
                if(!empty($slider_btn_link) && is_array($slider_btn_link)){
                    $pageLink = esc_url(get_permalink($slider_btn_link[0]));
                }
                if(!empty($sliderBtnTxt) && is_array($sliderBtnTxt)){
                    $pageLinkTxt = $sliderBtnTxt[0];
                }else{
                    $pageLinkTxt = "Let's talk";
                }

                $sliderSubtitle = get_post_meta($post->ID, 'sliderSubtitle', false);
                $sliderdatetext = !empty($sliderSubtitle[0]) ? $sliderSubtitle[0] : '';

            ?>
            <div class="item">
                <div class="imbx " data-wow-duration="1s">
                    <?php 
                        if(has_post_thumbnail()){
                            $total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'full');  
                            echo '<img class="slide-mainimg" alt="'. esc_html(get_the_title()) .'" src="'.esc_url($total_slider_image[0]).'">';
                    }?>

                      
                    <?php if( get_theme_mod('seccrib_display','show' ) == 'show') :?>
                        <div class="s_cir"></div>
                        <div class="b_cir"></div>
                     <?php endif ?>

                    <div class="overlay"></div>
                    <?php if($showContent == 'on'){ ?>
                    <div class="slider_content " data-wow-duration="1s">                
                        <div class="slider_title animated bounceInDown" data-wow-duration="1s">
                            <?php echo (get_the_title()); ?>   
                            <div class="t-brd"></div>
                        </div>                    

                        <?php  if(!empty($sliderdatetext)){ ?>
                        <div class="slider_sub_title animated bounceInDown " data-wow-duration="1s">
                            <?php echo $sliderdatetext; ?>
                        </div>
                        <?php }?>
                        
                        <?php 
                        if(!empty($pageLink)){ ?>
                        <div class="slide-btna animated bounceInLeft">
                            <div class="btn5">  
                                <a href="<?php echo $pageLink; ?>">
                                    <?php echo($pageLinkTxt); ?> <span class="fa fa-long-arrow-right"></span>
                                </a>
                            </div>
                        </div>
                        <?php }?>
                    </div>
                    <?php }?>
                </div>
            </div>
            <?php
                endwhile;
            }else{ 
                for($i=0;$i<6;$i++){?>
            <div class="item">
                <div class="imbx " data-wow-duration="1s">
                    <?php echo '<img class="slide-mainimg" alt="Slider" src="'. esc_html(get_template_directory_uri()) .'/images/slider.png">';?>

                    <?php if( get_theme_mod('seccrib_display','show' ) == 'show') :?>
                    <div class="s_cir"></div>
                    <div class="b_cir"></div>
                     <?php endif ?>
                     
                    <div class="overlay"></div>
                    <?php if($showContent == 'on'){?>     
                    <div class="slider_content" data-wow-duration="1s">
                        <div class="slider_title animated bounceInDown" data-wow-duration="1s">
                            ARCHI  
                            <div class="t-brd"></div>
                        </div>
                        <div class="slider_sub_title animated bounceInDown " data-wow-duration="1s">
                            TECTURE
                        </div>             
                        <div class="slide-btna animated bounceInLeft">
                            <div class="btn5">
                                <a href="#">
                                    <?php _e( "Let's talk" , 'luzuk-premium' ); ?><span class="fa fa-long-arrow-right"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php }?>    
                </div>
            </div>
                <?php }
            }?>
        </div>
    </div>
</div>
<script>
        $(document).ready(function() {
          $('.slider_section .owl-carousel').owlCarousel({
            refreshClass: 'owl-refresh',
            autoplayTimeout:6000,
            loop: true,
            margin: 30,
            autoHeight: true,
            autoWidth: false,
            autoplay: true,
         //   animateOut: 'lightSpeedOut',
           // animateIn: 'zoomIn',
            navText: [
                    '<i class="fa fa-caret-left"></i> ',
                    '<i class="fa fa-caret-right" ></i>'
                ],
            responsiveClass: true,

            responsive: {
              0: {
                items: 1,
                nav: true,
                margin: 10
              },
              600: {
                items:1,
                nav: true,
                margin: 10
              },
              1000: {
                items:1,
                nav: true,
                loop: true,
                margin: 10
              }
            }
          })
        })

</script>
