<?php
/**
 * Template Name: Blog Full Width  
 *
 * @package luzuk Premium
 */
get_header(); 
?>
<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>

<header class="page-main-header"  >
    <div class="container">   
        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
        <div class="bdcrmbox ">
            <div class="breadcrumbbox ">
                <div class='button'>
                  <?php luzuk_lite_the_breadcrumb(); ?> </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <?php endif ?>
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?> 
        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</header>

<main id="innerpage-box">
    <?php
        // width 
        $c_width = get_theme_mod('innpg_c_width', 'container');

        if ($c_width === 'container') {
            $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
            
    ?>
    <div class="<?php echo esc_attr($c_width); ?>">
        <div class="inner_contentbox">
            <div id="blog-box" class="ht-blog-wrap innerpage-whitebox ">
                <div class="row mr-0">
              <?php
                $current_page = max(1, get_query_var('paged'));
                $luzuk_blog_cat_exclude = get_theme_mod('luzuk_blog_categories');
                $luzuk_blog_cat_exclude = explode(',', $luzuk_blog_cat_exclude);
                $excerpt = get_theme_mod('luzuk_blog_categories_settings');
                $args = array(
                    'category__not_in' => $luzuk_blog_cat_exclude,
                    // 'page'=,
                    'paged'=> $current_page,

                );
                $query = new WP_Query($args);
                if($query -> have_posts()):
                    while($query -> have_posts()) : $query -> the_post();
                     $luzuk_image = wp_get_attachment_image_src(get_post_thumbnail_id() , 'total-blog-thumb');
                     $img = (has_post_thumbnail())?esc_url($luzuk_image[0]):get_template_directory_uri().'/images/default.png';
                     ?>
                 <div class="inner-blog-post col-lg-6 col-md-6 col-sm-6 col-xs-12 ">
                    <?php 
                        $blgtxtlimit = get_theme_mod('blgtxtlimit', '70');
                    ?> 
                    <div class="inner-blogpost">
                        <div class="ht-blog-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                <img class="inner-blog-img" src="<?php echo $img; ?>" alt="<?php the_title(); ?>">
                            </a>
                            <div class="inner-blogpost-info">
                                <div class="blog-admbx">
                                    <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :?>
                                        <li> <?php echo get_the_date( 'M j, Y' ); ?></li>
                                    <!-- <li class="b_ath"> <i class="fa fa-comments-o" ></i> </?php echo get_the_author(); ?></li> -->
                                    <?php endif ?>
                                </div>
                                <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
                                    
                                <div class="inner-blog-excerpt">
                                <?php 
                                   if (has_excerpt()) {
                                              echo get_the_excerpt();
                                      } else {
                                          echo luzuk_excerpt(get_the_content(),$blgtxtlimit );  
                                   }
                                ?>                         
                                </div>
                                <?php
                                    $blog_button2 = get_theme_mod('blog_button2', 'Read More');
                                ?>
                                <div class="blog-btn">
                                    <?php if($blog_button2 ){ ?>    
                                        <a href="<?php echo esc_url(get_permalink()); ?>">
                                           <?php echo ($blog_button2);  ?> 
                                        </a>

                                    <?php }?>
                                </div>
                            </div> 
                        </div>
                                          
                        <div class="clearfix"></div>
                    </div>
                    <script type="text/javascript">
                        var title = 0;
                        jQuery(".page-template-blog-left-sidebar .inner-blogpost").each(function(){
                          if ($(this).height() > title) { title = $(this).height(); }
                        });
                        jQuery(".page-template-blog-left-sidebar .inner-blogpost").height(title);


                        // on Resize change height

                        jQuery(window).resize(function(){
                          jQuery(".page-template-blog-left-sidebar .inner-blogpost").height("");
                          var title = 0;
                          jQuery(".page-template-blog-left-sidebar .inner-blogpost").each(function(){
                            if ($(this).height() > title) { title = $(this).height(); }
                          });
                          jQuery(".page-template-blog-left-sidebar .inner-blogpost").height(title);
                        });
                    </script>
                 </div> 
                   <?php
                       endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                    <div class="clearfix"></div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="row mr-0">
                <div class="col-md-12">
                    <div class="pagingation">
                         <?php lzGetPagination($query);?>
                    </div>
                </div>
            </div>
          <div class="clearfix"></div>
      
      </div>
    </div>
</main>
<?php get_template_part('template-parts/section','ourclients'); ?>
<?php get_footer(); ?>
