<?php
/**
 * Template Name: Contact Page
 *
 * @package luzuk Premium
 */
get_header(); 
?>

<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>

<header class="page-main-header" >
    <div class="container">   
        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
        <div class="bdcrmbox ">
            <div class="breadcrumbbox ">
                <div class='button'>
                  <?php luzuk_lite_the_breadcrumb(); ?> </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <?php endif ?>
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?> 
        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</header>
<main id="innerpage-box" >
	<?php
        // width 
        $c_width = get_theme_mod('innpg_c_width', 'container');

        if ($c_width === 'container') {
            $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
            
    ?>
	<?php 

		$scodetitle = get_theme_mod('scodetitle', 'Get In Touch!');
		$shortcode = get_theme_mod('luzuk_contactus_shortcode', 'Add form shortcode ');
			
		$addtitle = get_theme_mod('lzk_contactpg_addtitle', 'Our Address');
		$address = get_theme_mod('luzuk_contactus_address', 'Add Address here..');
		
		$emailtitle = get_theme_mod('lzk_contactpg_emailtitle', 'Email');
		$email = get_theme_mod('luzuk_contactus_email', 'Info@Gmail.Com');

		$phonetitle = get_theme_mod('lzk_contactpg_phtitle', 'Support 24/7');	
		$phone = get_theme_mod('luzuk_contactus_phone', '+ 1111-222-333');
						
	?>	
	<div class="contact-address-area ">
		<div class="<?php echo esc_attr($c_width); ?>"> 
			<div class="row mr-0">	
				<div class="col-lg-6 col-md-12 col-sm-12 ">
					<div class="conbx ">
						<div class="cntpgbx ">
						   	<?php if(  $address || $addtitle ){ ?>
						   	<div class="cntpgbxinn">
						   		<div class="cntpgtxt">	
						   			<div class="row mr-0">			
						   				<div class="icnbx">	   		
						   					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48"><defs><style>.cls-1{fill:#201602}</style></defs><g id="Layer_2" data-name="Layer 2"><g id="layer_1-2" data-name="layer 1"><path class="cls-1" d="M9 48H1a1 1 0 0 1-1-1V1a1 1 0 0 1 1-1h30v2H2v44h7zM47 48h-4v-2h3V18h2v29a1 1 0 0 1-1 1z"/><path class="cls-1" d="M4 4h2v2H4zM8 4h2v2H8zM12 4h2v2h-2zM1 8h27v2H1zM15 48a1 1 0 0 1-.53-.15C14.13 47.64 6 42.53 6 35a9 9 0 0 1 18 0c0 7.53-8.13 12.64-8.47 12.85A1 1 0 0 1 15 48zm0-20a7 7 0 0 0-7 7c0 5.42 5.29 9.59 7 10.79 1.71-1.21 7-5.39 7-10.79a7 7 0 0 0-7-7z"/><path class="cls-1" d="M15 39a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zM39 22a1 1 0 0 1-.53-.15C38.13 21.64 30 16.53 30 9a9 9 0 0 1 18 0c0 7.53-8.13 12.64-8.47 12.85A1 1 0 0 1 39 22zm0-20a7 7 0 0 0-7 7c0 5.42 5.29 9.59 7 10.79 1.71-1.21 7-5.39 7-10.79a7 7 0 0 0-7-7z"/><path class="cls-1" d="M39 13a4 4 0 1 1 4-4 4 4 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2 2 0 0 0-2-2zM35 48H15v-2h20a5 5 0 0 0 5-5v-1a5 5 0 0 0-5-5h-2a7 7 0 0 1-7-7v-1a7 7 0 0 1 7-7h6v2h-6a5 5 0 0 0-5 5v1a5 5 0 0 0 5 5h2a7 7 0 0 1 7 7v1a7 7 0 0 1-7 7z"/></g></g></svg>	
								   			<!-- <i class="fa fa-home" ></i> -->
								   		</div>
								   		<div class="cntpgdet">
								   			<h5><?php echo $addtitle;?></h5>
								   			<p><?php echo $address;?></p>
								   		</div>
						   			</div>
						   		</div>
								<div class="clearfix"></div>
							</div>
						   <?php } ?>
						  
						   	<?php if(  $email  ){ ?>
						   	<div class="cntpgbxinn"> 
						   		<div class=" cntpgtxt">		
						   			<div class=" row mr-0">	
						   				<div class="icnbx">
						   					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><g data-name="18-Mail"><path d="M28 32H4a4 4 0 0 1-4-4V12a4 4 0 0 1 4-4h2a1 1 0 0 1 0 2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h24a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2h-2a1 1 0 0 1 0-2h2a4 4 0 0 1 4 4v16a4 4 0 0 1-4 4z"/><path d="M16 22a1 1 0 0 1-.618-.214l-14-11a1 1 0 1 1 1.236-1.572L16 19.728 29.382 9.214a1 1 0 1 1 1.236 1.572l-14 11A1 1 0 0 1 16 22z"/><path d="M2 31a1 1 0 0 1-.707-1.707l11-11a1 1 0 0 1 1.414 1.414l-11 11A1 1 0 0 1 2 31zM30 31a1 1 0 0 1-.707-.293l-11-11a1 1 0 0 1 1.414-1.414l11 11A1 1 0 0 1 30 31zM26 14a1 1 0 0 1-1-1V2H7v11a1 1 0 0 1-2 0V2a2 2 0 0 1 2-2h18a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1z"/><path d="M21 7H11a1 1 0 0 1 0-2h10a1 1 0 0 1 0 2zM21.064 12H11a1 1 0 0 1 0-2h10.064a1 1 0 0 1 0 2z"/></g></svg>
						   				</div>					   			
							   			<div class="cntpgdet">
							   				<h5><?php echo $emailtitle;?></h5>
								   			<a href="mailto:<?php echo $email;?>"><p><?php echo $email;?></p></a>
								   		</div>
								   	</div>
						   		</div>
							   	<div class="clearfix"></div>
						    </div>
						   	<?php } ?>

						   	<?php if(  $phone  || $phonetitle){ ?>
						   	<div class="cntpgbxinn">
							   	<div class=" cntpgtxt">		
							   		<div class="row mr-0">	
							   			<div class="icnbx">	  
									   		<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><defs><style>.cls-1{fill:#231f20}</style></defs><g id="phone"><path class="cls-1" d="M23.5 2h-13a.5.5 0 0 0-.5.5v17a.5.5 0 0 0 .5.5h.82a2.23 2.23 0 0 1-.44 2.44 2.18 2.18 0 0 1-1.71.56A2 2 0 0 1 8 22.49a2.26 2.26 0 0 1-.21-2.6.52.52 0 0 0 .21-.39V16a.49.49 0 0 0-.39-.48l-1.31-.35c-1.11-.26-1.3-1-1.3-2.63v-3c0-1.58.2-2.39 1.36-2.64l1.25-.27A.49.49 0 0 0 8 6.1V2.5a.5.5 0 0 0-.5-.5H4.89A3.82 3.82 0 0 0 1 5.72v10.56A3.82 3.82 0 0 0 4.89 20h1.79a3.1 3.1 0 0 0 .64 3.21 3.14 3.14 0 0 0 1.74.79h.33a3.25 3.25 0 0 0 2.17-.85 3.14 3.14 0 0 0 .81-3.15H23.5a.5.5 0 0 0 .5-.5v-17a.5.5 0 0 0-.5-.5zM2 16.28V5.72A2.81 2.81 0 0 1 4.89 3H7v2.7l-.86.19C4 6.35 4 8.33 4 9.5v3c0 1.24 0 3.12 2.08 3.6l.92.22V19H4.89A2.81 2.81 0 0 1 2 16.28zM23 19H11V3h12z"/><path class="cls-1" d="M13.5 9h7a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-7a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5zm.5-3h6v2h-6zM13.5 11h1a.5.5 0 0 0 0-1h-1a.5.5 0 0 0 0 1zM17.5 10h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zM20.5 10h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zM13.5 14h1a.5.5 0 0 0 0-1h-1a.5.5 0 0 0 0 1zM17.5 13h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zM20.5 13h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zM13.5 17h1a.5.5 0 0 0 0-1h-1a.5.5 0 0 0 0 1zM17.5 16h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zM20.5 16h-1a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1z"/></g></svg>
									   	</div>
								   		<div class="cntpgdet">		
								   			<h5><?php echo $phonetitle;?></h5>		  	
									   		<a class="" href="tel:<?php echo $phone;?>"><p><?php echo $phone;?></p></a>
									   	</div>
								   	</div>
						   		</div>
							   	<div class="clearfix"></div>
						  	</div>
						   	<?php } ?>
					    </div>							
						<div class="clearfix"></div>	
					</div>
				</div>
				
				<div class="col-lg-6 col-md-12 col-sm-12 ">			
					<?php if(  $scodetitle || $shortcode ){ ?>			
					<div id="ht-contactus-wrap">	
						<div class="fmbx">													
							<div class="conformbx">	
					         	<div class="maintle inner-area-title"><?php echo $scodetitle;?></div>	
			     			</div>		     			
			          		<div class="ctform"><?php echo do_shortcode($shortcode);?></div>		
							<div class="clearfix"></div>	
						</div>											
					</div>				
					<?php } ?>				    
				</div>	
			</div>			
		</div>
		<?php 
			$phbtm = get_theme_mod('phbtm', '+0 (1234)-567-8901');
			$debxheading = get_theme_mod('debxheading', 'Consult The Services');
			$debxtitle = get_theme_mod('debxtitle', 'You Need Now!');
			$debxtxt = get_theme_mod('debxtxt', 'Lorem Ipsum Dolor Sit Amet, Consectetur Adipiscing Elit. Sed Do Eiusmod Tempor Incididunt Ut Labore Et Dolore Magna Aliqua. Ut Enim Ad Minim Veniam.');
			$debxlst = get_theme_mod('debxlst', '<li>Lorem Ipsum Dolor Sit Amet</li>
<li>Labore Et Dolore Magna Aliqua.</li>
<li>Eiusmod Tempor Incididunt</li>
<li>Lorem Ipsum Dolor Sit Amet, Adipiscing Elit</li>');

		?>	
		<div class="con-de-bx">
			<div class="row mr-0">
				<div class="imbx">
					<div class="imgbx-inn">
						<?php 
							$conpg_subimg = get_theme_mod('conpg_subimg');
							if(!empty($conpg_subimg)){
								echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($conpg_subimg).'" class="img-responsive secondry-bg-img" />';
							}else{
								echo '<img src="'.get_template_directory_uri().'/images/contacpg.png" class="img-responsive" />';
							}
						?>	
					</div>	
				</div>
				<div class="con-de-bxinn">
					<div class="heading inner-area-title"><?php echo $debxheading;?></div>
					<div class="title inner-area-title"><?php echo $debxtitle;?></div>
					<div class="txt"><?php echo $debxtxt;?></div>
					<div class="list"><?php echo $debxlst;?> <div class="clearfix"></div></div>
					<?php if( $phbtm ){ ?>
					<div class="ph">
						<a class="" href="tel:<?php echo $phbtm;?>"><i class="fa fa-phone" ></i> <?php echo $phbtm;?></a>
					</div>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
	<div class="clearfix"></div>
</main>
<?php get_template_part('template-parts/section','ourclients'); ?>
<?php get_footer(); ?>