
<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package luzuk
 */
get_header(); ?>
<div class="clearfix"></div>
<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
<header class="page-main-header"  >
    <div class="container">   
        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
        <div class="bdcrmbox ">
            <div class="breadcrumbbox ">
                <div class='button'>
                  <?php luzuk_lite_the_breadcrumb(); ?> </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <?php endif ?>
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?> 

        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</header>



<div class="single-productpage">
	<?php
    // width 
    $single_c_width = get_theme_mod('single_c_width', 'container');

    if ($single_c_width === 'container') {
        $c_alignment = 'container';
    } elseif ($single_c_width === 'container-fluid') {
        $c_alignment = 'container-fluid';
    } else {
        $text_alignment = 'container'; // Default to 'container' if the setting is invalid
    }
        
?>
	<main id="innerpage-box">
		<div id="page" class="<?php echo esc_attr($single_c_width); ?>" >
			<div class="inner_contentbox" >		
				<article id="content" class="article single_inner">
					<?php do_action('woocommerce_before_main_content'); ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php wc_get_template_part( 'content', 'single-product' ); ?>
						<?php endwhile; // end of the loop. ?>
				</article>
				<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
		</div>
	</main><!-- #primary -->	
</div>
<div class="clearfix"></div>
<?php get_template_part('template-parts/section','ourclients'); ?>
<?php get_footer(); ?>

