<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3.2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'about_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_heading',
        array(
            'settings'      => 'about_image_heading',
            'section'       => 'about_area',
            'label'         => __( 'Section Left Image', 'luzuk-premium' ),
        )
    )
);

lzCustomLable($wp_customize, 'about_leftimg', 'about_area' , 'Select Image');

$wp_customize->add_setting(
    'about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_image',
            'description' => __('Recommended Image Size: 390X490px', 'luzuk-premium')
        )
    )
);  

$wp_customize->add_setting(
    'aboutleftimg_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'YOUR CLOTH', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'aboutleftimg_title',
    array(
        'settings'      => 'aboutleftimg_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Left Image Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_leftimgtitleClr', 'about_area', 'Left Image Title Color', '#b4b5b8');

lzCustomLable($wp_customize, 'about_sicon', 'about_area' , 'Social Media Setting');

// TWITTER
$wp_customize->add_setting('app_tw', array('default'=> 'https://twitter.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_tw',
    array(
        'settings'      => 'app_tw',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

//Instagram
$wp_customize->add_setting('app_insta',array('default'=> 'https://www.instagram.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_insta',
    array(
        'settings'      => 'app_insta',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

// FACEBOOK 
$wp_customize->add_setting('app_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_fb',
    array(
        'settings'      => 'app_fb',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);

//Pinterest
$wp_customize->add_setting('app_ytube',array('default'=> 'https://www.pinterest.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('app_ytube',
    array(
        'settings'      => 'app_ytube',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Pinterest Url', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_socialicnClr', 'about_area', 'Social Icon Color', '#F69404');

$wp_customize->add_setting(
    'about_rghtimage_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_rghtimage_heading',
        array(
            'settings'      => 'about_rghtimage_heading',
            'section'       => 'about_area',
            'label'         => __( 'Section Right Image', 'luzuk-premium' ),
        )
    )
);

lzCustomLable($wp_customize, 'about_rghtimg', 'about_area' , 'Select Image');

$wp_customize->add_setting(
    'about_image1',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image1',
        array(
            'section' => 'about_area',
            'settings' => 'about_image1',
            'description' => __('Recommended Image Size: 390X438px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'aboutrghtimg_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'ABOUT US', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'aboutrghtimg_title',
    array(
        'settings'      => 'aboutrghtimg_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Right Image Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_rghtimgtitlebrdClr', 'about_area', 'Right Image Title Border Color', '#F69404');

addColorPalatOption($wp_customize, 'about_area_rghtimgtitleClr1', 'about_area', 'Right Image Title Color 1', '#F69404');

addColorPalatOption($wp_customize, 'about_area_rghtimgtitleClr2', 'about_area', 'Right Image Title Color 2', '#fff');

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Heading & text', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Curating Trends, Celebrating Individuality', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Porttitor pharetra sollicitudin at tempus phasellus consequat ultrices class sed, quisque non hac diam porta himenaeos fringilla scelerisque, nibh tellus sociosqu molestie conubia sodale.' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'about_list',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<li>Our Mission </li> <li>Sustainable Practices </li> <li>Vision for Fashion </li> <li>Style for Every Story</li> ', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_list',
    array(
        'settings'      => 'about_list',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'List Text', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'aboutarea_rhsAboutPlan', 'about_area', 'Number Of About Plan To Show');

$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_area',
        'type'          => 'select',
        'label'         => __( 'Number Of About Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 4; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'About Plan ', 'luzuk-premium' ).$i
            )
        )
    );

//lzAddImageElement($wp_customize, 'aboutus_page_icon'.$i, 'about_area', $label="Recommended Image Size: 150X150px");

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-truck',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'about_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Delivery to all regions');

lzAddElement($wp_customize, 'aboutus_page_text'.$i, 'about_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Porttitor pharetra sollicitudin at tempus phasellus consequat');

}

lzCustomLable($wp_customize, 'abtbtn', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More' )
    )
);
$wp_customize->add_control(
    'abtbtntxt',
    array(
        'settings'      => 'abtbtntxt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('abtbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Add Button Link', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'Sec_abtclor', 'about_area' , 'About Section Color');

addColorPalatOption($wp_customize, 'about_area_sectitle_clr', 'about_area', 'Heading Color ', '#383838');

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Text Color', '#3A3A3A');

addColorPalatOption($wp_customize, 'about_area_listicn', 'about_area', 'List Icon Color', '#000');

addColorPalatOption($wp_customize, 'about_area_listclr', 'about_area', 'List Color', '#383838');

addColorPalatOption($wp_customize, 'about_area_planicnclr', 'about_area', 'Plan Icon Color', '#F69404');

addColorPalatOption($wp_customize, 'about_area_plantitleclr', 'about_area', 'Plan Title Color', '#383838');

addColorPalatOption($wp_customize, 'about_area_plantextclr', 'about_area', 'Plan Text Color', '#383838');

addColorPalatOption($wp_customize, 'about_area_btntext', 'about_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_btntexthv', 'about_area', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_btnbg', 'about_area', 'Button BG Color', '#F69404');

addColorPalatOption($wp_customize, 'about_area_btnbghv', 'about_area', 'Button BG Hover Color', '#272932');
