<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
	$cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
	'blog_area',
	array(
		'title' => __( 'Blog Section', 'luzuk-premium' ),
		'panel' => 'luzuk_premium_home_panel',
     	//'priority' => '50',
	)
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
	'blog_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'blog_section_disable',
		array(
			'settings'      => 'blog_section_disable',
			'section'       => 'blog_area',
			'label'         => __( 'Disable Section', 'luzuk-premium' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'luzuk-premium' ),
				'off' => __( 'No', 'luzuk-premium' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
	'blog_title_subtitle_heading',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text'
	)
);
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'blog_title_subtitle_heading',
		array(
			'settings'		=> 'blog_title_subtitle_heading',
			'section'       => 'blog_area',
			'label'         => __( 'Section Heading ', 'luzuk-premium' ),
		)
	)
);

$wp_customize->add_setting(
	'blog_title',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'BLOG & NEWS', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blog_title',
	array(
		'settings'      => 'blog_title',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Heading', 'luzuk-premium' )
	)
);

$wp_customize->add_setting(
	'blogsubtitle',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default'           => __( 'Read Our Beauty Tips & Hacks', 'luzuk-premium' )
	)
);
$wp_customize->add_control(
	'blogsubtitle',
	array(
		'settings'      => 'blogsubtitle',
		'section'       => 'blog_area',
		'type'          => 'text',
		'label'         => __( 'Text', 'luzuk-premium' )
	)
);

addColorPalatOption($wp_customize, 'blogarea_sectitle_color', 'blog_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_sectitlebrd_color', 'blog_area', 'Heading Border Color', '#6EA2DE');

addColorPalatOption($wp_customize, 'blogarea_secsubtitle_color', 'blog_area', 'Text Color', '#000');

lzCustomLable($wp_customize, 'blog_area_blogspost', 'blog_area', 'Number Of Post ');
//BLOG SETTINGS
$wp_customize->add_setting(
	'blog_post_count',
	array(
		'default'           => '3',
		'sanitize_callback' => 'luzuk_sanitize_choices'
	)
);
$wp_customize->add_control(
	new luzuk_Dropdown_Chooser(
		$wp_customize,
		'blog_post_count',
		array(
			'settings'      => 'blog_post_count',
			'section'       => 'blog_area',
			'label'         => __( 'Number Of Post To Show', 'luzuk-premium' ),
			'choices'       => $luzuk_post_count_choice
		)
	)
);

// $wp_customize->add_setting(
// 	'blog_cat_exclude',
// 	array(
// 		'sanitize_callback' => 'luzuk_sanitize_text'
// 	)
// );
// $wp_customize->add_control(
// 	new luzuk_Customize_Checkbox_Multiple(
// 		$wp_customize,
// 		'blog_cat_exclude',
// 		array(
// 			'label' => __('Exclude Category from Blog Posts', 'luzuk-premium'),
// 			'section' => 'blog_area',
// 			'settings' => 'blog_cat_exclude',
// 			'choices' => $luzuk_cat
// 		)
// 	)
// );
// END BLOG SECTION FOR HOME PAGE
/****************************/


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
	'premium_blog_area',
	array(
		'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
		'priority' =>19
	)
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Checkbox_Multiple(
		$wp_customize,
		'luzuk_blog_categories',
		array(
			'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
			'section' => 'premium_blog_area',
			'settings' => 'luzuk_blog_categories',
			'choices' => $luzuk_cat
		)
	)
); 

lzCustomLable($wp_customize, 'blog_area_color', 'blog_area', 'Section Color Settings');

addColorPalatOption($wp_customize, 'blogarea_iconadmin_color', 'blog_area', 'Admin Text And Date Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_iconadminbg_color', 'blog_area', 'Admin Text And Date BG Color', '#F69404');

addColorPalatOption($wp_customize, 'blogarea_Title_color', 'blog_area', 'Title Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_text_color', 'blog_area', 'Text Color', '#8E8383');


lzCustomLable($wp_customize, 'luzuk_secblog_sbtnclr', 'blog_area', 'Section Button Setting');
$wp_customize->add_setting(
    'blog_button1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Read More', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_button1',
    array(
        'settings'      => 'blog_button1',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'blogarea_btnarroclr', 'blog_area', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'blogarea_btntxthvclr', 'blog_area', 'Button Text Hover Color', '#F69404');