<?php 
    $wp_customize->add_section(
        'featuredproducts_area',
        array(
            'title' => __( 'Feature Products Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'featuredproducts_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'featuredproducts_area_disable',
            array(
                'settings'      => 'featuredproducts_area_disable',
                'section'       => 'featuredproducts_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

//backgroundManager($wp_customize, 'featuredproductsus', 'featuredproducts_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'featuredproductsarea_padding', 'featuredproducts_area', 'Section Padding');

$wp_customize->add_setting(
    'featuredproducts_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'featuredproducts_areaTpadding',
    array(
        'settings'      => 'featuredproducts_areaTpadding',
        'section'       => 'featuredproducts_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'featuredproducts_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'featuredproducts_areaBpadding',
    array(
        'settings'      => 'featuredproducts_areaBpadding',
        'section'       => 'featuredproducts_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'featuredproducts_leftimg', 'featuredproducts_area' , 'Select Image');

$wp_customize->add_setting(
    'feaproducts_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'feaproducts_image',
        array(
            'section' => 'featuredproducts_area',
            'settings' => 'feaproducts_image',
            'description' => __('Recommended Image Size: 402X563px', 'luzuk-premium')
        )
    )
);  

lzCustomLable($wp_customize, 'feature_headingtxt', 'featuredproducts_area', 'Section Heading And Sub Heading');

$wp_customize->add_setting(
        'featuredproductsubtitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'BEAUTIFUL CLAOT', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'featuredproductsubtitle',
        array(
            'settings'      => 'featuredproductsubtitle',
            'section'       => 'featuredproducts_area',
            'type'          => 'text',
            'label'         => __( 'Sub Heading', 'luzuk-premium' )
        )
    );

$wp_customize->add_setting(
        'feature_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Complete Your Perfect Look', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'feature_title',
        array(
            'settings'      => 'feature_title',
            'section'       => 'featuredproducts_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );
    
lzCustomLable($wp_customize, 'featuredproductsarea_clr', 'featuredproducts_area', 'Section Color Setting');

addColorPalatOption($wp_customize, 'featuredproducts_area_sectionbgClr1', 'featuredproducts_area', 'Section BG Color 1', '#F69404');

addColorPalatOption($wp_customize, 'featuredproducts_area_sectionbgClr2', 'featuredproducts_area', 'Section BG Color 2', '#272932');

addColorPalatOption($wp_customize, 'featuredproducts_area_leftrghtcrcl', 'featuredproducts_area', 'Left And Right Circle Color ', '#fff');

addColorPalatOption($wp_customize, 'featuredproducts_area_leftimgbrd', 'featuredproducts_area', 'Left Image Border Color ', '#f8cc82');

addColorPalatOption($wp_customize, 'featuredproducts_area_subheadingClr', 'featuredproducts_area', 'Sub Heading Color', '#fff');

addColorPalatOption($wp_customize, 'featuredproducts_area_headingClr', 'featuredproducts_area', 'Heading Color', '#fff');

addColorPalatOption($wp_customize, 'featuredproducts_area_prdimgbrd', 'featuredproducts_area', 'Product Image Border Color', '#fff');

addColorPalatOption($wp_customize, 'featuredproducts_area_pagetitle', 'featuredproducts_area', 'Product Title Color', '#fff');

addColorPalatOption($wp_customize, 'featuredproducts_area_priceClr', 'featuredproducts_area', 'Product Price Color', '#fff');

lzCustomLable($wp_customize, 'Sec_circleanmtdisplay', 'featuredproducts_area' , 'Circle Animation Display Setting');

// to show & hide another button
$wp_customize->add_setting( 'circle_animation_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'circle_animation_display', array( 'label' => 'Animation Display', 'section' => 'featuredproducts_area', 'settings' => 'circle_animation_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) );

lzCustomLable($wp_customize, 'Sec_imgbrdanmtdisplay', 'featuredproducts_area' , 'Image Border Animation Display Setting');

// to show & hide another button
$wp_customize->add_setting( 'imgbrd_animation_display' , array( 'default' => true, 'transport' => 'refresh', ) ); $wp_customize->add_control( 'imgbrd_animation_display', array( 'label' => 'Animation Display', 'section' => 'featuredproducts_area', 'settings' => 'imgbrd_animation_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) );