<?php 
    $wp_customize->add_section(
        'newarrival_area',
        array(
            'title' => __( 'New Arrival Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'newarrival_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'newarrival_area_disable',
            array(
                'settings'      => 'newarrival_area_disable',
                'section'       => 'newarrival_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'newarrivalus', 'newarrival_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'newarrivalarea_padding', 'newarrival_area', 'Section Padding');

$wp_customize->add_setting(
    'newarrival_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.85em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_areaTpadding',
    array(
        'settings'      => 'newarrival_areaTpadding',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'newarrival_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_areaBpadding',
    array(
        'settings'      => 'newarrival_areaBpadding',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newarrival_heading', 'newarrival_area', 'Section Heading And Text');

$wp_customize->add_setting(
        'newarrival_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'New Arrival', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'newarrival_title',
        array(
            'settings'      => 'newarrival_title',
            'section'       => 'newarrival_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );

$wp_customize->add_setting(
        'newarrivalubtitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Find Gorgeous Dress For Any Occasion', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'newarrivalubtitle',
        array(
            'settings'      => 'newarrivalubtitle',
            'section'       => 'newarrival_area',
            'type'          => 'text',
            'label'         => __( 'Text', 'luzuk-premium' )
        )
    );

lzCustomLable($wp_customize, 'newarrival_prdctbtnsetting', 'newarrival_area', 'Product Button Text');

$wp_customize->add_setting(
        'newarrival_prdctbtntxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Rent A Dress', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'newarrival_prdctbtntxt',
        array(
            'settings'      => 'newarrival_prdctbtntxt',
            'section'       => 'newarrival_area',
            'type'          => 'text',
            'label'         => __( 'Button Text', 'luzuk-premium' )
        )
    );

//lzCustomLable($wp_customize, 'feasecbtn', 'newarrival_area' , 'Section Color');
lzCustomLable($wp_customize, 'newarrivalarea_clr', 'newarrival_area', 'Section Color Setting');

addColorPalatOption($wp_customize, 'newarrival_area_headingClr', 'newarrival_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'newarrival_area_headingbrdClr', 'newarrival_area', 'Heading Border Color', '#6EA2DE');

addColorPalatOption($wp_customize, 'newarrival_area_txtClr', 'newarrival_area', 'Text Color', '#000');

addColorPalatOption($wp_customize, 'newarrival_btntextclr', 'newarrival_area', 'Button Text And Icon Color', '#fff');

addColorPalatOption($wp_customize, 'newarrival_btntexthvclr', 'newarrival_area', 'Button Text And Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'newarrival_btnbgclr', 'newarrival_area', 'Button BG Color', '#F69404');

addColorPalatOption($wp_customize, 'newarrival_btnbghvclr', 'newarrival_area', 'Button BG Hover Color', '#272932');

addColorPalatOption($wp_customize, 'newarrival_area_pagetitle', 'newarrival_area', 'Product Title Color', '#000');

addColorPalatOption($wp_customize, 'newarrival_area_priceClr', 'newarrival_area', 'Product Price Color', '#000');

addColorPalatOption($wp_customize, 'newarrival_sldrarrowclr', 'newarrival_area', 'Slider Arrow Color', '#272932');

addColorPalatOption($wp_customize, 'newarrival_sldrarrowhvclr', 'newarrival_area', 'Slider Arrow Hover Color', '#F69404');

addColorPalatOption($wp_customize, 'newarrival_sldrarrowbgclr', 'newarrival_area', 'Slider Arrow Hover BG Color', '#272932');

lzCustomLable($wp_customize, 'newarrbtn', 'newarrival_area' , 'Section Button');

$wp_customize->add_setting(
    'newarrbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'View More' )
    )
);
$wp_customize->add_control(
    'newarrbtntxt',
    array(
        'settings'      => 'newarrbtntxt',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('newarrbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('newarrbtnlink',
    array(
        'settings'      => 'newarrbtnlink',
        'section'       => 'newarrival_area',
        'type'          => 'url',
        'label'         => __( 'Add Button Link', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newarrival_btntxtclr', 'newarrival_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'newarrival_btntxthvclr', 'newarrival_area', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'newarrival_btntxtbgclr', 'newarrival_area', 'Button BG Color', '#F69404');

addColorPalatOption($wp_customize, 'newarrival_btntxtbghvclr', 'newarrival_area', 'Button BG Hover Color', '#272932');