<?php 
    $wp_customize->add_section(
        'popular_area',
        array(
            'title' => __( 'Popular Products Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'popular_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'popular_area_disable',
            array(
                'settings'      => 'popular_area_disable',
                'section'       => 'popular_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'popularus', 'popular_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'populararea_padding', 'popular_area', 'Section Padding');

$wp_customize->add_setting(
    'popular_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'popular_areaTpadding',
    array(
        'settings'      => 'popular_areaTpadding',
        'section'       => 'popular_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'popular_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'popular_areaBpadding',
    array(
        'settings'      => 'popular_areaBpadding',
        'section'       => 'popular_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'popular_heading', 'popular_area', 'Section Heading And Text');

$wp_customize->add_setting(
        'popular_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'OUR POPULAR CLOTH', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'popular_title',
        array(
            'settings'      => 'popular_title',
            'section'       => 'popular_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );

$wp_customize->add_setting(
        'popularubtitle',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Find Gorgeous Dress For Any Occasion', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'popularubtitle',
        array(
            'settings'      => 'popularubtitle',
            'section'       => 'popular_area',
            'type'          => 'text',
            'label'         => __( 'Text', 'luzuk-premium' )
        )
    );

lzCustomLable($wp_customize, 'popular_prdctbtnsetting', 'popular_area', 'Product Button Text');

$wp_customize->add_setting(
        'popular_prdctbtntxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Rent A Dress', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'popular_prdctbtntxt',
        array(
            'settings'      => 'popular_prdctbtntxt',
            'section'       => 'popular_area',
            'type'          => 'text',
            'label'         => __( 'Button Text', 'luzuk-premium' )
        )
    );

lzCustomLable($wp_customize, 'populararea_clr', 'popular_area', 'Section Color Setting');

addColorPalatOption($wp_customize, 'popular_area_headingClr', 'popular_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'popular_area_headingbrdClr', 'popular_area', 'Heading Border Color', '#6EA2DE');

addColorPalatOption($wp_customize, 'popular_area_txtClr', 'popular_area', 'Text Color', '#000');

addColorPalatOption($wp_customize, 'popular_btntextclr', 'popular_area', 'Button Text And Icon Color', '#fff');

addColorPalatOption($wp_customize, 'popular_btntexthvclr', 'popular_area', 'Button Text And Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'popular_btnbgclr', 'popular_area', 'Button BG Color', '#F69404');

addColorPalatOption($wp_customize, 'popular_btnbghvclr', 'popular_area', 'Button BG Hover Color', '#272932');

addColorPalatOption($wp_customize, 'popular_area_pagetitle', 'popular_area', 'Product Title Color', '#000');

addColorPalatOption($wp_customize, 'popular_area_priceClr', 'popular_area', 'Product Price Color', '#000');

addColorPalatOption($wp_customize, 'popular_sldrarrowclr', 'popular_area', 'Slider Arrow Color', '#272932');

addColorPalatOption($wp_customize, 'popular_sldrarrowhvclr', 'popular_area', 'Slider Arrow Hover Color', '#F69404');

addColorPalatOption($wp_customize, 'popular_sldrarrowbgclr', 'popular_area', 'Slider Arrow Hover BG Color', '#272932');