<?php 
$wp_customize->add_section('pricing_area',array('title' => __( 'Pricing Section', 'luzuk' ),'panel' => 'luzuk_premium_home_panel'));
$wp_customize->add_setting('pricing_area_disable',array('sanitize_callback' => 'luzuk_sanitize_text',));
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'pricing_area_disable',
        array(
            'settings' => 'pricing_area_disable',
            'section' => 'pricing_area',
            'label' => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array('on' => __( 'Yes', 'luzuk' ), 'off' => __( 'No', 'luzuk' )),
        )
    )
); 

backgroundManager($wp_customize, 'pricingsec', 'pricing_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'pricing_areapadding', 'pricing_area', 'Section Padding');

$wp_customize->add_setting(
    'pricing_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3.5em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'pricing_areaTpadding',
    array(
        'settings'      => 'pricing_areaTpadding',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'pricing_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'pricing_areaBpadding',
    array(
        'settings'      => 'pricing_areaBpadding',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk' )
    )
);

lzCustomLable($wp_customize, 'pricing_areaheading', 'pricing_area', 'Section Heading');

$wp_customize->add_setting('pricing_page_maintitle',array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'SUBSCRIPTION PLANS', 'luzuk' )));
$wp_customize->add_control(
    'pricing_page_maintitle',
    array(
        'settings'      => 'pricing_page_maintitle',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk' )
    )
);

$wp_customize->add_setting('pricing_headingtext',array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'Choose Your WayTo Rent a Dress', 'luzuk' )));
$wp_customize->add_control(
    'pricing_headingtext',
    array(
        'settings'      => 'pricing_headingtext',
        'section'       => 'pricing_area',
        'type'          => 'text',
        'label'         => __( 'Heading Text', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'pricingarea_sectitle_color', 'pricing_area', 'Heading Color ', '#000');

addColorPalatOption($wp_customize, 'pricingarea_sectitlebrd_color', 'pricing_area', 'Heading Border Color ', '#6EA2DE');

addColorPalatOption($wp_customize, 'pricingarea_sectitletxt_color', 'pricing_area', 'Heading Text Color ', '#000');

$wp_customize->add_setting('pricing_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'pricing_npp_heading',
        array(
            'settings'      => 'pricing_npp_heading',
            'section'       => 'pricing_area',
            'label'         => __( 'Pricing Plan To Show', 'luzuk' ),
        )
    )
);    

$wp_customize->add_setting('pricing_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'pricing_npp_count',
    array(
        'settings'      => 'pricing_npp_count',
        'section'       => 'pricing_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Plan To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9)
    )
);

for($i=1;$i<=8;$i++){
    $wp_customize->add_setting('pricing_plan_heading_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'pricing_plan_heading_'.$i,
            array(
                'settings' => 'pricing_plan_heading_'.$i,
                'section' => 'pricing_area',
                'label' => __( 'Pricing Plan '.$i, 'luzuk' ),
            )
        )
    ); 

$wp_customize->add_setting('pricing_plan_price_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( '$30', 'luzuk' )));
$wp_customize->add_control(
    'pricing_plan_price_'.$i,
    array(
        'settings' => 'pricing_plan_price_'.$i,
        'section' => 'pricing_area',
        'type' => 'text',
        'label' => __( 'Plan Price', 'luzuk' )
    )
);

$wp_customize->add_setting('pricing_plan_month_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'rental', 'luzuk' )));
$wp_customize->add_control(
    'pricing_plan_month_'.$i,
    array(
        'settings' => 'pricing_plan_month_'.$i,
        'section' => 'pricing_area',
        'type' => 'text',
        'label' => __( 'Pricing Text ', 'luzuk' )
    )
);

$wp_customize->add_setting('pricing_plan_name_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( 'Unlimited', 'luzuk' )));

$wp_customize->add_control(
    'pricing_plan_name_'.$i,
    array(
        'settings' => 'pricing_plan_name_'.$i,
        'section' => 'pricing_area',
        'type' => 'text',
        'label' => __( 'Plan Name', 'luzuk' )
    )
);

$wp_customize->add_setting('pricing_plan_content_'.$i,array('sanitize_callback' => 'luzuk_sanitize_text','default' => __( '<li>Free backup size </li>
            <li>Free returns</li>
            <li>Free dry cleaning</li>
            <li>Free shipping & insurance</li>', 'luzuk' )));
$wp_customize->add_control(
    'pricing_plan_content_'.$i,
    array(
        'settings' => 'pricing_plan_content_'.$i,
        'section' => 'pricing_area',
        'type' => 'textarea',
        'label' => __( 'Pricing Plan Content', 'luzuk' )
    )
);

    /*code for button text*/
$wp_customize->add_setting(
    'pricing_page_button_title_'.$i,
    array(
        'sanitize_callback'=>'luzuk_sanitize_text',
        'default'=> __('Learn More', 'luzuk')
    )
);
$wp_customize->add_control(
    'pricing_page_button_title_'.$i,
    array(
        'settings' =>'pricing_page_button_title_'.$i,
        'section' => 'pricing_area',
        'type'=> 'text',
        'label'=> __('Button Text', 'luzuk')
    )
);

lzAddElement($wp_customize, 'pricing_plan_url_'.$i, 'pricing_area', $type = 'text', $label="Button Link ", $callback ='esc_url', $default='#');

    }

lzCustomLable($wp_customize, 'pricing_areacolor', 'pricing_area', 'Section Color');

addColorPalatOption($wp_customize, 'pricingarea_PlanbxbgClr', 'pricing_area', 'Plan Box BG Color ', '#E0E2E5');

addColorPalatOption($wp_customize, 'pricingarea_Planprice_color', 'pricing_area', 'Plan Price Color ', '#fff');

addColorPalatOption($wp_customize, 'pricingarea_Planprice_bgcolor', 'pricing_area', 'Plan Price BG Color ', '#272932');

addColorPalatOption($wp_customize, 'pricingarea_Planpricecrcl_color', 'pricing_area', 'Plan Price Circle Color ', '#000');

addColorPalatOption($wp_customize, 'pricingarea_PlanNameColor', 'pricing_area', 'Plan Name Color ', '#272932');

addColorPalatOption($wp_customize, 'price_ContentliicnClr', 'pricing_area', 'Plan Content List Icon Color', '#272932');

addColorPalatOption($wp_customize, 'pricing_PlanConiClr', 'pricing_area', 'Plan Content List Color ', '#404040');

addColorPalatOption($wp_customize, 'pricing_ButtontextClr', 'pricing_area', 'Plan Button Text Color ', '#272932');


lzCustomLable($wp_customize, 'pricing_area2ndclr', 'pricing_area', 'Section 2nd Plan & Hover Color');

addColorPalatOption($wp_customize, 'pricingarea_2ndPlanbxbgClr', 'pricing_area', 'Plan Box BG Color ', '#272932');

addColorPalatOption($wp_customize, 'pricingarea_2ndPlanprice_color', 'pricing_area', 'Plan Price Color ', '#fff');

addColorPalatOption($wp_customize, 'pricingarea_2ndPlanprice_bgcolor', 'pricing_area', 'Plan Price BG Color ', '#F69404');

addColorPalatOption($wp_customize, 'pricingarea_2ndPlanNameColor', 'pricing_area', 'Plan Name Color ', '#fff');

addColorPalatOption($wp_customize, 'price_2ndContentliicnClr', 'pricing_area', 'Plan Content List Icon Color', '#fff');

addColorPalatOption($wp_customize, 'pricing_2ndPlanConiClr', 'pricing_area', 'Plan Content List Color ', '#fff');

addColorPalatOption($wp_customize, 'pricing_2ndButtontextClr', 'pricing_area', 'Plan Button Text Color ', '#fff');