<?php  
$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title And Description On Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 580X560', 'Luzuk' ),
		)
	)
);

backgroundManager($wp_customize, 'sliderbg', 'slider_section', $color='#F69404', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_descntbxsetting', 'slider_section', 'Discount Box Setting');

$wp_customize->add_setting(
    'slider_dicntrate',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '60%', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_dicntrate',
    array(
        'settings'      => 'slider_dicntrate',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Discount Rate', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'slider_dicnttitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'OFF', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_dicnttitle',
    array(
        'settings'      => 'slider_dicnttitle',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Discount Title', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'slider_dicnttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem ipsum. Lorem ipsum. Lorem ipsum. Lorem ipsum.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_dicnttext',
    array(
        'settings'      => 'slider_dicnttext',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Discount Text', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Section Color');

addColorPalatOption($wp_customize, 'slider_titleColor', 'slider_section', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_subtitleColor', 'slider_section', 'Sub Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_textclr', 'slider_section', 'Text Color', '#292827');

addColorPalatOption($wp_customize, 'slider_ButtontextColor', 'slider_section', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_ButtontexthoverColor', 'slider_section', 'Button Text Hover Color', '#272932');

addColorPalatOption($wp_customize, 'slider_dscntrateColor', 'slider_section', 'Discount Rate And Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_dscntshdwColor', 'slider_section', 'Discount Rate And Title Shadow Color', '#6EA2DE');

addColorPalatOption($wp_customize, 'slider_dscntbxbgColor', 'slider_section', 'Discount Box BG Color', '#272932');

addColorPalatOption($wp_customize, 'slider_dscnttxtColor', 'slider_section', 'Discount Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_curvebgColor', 'slider_section', 'Left Curve BG Color', '#272932');

addColorPalatOption($wp_customize, 'slider_curvebrdColor', 'slider_section', 'Left Curve Border Color', '#707070');

lzCustomLable($wp_customize, 'luzuk_sliderbutnclrs', 'slider_section', 'Slider Arrow Button Color');

addColorPalatOption($wp_customize, 'sli_arrwbtnclr', 'slider_section', 'Slider Dot Color', '#fff');
