<?php
/**
 * Createing an Our Pets pannel for customizer
 */

// START ABOUT SECTION 
$wp_customize->add_section(
    'specialoffer_section',
    array(
        'title' => __( 'Special Offer Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
    // ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'specialoffer_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'specialoffer_section_disable',
        array(
            'settings'      => 'specialoffer_section_disable',
            'section'       => 'specialoffer_section',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'specialoffer', 'specialoffer_section', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'luzuk_specialoffersectionpadding', 'specialoffer_section', 'Section Padding');

$wp_customize->add_setting(
    'sec_specialofferTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.2em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'sec_specialofferTpadding',
    array(
        'settings'      => 'sec_specialofferTpadding',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'sec_specialofferBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1.5em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'sec_specialofferBpadding',
    array(
        'settings'      => 'sec_specialofferBpadding',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk' ) 
    )
);

lzCustomLable($wp_customize, 'specialofferbox1', 'specialoffer_section', 'Special Offer Box 1');

lzCustomLable($wp_customize, 'specialofferbox1_img', 'specialoffer_section' , 'Select Image');

$wp_customize->add_setting(
    'spbanner_image1',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'spbanner_image1',
        array(
            'section' => 'specialoffer_section',
            'settings' => 'spbanner_image1',
            'description' => __('Recommended Image Size: 650X383px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'spoffersubtitle1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'BE UNIQUE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spoffersubtitle1',
    array(
        'settings'      => 'spoffersubtitle1',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'spoffertitle1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Party Cloth', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spoffertitle1',
    array(
        'settings'      => 'spoffertitle1',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'spofferbtntxt1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Shop Now', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spofferbtntxt1',
    array(
        'settings'      => 'spofferbtntxt1',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('spofferbtntxtlink1',   
    array('default'=> 'add link here', 
    'sanitize_callback' => 'esc_url_raw')
);
$wp_customize->add_control('spofferbtntxtlink1',
    array(
        'settings'      => 'spofferbtntxtlink1',
        'section'       => 'specialoffer_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Link', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'specialofferbox2', 'specialoffer_section', 'Special Offer Box 2');

lzCustomLable($wp_customize, 'specialofferbox2_img', 'specialoffer_section' , 'Select Image');

$wp_customize->add_setting(
    'spbanner_image2',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'spbanner_image2',
        array(
            'section' => 'specialoffer_section',
            'settings' => 'spbanner_image2',
            'description' => __('Recommended Image Size: 650X357px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'spoffersubtitle2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'BE UNIQUE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spoffersubtitle2',
    array(
        'settings'      => 'spoffersubtitle2',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'spoffertitle2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Dress Yourself', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spoffertitle2',
    array(
        'settings'      => 'spoffertitle2',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'spofferbtntxt2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Shop Now', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spofferbtntxt2',
    array(
        'settings'      => 'spofferbtntxt2',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('spofferbtntxtlink2',   
    array('default'=> 'add link here', 
    'sanitize_callback' => 'esc_url_raw')
);
$wp_customize->add_control('spofferbtntxtlink2',
    array(
        'settings'      => 'spofferbtntxtlink2',
        'section'       => 'specialoffer_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Link', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'specialofferbox3', 'specialoffer_section', 'Special Offer Box 3');

lzCustomLable($wp_customize, 'specialofferbox3_img', 'specialoffer_section' , 'Select Image');

$wp_customize->add_setting(
    'spbanner_image3',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'spbanner_image3',
        array(
            'section' => 'specialoffer_section',
            'settings' => 'spbanner_image3',
            'description' => __('Recommended Image Size: 650X755px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'spoffersubtitle3',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'BE UNIQUE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spoffersubtitle3',
    array(
        'settings'      => 'spoffersubtitle3',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Sub Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'spoffertitle3',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Wedding Dress', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spoffertitle3',
    array(
        'settings'      => 'spoffertitle3',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'spoffer3txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spoffer3txt',
    array(
        'settings'      => 'spoffer3txt',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'spofferbtntxt3',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Shop Now', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'spofferbtntxt3',
    array(
        'settings'      => 'spofferbtntxt3',
        'section'       => 'specialoffer_section',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('spofferbtntxtlink3',   
    array('default'=> 'add link here', 
    'sanitize_callback' => 'esc_url_raw')
);
$wp_customize->add_control('spofferbtntxtlink3',
    array(
        'settings'      => 'spofferbtntxtlink3',
        'section'       => 'specialoffer_section',
        'type'          => 'url',
        'label'         => __( 'Add Button Link', 'luzuk-premium' )
    )
);
  
lzCustomLable($wp_customize, 'specialoffercolor', 'specialoffer_section', 'Special Offer Color Settings');

addColorPalatOption($wp_customize, 'membe_pagebgovlyClr', 'specialoffer_section', 'Image Overlay Color ', '#272932');

addColorPalatOption($wp_customize, 'membe_pagesubttl', 'specialoffer_section', 'Sub Heading Color ', '#fff');

addColorPalatOption($wp_customize, 'membe_pagettl', 'specialoffer_section', 'Heading Color ', '#fff');

addColorPalatOption($wp_customize, 'membe_btntxtclr', 'specialoffer_section', 'Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'membe_btntxthvclr', 'specialoffer_section', 'Button Text Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'membe_btnbgclr', 'specialoffer_section', 'Button BG Color ', '#F69404');

addColorPalatOption($wp_customize, 'membe_btnbghvclr', 'specialoffer_section', 'Button BG Hover Color ', '#272932');

addColorPalatOption($wp_customize, 'membe_3rdbxtxtclr', 'specialoffer_section', '3rd Box Text Color ', '#fff');