<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonial Section', 'luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk Premium' ),
                'off' => __( 'No', 'luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#fff;', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_testsectionpadding', 'testimonials_area', 'Section Padding ');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk Premium' )
    )
);

 lzCustomLable($wp_customize, 'sec_testimonialhead', 'testimonials_area', 'Section Heading ');

$wp_customize->add_setting(
    'testi_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'CUSTOMER REVIEWS', 'luzuk' )
    )
);
$wp_customize->add_control(
    'testi_maintitle',
    array(
        'settings'      => 'testi_maintitle',
        'section'       => 'testimonials_area', 
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk' )
    )
);

$wp_customize->add_setting(
    'testi_headingtext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'What Our Clients are Saying', 'luzuk' )
    )
);
$wp_customize->add_control(
    'testi_headingtext',
    array(
        'settings'      => 'testi_headingtext',
        'section'       => 'testimonials_area', 
        'type'          => 'text',
        'label'         => __( 'Text', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'luzuk_testi_heading', 'testimonials_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_testi_headingbrd', 'testimonials_area', 'Heading Border Color', '#6EA2DE');

addColorPalatOption($wp_customize, 'luzuk_testi_headingtxt', 'testimonials_area', 'Heading Text Color', '#000');

$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 10; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client Testimonial', 'luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}


lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Section Color Settings');

addColorPalatOption($wp_customize, 'luzuk_testimonials_bxbgclr', 'testimonials_area', 'Section Box BG Color', '#F5F5F5');

addColorPalatOption($wp_customize, 'luzuk_testimonials_quoteicncolor', 'testimonials_area', 'Quote Icon Color', '#999999');

addColorPalatOption($wp_customize, 'luzuk_testimonialscontent_textcolor', 'testimonials_area', 'Client Text Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_testimonials_Namecolor', 'testimonials_area', 'Client Name Color', '#000');

addColorPalatOption($wp_customize, 'luzuk_testimonials_deginclr', 'testimonials_area', 'Client Designation Color', '#979797');

addColorPalatOption($wp_customize, 'luzuk_testimonialssldrarrow_color', 'testimonials_area', 'Slider Arrow Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_testimonialssldrarrowhv_color', 'testimonials_area', 'Slider Arrow Hover Color', '#272932');

addColorPalatOption($wp_customize, 'luzuk_testimonialssldrarrowbg_color', 'testimonials_area', 'Slider Arrow BG Color', '#272932');

addColorPalatOption($wp_customize, 'luzuk_testimonialssldrarrowbghv_color', 'testimonials_area', 'Slider Arrow BG Hover Color', '#F69404');