<?php 
    $wp_customize->add_section(
        'topcategories_area',
        array(
            'title' => __( 'Category Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'topcategories_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'topcategories_area_disable',
            array(
                'settings'      => 'topcategories_area_disable',
                'section'       => 'topcategories_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'topcategories', 'topcategories_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'topcatarea_padding', 'topcategories_area', 'Section Padding');

$wp_customize->add_setting(
    'topcategories_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.9em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'topcategories_areaTpadding',
    array(
        'settings'      => 'topcategories_areaTpadding',
        'section'       => 'topcategories_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'topcategories_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'topcategories_areaBpadding',
    array(
        'settings'      => 'topcategories_areaBpadding',
        'section'       => 'topcategories_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'topcatarea_heading', 'topcategories_area', 'Section Heading');

$wp_customize->add_setting(
        'topcategories_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'OUR COLLECTION', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'topcategories_title',
        array(
            'settings'      => 'topcategories_title',
            'section'       => 'topcategories_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );

$wp_customize->add_setting(
        'topcategories_text',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Find Gorgeous Dress For Any Occasion', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'topcategories_text',
        array(
            'settings'      => 'topcategories_text',
            'section'       => 'topcategories_area',
            'type'          => 'text',
            'label'         => __( 'Text', 'luzuk-premium' )
        )
    );

lzCustomLable($wp_customize, 'allcategoriess_SelCategory', 'topcategories_area', ' Choose Category');
// Category Head
    $wp_customize->add_setting(
        'category_head',
        array(
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'luzuk_sanitize_text',
            'priority'  => 1,
        )
    );

    $wp_customize->add_control(
    'category_head',
        array(
            'type' => 'hidden',
            'label' => __('Category','luzuk'),
            'description'   => esc_html__( 'Select The Product Category That Will Show This Section.', 'luzuk' ),
            'section' => 'topcategories_area',
        )
    );


//features PAGES  
for( $i = 1; $i <= 12; $i++ ){
    

// category 1
    $wp_customize->add_setting( 'category'.$i, array(
        'default'           => 0,
        'sanitize_callback' => 'wp_kses_post',
    ) );

    $wp_customize->add_control( new My_Dropdown_Category_Control( $wp_customize, 'category'.$i, array(
        'section'       => 'topcategories_area',
        'label'         => esc_html__( 'Category '.$i, 'luzuk' ),
    ) ) );

}

lzCustomLable($wp_customize, 'topcatarea_clr', 'topcategories_area', 'Category Color Setting');

addColorPalatOption($wp_customize, 'topcategories_headclr', 'topcategories_area', 'Heading Color', '#000');

addColorPalatOption($wp_customize, 'topcategories_headbrdclr', 'topcategories_area', 'Heading Border Color', '#6EA2DE');

addColorPalatOption($wp_customize, 'topcategories_txtclr', 'topcategories_area', 'Text Color', '#000');

addColorPalatOption($wp_customize, 'topcategories_imgovlyclr', 'topcategories_area', 'Image Overlay Color', '#000');

addColorPalatOption($wp_customize, 'topcategories_cattitle', 'topcategories_area', 'Category Title Color', '#fff');

addColorPalatOption($wp_customize, 'topcategories_sliderarrwclr', 'topcategories_area', 'Slider Arrow Color', '#fff');

addColorPalatOption($wp_customize, 'topcategories_sliderarrwhvclr', 'topcategories_area', 'Slider Arrow Hover Color', '#000');

addColorPalatOption($wp_customize, 'topcategories_sliderarrwbgclr', 'topcategories_area', 'Slider Arrow BG Color', '#000');

addColorPalatOption($wp_customize, 'topcategories_sliderarrwbghvclr', 'topcategories_area', 'Slider Arrow BG Hover Color', '#F69404');