jQuery(document).ready(function($) {
    $('.change-rental-days').on('click', function() {
        var button = $(this);
        var oldValue = button.siblings('.rental-days-input').val();
        var newVal = 1;
        
        if (button.data('operation') === 'plus') {
            newVal = parseInt(oldValue) + 1;
        } else if (button.data('operation') === 'minus' && oldValue > 1) {
            newVal = parseInt(oldValue) - 1;
        }
        
        button.siblings('.rental-days-input').val(newVal);

        // Trigger cart update
        $(document.body).trigger('update_cart');
    });

    // Example of update_cart event handling
    $(document.body).on('update_cart', function() {
        // AJAX call to update the cart goes here
        // For demonstration, this simply reloads the page
        location.reload();
    });
});
