<?php 
/**
 *
 * @package Slider Premium
 */
?>
<?php $showContent = get_theme_mod('slider_section_show_content', 'on'); ?>
<div id="slider" class="slider_section">
    <div class="slider-area">
        <div  class="owl-carousel">
            <?php
            $args = array( 'post_type' => 'slider', 'orderby'   => 'id', 'order' => 'DESC',);
            if(!empty($pageId)){
                $args['page_id'] = absint($pageId);

            }
            $text = '';
            $query = new WP_Query($args);
            if($query->have_posts()){
                while($query->have_posts()) : $query->the_post(); 
                

                if( get_theme_mod('slider_areaOpacity',true) ) {
                    $slider_areaOpacity = 'opacity:'.esc_attr(get_theme_mod('slider_areaOpacity')).';';
                }
                if( get_theme_mod('slider_Tfontsize',true) ) {
                    $slider_Tfontsize = 'font-size:'.esc_attr(get_theme_mod('slider_Tfontsize')).';';
                }

                $pageLink = '';
                $slider_btn_link = get_post_meta($post->ID,'slider_btn_link',false);
                $sliderBtnTxt = get_post_meta($post->ID,'sliderBtnTxt',false);
                if(!empty($slider_btn_link) && is_array($slider_btn_link)){
                    $pageLink = esc_url(get_permalink($slider_btn_link[0]));
                }
                if(!empty($sliderBtnTxt) && is_array($sliderBtnTxt)){
                    $pageLinkTxt = $sliderBtnTxt[0];
                }else{
                    $pageLinkTxt = 'Start Free Trial';
                }

                $sliderchangedate = get_post_meta($post->ID, 'sliderchangedate', false);
                $sliderdatetext = !empty($sliderchangedate[0]) ? $sliderchangedate[0] : '';

                $sliderdicntrate = get_theme_mod('slider_dicntrate', '60%');
                $sliderdicnttitle = get_theme_mod('slider_dicnttitle', 'OFF');
                $sliderdicnttext = get_theme_mod('slider_dicnttext', 'Lorem ipsum. Lorem ipsum. Lorem ipsum. Lorem ipsum.');

                ?>
            <div class="item">
                <div class="row">
                    <div class="col-xl-7 col-lg-5 col-md-6 col-sm-5">
                        <?php
                            if($showContent == 'on'){
                            ?>
                            <div class="slider_content animated " >
                                <div class="title animated "><?php echo (get_the_title()); ?> </div>
                                <div class="sub-title animated "><?php echo $sliderdatetext; ?></div>
                                <div class="text animated "><?php echo (get_the_content()); ?></div>
                                <?php 
                                if(!empty($pageLink)){ ?>
                                    <div class="slide-btna">
                                        <div class="btn5 btn1">  
                                            <a href="<?php echo $pageLink; ?>"> 
                                                <span> <?php echo($pageLinkTxt); ?> </span>
                                            </a>
                                        </div>
                                    </div>
                                <?php }?>
                            </div>
                        <?php }?>
                    </div>
                    <div class="col-xl-5 col-lg-7 col-md-6 col-sm-7">
                        <div class="slider-imgarea">
                            <div class="sliderimg">
                                <?php 
                                    if(has_post_thumbnail()){
                                        $total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(),'full');  
                                        echo '<img class="slide-mainimg" alt="'. esc_html(get_the_title()) .'" src="'.esc_url($total_slider_image[0]).'">';
                                }?>
                            </div>
                            <?php 
                                if($sliderdicntrate){
                             ?>
                                <div class="slider-dscbx">
                                    <svg viewBox="0 0 200 200" width="223" height="223"> 
                                        <path id="textPath" d="M 85,0 A 85,85 0 0 1 -85,0 A 85,85 0 0 1 85,0" transform="translate(100,100)" fill="none" stroke-width="0"></path>
                                        <g font-size="13.1px">
                                          <text text-anchor="start">
                                            <textPath class="slider-dscsvgtxt" xlink:href="#textPath" startOffset="0%">
                                                <?php echo $sliderdicnttext; ?></textPath>
                                          </text>
                                        </g>
                                    </svg>
                                    <div class="slider-dscprice">
                                        <?php echo $sliderdicntrate; ?><br>
                                        <span><?php echo $sliderdicnttitle; ?></span>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
                    <?php
                endwhile;
            }else{ 
            for($i=0;$i<3;$i++){?>
            <div class="item">
                <div class="row">
                    <div class="col-xl-7 col-lg-5 col-md-6 col-sm-5">
                        <?php if($showContent == 'on'){?>
                            <div class="slider_content animated " >
                                <div class="title animated ">Sale</div>
                                <div class="sub-title animated ">Your Closet, One Rental at a Time</div>
                                <div class="text animated ">There are many variations of passages of Lorem Ipsum available, but the even slightly believable.</div>
                                <div class="slide-btna ">
                                    <div class="btn5 btn1">
                                        <a href="#">
                                            <span><?php _e( 'Shop Now!', 'luzuk-premium' ); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php }?>
                    </div>
                    <div class="col-xl-5 col-lg-7 col-md-6 col-sm-7">
                        <div class="slider-imgarea">
                            <div class="sliderimg ">
                                <?php echo '<img class="slide-mainimg " alt="Slider" src="'. esc_html(get_template_directory_uri()) .'/images/slider1.jpg">';?>
                            </div>
                            <div class="slider-dscbx">
                                <svg viewBox="0 0 200 200" width="223" height="223"> 
                                    <path id="textPath" d="M 85,0 A 85,85 0 0 1 -85,0 A 85,85 0 0 1 85,0" transform="translate(100,100)" fill="none" stroke-width="0"></path>
                                    <g font-size="13.1px">
                                      <text text-anchor="start">
                                        <textPath class="slider-dscsvgtxt" xlink:href="#textPath" startOffset="0%">Lorem ipsum. Lorem ipsum. Lorem ipsum. Lorem ipsum.</textPath>
                                      </text>
                                    </g>
                                </svg>
                                <div class="slider-dscprice">
                                    60%<br>
                                    <span>OFF</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php }
        }?>
        </div>
    </div>
    <div class="slider-wave1">
        <svg width="690.169" height="217.159" viewBox="0 0 690.169 217.159">
          <defs>
            <filter id="Path_3" x="0" y="0" width="690.169" height="217.159" filterUnits="userSpaceOnUse">
              <feOffset dy="1" input="SourceAlpha"/>
              <feGaussianBlur stdDeviation="2.5" result="blur"/>
              <feFlood flood-opacity="0.149"/>
              <feComposite operator="in" in2="blur"/>
              <feComposite in="SourceGraphic"/>
            </filter>
          </defs>
          <g id="line" transform="translate(7.5 -229.038)">
            <g transform="matrix(1, 0, 0, 1, -7.5, 229.04)" filter="url(#Path_3)">
              <path id="Path_3-2" data-name="Path 3" d="M0,316.007s47.214,50.954,130.89,37.4,60.522-79.01,147.929-74.584,62.446-69.307,166.207-50.7c48.145,8.635,71.38,9.783,90.733,7.41,8.2-1.145,48.393-6.61,80.19-25.955,33.8-20.562,59.22-55.555,59.22-55.555L.148,153.538Z" transform="translate(7.5 -147.04)" fill="#272932"/>
            </g>
            <path id="Path_4" data-name="Path 4" d="M-3.5-9.412S42.012,54.571,99.5,45.7,151.552,4.783,210.965-14.53s60.875-4.585,101.653-19.386,39.223-34.223,77.732-45.429S481.9-66.413,547.18-74.854c30.486-3.942,57.056-17.11,76.87-30.127,22.289-14.643,29.27-28.646,29.27-28.646" transform="translate(3.5 369.5)" fill="none" stroke="#707070" stroke-width="1" stroke-dasharray="7"/>
            <path id="Path_6" data-name="Path 6" d="M-18.636-16.858S35.1,42.722,92.589,33.852s40.165-32.6,99.578-51.917,51.735-.851,101.28-16.171S337.5-67.287,376-78.492,481.9-66.413,547.18-74.854,638.673-122.9,638.673-122.9" transform="translate(18.5 358.5)" fill="none" stroke="#707070" stroke-width="1" opacity="0.3"/>
            <path id="Path_7" data-name="Path 7" d="M-18.364-48.055S42.012,3.183,99.5-3.119s52.052-29.07,111.465-42.791,60.875-3.257,101.653-13.772S351.841-84,390.35-91.956s91.549,9.187,156.83,3.191S638.673-122.9,638.673-122.9" transform="translate(18.5 358.5)" fill="none" stroke="#707070" stroke-width="1" opacity="0.3"/>
            <path id="Path_8" data-name="Path 8" d="M.47-75.182s42.786,25.5,101.956,21.836S156-70.226,217.151-78.193s62.656-1.891,104.627-8,40.37-14.118,80.006-18.741S496.012-99.6,563.2-103.078s94.17-19.82,94.17-19.82" transform="translate(-0.199 358.5)" fill="none" stroke="#707070" stroke-width="1" opacity="0.3"/>
          </g>
        </svg>
    </div>
    <div class="slider-wave2">
        <svg width="414.986" height="266.804" viewBox="0 0 414.986 266.804">
            <defs>
                <filter id="Path_9" x="0" y="0" width="414.986" height="266.804" filterUnits="userSpaceOnUse">
                      <feOffset dy="-1" input="SourceAlpha"/>
                      <feGaussianBlur stdDeviation="2.5" result="blur"/>
                      <feFlood flood-opacity="0.149"/>
                      <feComposite operator="in" in2="blur"/>
                      <feComposite in="SourceGraphic"/>
                </filter>
          </defs>
          <g transform="matrix(1, 0, 0, 1, 0, 0)" filter="url(#Path_9)">
                <path id="Path_9-2" data-name="Path 9" d="M0,614.4S22.761,689.551,77.45,723.94s95.057-1.063,141.306,28.02c43.852,27.575,29.634,59.189,63.382,80.41,35.227,22.151,117.281,33.193,117.281,33.193H0Z" transform="translate(8 -605.76)" fill="#272932" stroke="#707070" stroke-width="1"/>
          </g>
        </svg>
    </div>
    <!-- </div> -->
<div class="clearfix"></div>
</div>
<script>
        // $(document).ready(function() {
        //   $('#slider .owl-carousel').owlCarousel({
        //     refreshClass: 'owl-refresh',
        //     autoplayTimeout:7000,
        //     loop: true,
        //     margin: 0,
        //     autoHeight: true,
        //     autoWidth: false,
        //     autoplay: true,
        //     responsiveClass: true,
        //     responsive: {
        //       0: {
        //         items: 1,
        //         nav: true,
        //       },
        //       600: {
        //         items:1,
        //         nav: true,
        //       },
        //       1000: {
        //         items:1,
        //         nav: true,
        //         loop: true,
        //       }
        //     }
        //   })
        // })
    document.addEventListener("DOMContentLoaded", function() {
    // Select the element with ID 'slider' and add a class to it
    var slider = document.getElementById('slider');
    slider.classList.add('js-slider-initialized');
});

    (function($){
    'use strict';
    $(document).ready(function(){
        $('#slider .owl-carousel').owlCarousel({
            items: 1,
            loop: true,
            nav: true,
      autoplay: true,
      lazyLoad:true,
        });
    });
})(jQuery);
    </script>