<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package luzuk Premium
 */

get_header(); ?>

<main id="innerpage-box">
	<?php
        // width 
        $c_width = get_theme_mod('innpg_c_width', 'container');

        if ($c_width === 'container') {
            $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
            
    ?>
	<div class="<?php echo esc_attr($c_width); ?>">
        <div class="inner_contentbox">
			<span class="error-404"><?php esc_html_e( '404', 'total' ); ?></span>
	        <div class="clearfix"></div>
	        <!-- <div class="errorbx">
	        	<form method="get" id="searchform" class="search-form" action="<?php echo esc_url( home_url() ); ?>" _lpchecked="1">
					<fieldset>
						<input type="text" name="s" id="s" value="<?php _e('Search this site...','luzuk Premium'); ?>" onblur="if (this.value == '') {this.value = '<?php _e('Search this site...','luzuk Premium'); ?>';}" onfocus="if (this.value == '<?php _e('Search this site...','luzuk Premium'); ?>') {this.value = '';}" >
						<input type="submit" value="<?php esc_attr_e( 'Search', 'luzuk Premium' ); ?>" />
					</fieldset>
				</form>
	        </div> -->
	    </div>
	</div>
</main><!-- #main -->
<?php get_template_part('template-parts/section','newsletter'); ?>
<?php get_footer(); ?>