<?php   
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package luzuk Premium
 */
?>
	
<footer class="footer-area" id="footer">
	<?php
        // width 
        $c_width = get_theme_mod('footer_c_width', 'container');

        if ($c_width === 'container') {
            $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
            
    ?>
	<?php
		$footercopyright = get_theme_mod('footer_area_copyrighttext', '© Copyright 2025. All Rights Reserved.');

		$twitter = get_theme_mod('fter_twitt', '//twitter.com/');
		$instagram = get_theme_mod('fter_insta', '//instagram.com/');
		$pinterest = get_theme_mod('fter_pin', '//pinterest.com/');				
		$facebook = get_theme_mod('fter_fb', '//facebook.com/');
	?>
	<?php if(is_active_sidebar('luzuk-footer1') || is_active_sidebar('luzuk-footer2') || is_active_sidebar('luzuk-footer3') || is_active_sidebar('luzuk-footer4')  ){ ?>
		<div class="<?php echo esc_attr($c_width); ?>"> 
			<div class="fbox">						
				<div class="row mr-0"> 				
					<div class="s-footer single-footer-1 ">
						<div class="single-footer " data-wow-duration="1s">	
							<?php if(is_active_sidebar('luzuk-footer1')): 
									dynamic_sidebar('luzuk-footer1');
								endif;
							?>	
						</div>
					</div> 
						
					<div class="s-footer single-footer-2">
						<div class="single-footer " data-wow-duration="1.5s" >
							<?php if(is_active_sidebar('luzuk-footer2')): 
								dynamic_sidebar('luzuk-footer2');
							endif;
							?>	
							
						</div>
					</div>
						
					<div class="s-footer single-footer-3 ">
						<div class="single-footer "  data-wow-duration="1.4s" >
							<?php if(is_active_sidebar('luzuk-footer3')): 
								dynamic_sidebar('luzuk-footer3');
							endif;
							?>	
						</div>
					</div>
					
					<div class="s-footer single-footer-4 " >
						<div class="single-footer " data-wow-duration="1.8s" >
							<?php if(is_active_sidebar('luzuk-footer4')): 
								dynamic_sidebar('luzuk-footer4');
							endif;
							?>	
						</div>
					</div> 
				</div> 
			</div>
		</div>
		<div class="ft-brd"></div>
		<div class="<?php echo esc_attr($c_width); ?>"> 
			<?php if( $footercopyright || $facebook || $instagram || $pinterest || $twitter ){ ?>
			<div class="bottom-area " >
				<div class="row mr-0">
					<?php if( $footercopyright  ){ ?>
					<div class="footer-text">
						<?php echo $footercopyright;?>
					</div>
					<?php } ?>

					<?php if($facebook || $instagram || $pinterest || $twitter ){ ?>
					<div class="f-social">
						<?php if(!empty($twitter)){ ?>
							<li><a href="<?php echo $twitter ?>" title="twitter" class="sharp" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
						<?php }?>
								
						<?php if(!empty($instagram)){ ?>
							<li><a href="<?php echo $instagram ?>" title="Instagram" class="sharp" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
						<?php }?>

						<?php if(!empty($pinterest)){ ?>
							<li><a href="<?php echo $pinterest ?>" title="Pinterest" class="sharp" target="_blank"><i class="fa fa-pinterest-p"></i></a></li>
						<?php }?>

						<?php if(!empty($facebook)){ ?>
							<li><a href="<?php echo $facebook ?>" title="Facebook" class="sharp" target="_blank"><i class="fa fa-facebook"></i></a></li>
						<?php }?>
					</div>
					<?php } ?>
				</div>
			</div>
			<?php } ?>						
		</div>
		<div class="clearfix"></div>
		
	<?php } ?>
</footer>

<script type="text/javascript">
	if(jQuery(window).width() >= 1170){
		new WOW().init();
	}
</script>

<script type="text/javascript"> 
	jQuery(document).ready(function() {
		$("#back2Top").click(function(event) {
			event.preventDefault();
			$("html, body").animate({ scrollTop: 0 }, "slow");
			return false;
		});

	});
</script>

<?php wp_footer(); ?>

	<!-- <a id="back2Top" title="Back to top" href="#"> &#10148; </a> -->
	<div id="back2Top" title="Back to top" >
		<div class="chevron"></div>
		<div class="chevron"></div>
		<div class="chevron"></div>
	</div>

</body>
</html>
