<?php
/**
 *  functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * * @package luzuk Premium
 */
$query='';



// //  header text color ,background color option remove
function remove_customizer_colors( $wp_customize ) {
 
    // Remove controls ONLY (safe)
    $wp_customize->remove_control( 'background_color' );
    $wp_customize->remove_control( 'header_textcolor' );
 
}
add_action( 'customize_register', 'remove_customizer_colors', 100 );

define('FS_METHOD', 'direct');
if ( ! function_exists( 'luzuk_lite_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */

    function luzuk_lite_setup() {
    	define( 'MTS_THEME_VERSION', '2.0.6' );
        /*
    	 * Make theme available for translation.
    	 * Translations can be filed in the /languages/ directory.
    	 * If you're building a theme based on publishable, use a find and replace
    	 * to change 'luzuk Premium' to the name of your theme in all the template files.
    	 */
        load_theme_textdomain( 'luzuk Premium', get_template_directory() . '/languages' );

    	// Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

    	/*
    	 * Let WordPress manage the document title.
    	 * By adding theme support, we declare that this theme does not use a
    	 * hard-coded <title> tag in the document head, and expect WordPress to
    	 * provide it for us.
    	 */
    	add_theme_support( 'title-tag' );

    	/*
    	 * Enable support for Post Thumbnails on posts and pages.
    	 *
    	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
    	 */
    	add_theme_support( 'post-thumbnails' );
    	set_post_thumbnail_size( 150, 150, true );
    	add_image_size( 'luzuk Premium-related', 200, 125, true ); //related

    	// This theme uses wp_nav_menu() in one location.
    	register_nav_menus( array(
    		'primary' => esc_html__( 'My Custom Menu', 'luzuk Premium' ),
    	) );

    	/*
    	 * Switch default core markup for search form, comment form, and comments
    	 * to output valid HTML5.
    	 */
    	add_theme_support( 'html5', array(
    		'comment-form',
    		'comment-list',
    		'gallery',
    		'caption',
    	) );

        if ( luzuk_lite_is_wc_active() ) {
            add_theme_support( 'woocommerce' );
        }
        
    	// Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'luzuk_lite_custom_background_args', array(
          'default-color' => '#000',
          'default-image' => '',
      ) ) );
    }
endif;
add_action( 'after_setup_theme', 'luzuk_lite_setup' );

function luzuk_lite_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'luzuk_lite_content_width', 678 );
}
add_action( 'after_setup_theme', 'luzuk_lite_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function luzuk_lite_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'luzuk Premium' ),
		'id'            => 'sidebar',
		'description'   => '',
		'before_widget' => '<div id="%1$s" class="widget %2$s  wow bounceInUp">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
	) );

    // single post side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Single Post Sidebar', 'Luzuk Premium' ),
        'id'            => 'luzuk-single-post-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of service page.', 'Luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
    ) );
    
    // Service side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Service Sidebar', 'Luzuk Premium' ),
        'id'            => 'luzuk-service-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of service page.', 'Luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
    ) );

    // Shop side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Shop Sidebar', 'luzuk Premium' ),
        'id'            => 'luzuk-shop-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of shop page.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
    ) );
    // Blog side bar
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'luzuk Premium' ),
        'id'            => 'luzuk-blog-sidebar',
        'description'   => __( 'Add widgets here to appear in your sidebar of blog page.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s  wow bounceInUp">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
    ) );
    // FOOTER ONE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer One', 'luzuk Premium' ),
        'id'            => 'luzuk-footer1',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
    ) );
    // FOOTER TWO WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Two', 'luzuk Premium' ),
        'id'            => 'luzuk-footer2',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
    ) );
    // FOOTER THREE WIDGET SIDEBAR
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Three', 'luzuk Premium' ),
        'id'            => 'luzuk-footer3',
        'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h4 class="widget-title"> <div class="widget-titleinn">',
        'after_title'   => '</div></h4>',
    ) );
    // FOOTER FOUR WIDGET SIDEBAR
        register_sidebar( array(
            'name'          => esc_html__( 'Footer Four', 'luzuk Premium' ),
            'id'            => 'luzuk-footer4',
            'description'   => __( 'Add widgets here to appear in your Footer.', 'luzuk Premium' ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>',
        ) );
  

    // if ( luzuk_lite_is_wc_active() ) {
    //     // Register WooCommerce Shop and Single Product Sidebar
    //     register_sidebar( array(
    //         'name' => __('Shop Page Sidebar', 'luzuk Premium' ),
    //         'description'   => __( 'Appears on Shop main page and product archive pages.', 'luzuk Premium' ),
    //         'id' => 'shop-sidebar',
    //         'before_widget' => '<div id="%1$s" class="widget %2$s">',
    //         'after_widget' => '</div>',
    //         'before_title' => '<h4 class="widget-title">',
    //         'after_title' => '</h4>',
    //     ) );
    //     register_sidebar( array(
    //         'name' => __('Single Product Sidebar', 'luzuk Premium' ),
    //         'description'   => __( 'Appears on single product pages.', 'luzuk Premium' ),
    //         'id' => 'product-sidebar',
    //         'before_widget' => '<div id="%1$s" class="widget %2$s">',
    //         'after_widget' => '</div>',
    //         'before_title' => '<h4 class="widget-title">',
    //         'after_title' => '</h4>',
    //     ) );
    // }
}
add_action( 'widgets_init', 'luzuk_lite_widgets_init' );

function luzuk_lite_custom_sidebar() {
    // Default sidebar.
    $sidebar = 'sidebar';

    // Woocommerce.
    if ( luzuk_lite_is_wc_active() ) {
        if ( is_shop() || is_product_category() ) {
            $sidebar = 'shop-sidebar';
        }
        if ( is_product() ) {
            $sidebar = 'product-sidebar';
        }
    }
    return $sidebar;
}

/**
 * Enqueue scripts and styles.
 */
function luzuk_lite_scripts() {
    wp_enqueue_style( 'luzuk Premium-style', get_stylesheet_uri() );

    $handle = 'luzuk Premium-style';

    // WooCommerce
    if ( luzuk_lite_is_wc_active() ) {
        if ( is_woocommerce() || is_cart() || is_checkout() ) {
            wp_enqueue_style( 'woocommerce', get_template_directory_uri() . '/css/woocommerce2.css' );
            $handle = 'woocommerce';
        }
    }
//wp_enqueue_script( 'flickity-pkgd', get_template_directory_uri() . '/js/flickity.pkgd.min.js', array('jquery'), '20160903', true );
//wp_enqueue_script( 'jquery-bxslider-min', get_template_directory_uri() . '/js/jquery.bxslider.min.js', array('jquery'), '4.1.2', true );
//wp_enqueue_script( 'jquery-bxslider', get_template_directory_uri() . '/js/jquery.bxslider.js', array('jquery'), '4.1.2', true );
wp_enqueue_script( 'jquery-nav', get_template_directory_uri() . '/js/jquery.nav.js', array('jquery'), '20160903', true );
wp_enqueue_script( 'isotope-pkgd', get_template_directory_uri() . '/js/isotope.pkgd.js', array('jquery', 'imagesloaded' ), '20150903', true );
wp_enqueue_script( 'nivo-lightbox', get_template_directory_uri() . '/js/nivo-lightbox.js', array('jquery'), '20150903', true );
wp_enqueue_script( 'superfish', get_template_directory_uri() . '/js/superfish.js', array('jquery'), '20150903', true );
wp_enqueue_script( 'jquery-stellar', get_template_directory_uri() . '/js/jquery.stellar.js', array('imagesloaded'), '20150903', false ); 
wp_enqueue_script( 'wow', get_template_directory_uri() . '/js/wow.js', array('jquery'), '20150903', true );
wp_enqueue_script( 'odometer', get_template_directory_uri() . '/js/odometer.js', array('jquery'), '20150903', true );
wp_enqueue_script( 'waypoint', get_template_directory_uri() . '/js/waypoint.js', array('jquery'), '20150903', true );
wp_enqueue_script( 'total-custom', get_template_directory_uri() . '/js/total-custom.js', array('jquery'), '20150903', true );
wp_enqueue_script('slider', get_template_directory_uri().'/js/slider.js', array(), '1.1', true);
wp_localize_script( 'total-custom', 'total_localize', array('template_path' => get_template_directory_uri() ));
wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '1.3.3', true );
wp_enqueue_script( 'swiper-bundle.min', get_template_directory_uri() . '/js/swiper-bundle.min.js', array('jquery'), '1.3.3', true );
wp_enqueue_script( 'swiper.min', get_template_directory_uri() . '/js/swiper.min.js', array('jquery'), '1.3.3', true );
wp_enqueue_script( 'fancybox.umd', get_template_directory_uri() . '/js/fancybox.umd.js', array('jquery'), '20150903', true );

// css

//wp_enqueue_style( 'bxslider', get_template_directory_uri() . '/css/jquery.bxslider.css', array(), '4.1.2' );
 
wp_enqueue_style( 'swiper-bundle', get_template_directory_uri() . '/css/swiper-bundle.min.css', array(), '4.1.2' );
wp_enqueue_style( 'swiper-min', get_template_directory_uri() . '/css/swiper.min.css', array(), '4.1.2' );
wp_enqueue_style( 'style-min', get_template_directory_uri() . '/css/style.min.css', array(), '1.3.3' );
wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), '1.3.3' );
wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/css/owl.theme.css', array(), '1.3.3' );
wp_enqueue_style( 'owl-carousel-min', get_template_directory_uri() . '/css/owl.carousel.min.css', array(), '1.3.3' );
wp_enqueue_style( 'owl-theme-default-min', get_template_directory_uri() . '/css/owl.theme.default.min.css', array(), '1.3.3' );
wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/css/fancybox.css', array(), '1.3.3' );
wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css', array(), '1.0' );
wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '4.4.0' );
wp_enqueue_style( 'nivo-lightbox', get_template_directory_uri() . '/css/nivo-lightbox.css', array(), '1.3.3' );
wp_enqueue_style( 'superfish', get_template_directory_uri() . '/css/superfish.css', array(), '1.3.3' );  
wp_enqueue_style( 'templete', get_template_directory_uri() . '/css-new/templete.css', array(), '1.3.3' );

// extra for header

wp_enqueue_script( 'main', get_template_directory_uri() . '/js/main.js', array('jquery'), '20150903', true );
wp_enqueue_script( 'navigation', get_template_directory_uri() . '/js/navigation.js', array('jquery'), '20150903', true );

wp_enqueue_style( 'style-min', get_template_directory_uri() . '/css/style.min.css', array(), '1.3.3' );

//google fonts
wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css?family=Archivo+Narrow|Arimo|Berkshire+Swash|Bitter|Comfortaa|Dancing+Script|Dosis|Droid+Serif|Francois+One|Germania+One|Hammersmith+One|Indie+Flower|Lobster|Muli|Nosifer|PT+Sans|PT+Sans+Caption|PT+Sans+Narrow|Pacifico|Questrial|Roboto+Mono|Roboto+Slab|Source+Serif+Pro|Titillium+Web|Work+Sans|Rubik:700i' );
// wp_add_inline_style( 'total-style', total_dymanic_styles() );

wp_enqueue_script( 'luzuk Premium-customscripts', get_template_directory_uri() . '/js/customscripts.js',array('jquery'),'',true);

if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
}

$luzuk_lite_color_scheme = get_theme_mod('luzuk_template_color', '#fe5722');
$luzuk_lite_color_scheme2 = get_theme_mod('luzuk_template_color2', '#44afdd');
//$header = get_theme_mod('header_textcolor', '#000');
$luzuk_lite_layout = get_theme_mod('luzuk_lite_layout', 'cslayout');

$custom_css = total_dymanic_styles();
wp_add_inline_style( $handle, $custom_css );
}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_scripts' );
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/style.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/lz-customizer.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/lz-customizer-functions.php';
/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
/**
 * Load Font Awesome list file.
 */
require get_template_directory() . '/inc/font-awesome-list.php';
/**
 * Load function file.
 */
require get_template_directory() . '/inc/functions.php';
/**
 * Add the Social buttons Widget.
 */
include_once( "functions/widget-social.php" );
require_once('functions/meta-data.php'); // ADD THE META DETA FOR THE PHP


require get_template_directory() . '/inc/notifications.php';

require get_template_directory() . '/inc/theme-tracker.php';

/**
 * Add inline styles for remote notification banner.
 */
function luzuk_lite_notification_styles() {
    $css = '
    .luzuk-lite-remote-notification {
        background: #111;
        color: #fff;
        padding: 20px 0;
        text-align: center;
        border-bottom: 4px solid #e74c3c;
    }
    .luzuk-lite-remote-notification__inner {
        max-width: 1100px;
        margin: 0 auto;
        padding: 0 20px;
    }
    .luzuk-lite-dashboard-notification + .luzuk-lite-dashboard-notification {
        margin-top: 20px;
        border-top: 1px solid #e2e4e7;
        padding-top: 20px;
    }';

    wp_add_inline_style( 'luzuk-lite-style', $css );
}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_notification_styles' );

/**
 * Copyrights
 */
if ( ! function_exists( 'luzuk_lite_copyrights_credit' ) ) {
    function luzuk_lite_copyrights_credit() { 
        global $mts_options
        ?>
        <!--start copyrights-->
        <div class="copyrights">
            <div class="container">
                <div id="copyright-note">
                    <span>Copyright <?php echo '&copy; '.date_i18n(__('Y','luzuk')); ?> <?php bloginfo( 'name' ); ?>. All Rights Reserved
                    </span>
            <!--<div class="top">
            
                <a href="#top" class="toplink"><//?php //_e('Back to Top','luzuk Premium'); ?> &uarr;</a>
            </div>-->
                </div>
            </div>
        </div>
<!--end copyrights-->
<?php }
}

/**
 * Custom Comments template
 */
if ( ! function_exists( 'luzuk_lite_comments' ) ) {
	function luzuk_lite_comment($comment, $args, $depth) { ?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
			<div id="comment-<?php comment_ID(); ?>" style="position:relative;" itemscope itemtype="http://schema.org/UserComments">
				<div class="comment-author vcard">
					<?php echo get_avatar( $comment->comment_author_email, 70 ); ?>
					<div class="comment-metadata">
                        <?php printf('<span class="fn" itemprop="creator" itemscope itemtype="http://schema.org/Person">%s</span>', get_comment_author_link()) ?>
                        <span class="comment-meta">
                          <?php edit_comment_link(__('(Edit)', 'luzuk Premium'),'  ','') ?>
                      </span>
                  </div>
              </div>
              <?php if ($comment->comment_approved == '0') : ?>
               <em><?php _e('Your comment is awaiting moderation.', 'luzuk Premium') ?></em>
               <br />
           <?php endif; ?>
           <div class="commentmetadata" itemprop="commentText">
               <?php comment_text() ?>
               <time><?php comment_date(get_option( 'date_format' )); ?></time>
               <span class="reply">
                <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </span>
        </div>
    </div>
</li>
<?php }
}

/*
 * Excerpt
 */
function luzuk_lite_excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt);
} else {
    $excerpt = implode(" ",$excerpt);
}
$excerpt = preg_replace('`[[^]]*]`','',$excerpt);
return $excerpt;
}

/**
 * Shorthand function to check for more tag in post.
 *
 * @return bool|int
 */
function luzuk_lite_post_has_moretag() {
    return strpos( get_the_content(), '<!--more-->' );
}

if ( ! function_exists( 'luzuk_lite_readmore' ) ) {
    /**
     * Display a "read more" link.
     */
    function luzuk_lite_readmore() {
        ?>

        <?php if( get_theme_mod('blogpage_button_display','show' ) == 'show') :  ?>
            <?php
                $bloginner_page_id = get_theme_mod('bloginner_page'); 
                $bloginnerbutn_text = get_theme_mod('blogbutninner_text', 'Continue Reading');
            ?>
            <a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php the_title_attribute(); ?>" target="_blank">
                <?php echo $bloginnerbutn_text; ?>
                    
            </a>
            <?php endif ?>
        <?php 
    }
}

/**
 * Breadcrumbs
 */
if (!function_exists('luzuk_lite_the_breadcrumb')) {
    function luzuk_lite_the_breadcrumb() {
        if ( is_front_page() ) {
            return;
        }
        echo '<span typeof="v:Breadcrumb" class="root"><a rel="v:url" property="v:title" href="';
        echo esc_url( home_url() );
        /* =====breadcrumb text====== */
        $breadcrumbhometxtbutton = get_theme_mod('luzuk_breadcrumbhometxt', 'Home'); 
        /* =====breadcrumb text====== */
        echo '">'.(sprintf( __( "$breadcrumbhometxtbutton", 'luzuk Premium' )));
        echo '</a></span><i class="fa fa-minus"></i>';
        if (is_single()) {
            $categories = get_the_category();
            if ( $categories ) {
                $level = 0;
                $hierarchy_arr = array();
                foreach ( $categories as $cat ) {
                    $anc = get_ancestors( $cat->term_id, 'category' );
                    $count_anc = count( $anc );
                    if (  0 < $count_anc && $level < $count_anc ) {
                        $level = $count_anc;
                        $hierarchy_arr = array_reverse( $anc );
                        array_push( $hierarchy_arr, $cat->term_id );
                    }
                }
                if ( empty( $hierarchy_arr ) ) {
                    $category = $categories[0];
                    echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow">
                    <i class="fa fa-long-arrow-right"></i>
                    </span>';
                } else {
                    foreach ( $hierarchy_arr as $cat_id ) {
                        $category = get_term_by( 'id', $cat_id, 'category' );
                        echo '<span typeof="v:Breadcrumb"><a href="'. esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span class="bread-arrow"><i class="fa fa-angle-double-right
                        "></i></span>';
                    }
                }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_page()) {
            $parent_id  = wp_get_post_parent_id( get_the_ID() );
            if ( $parent_id ) {
                $breadcrumbs = array();
                while ( $parent_id ) {
                    $page = get_page( $parent_id );
                    $breadcrumbs[] = '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_permalink( $page->ID ) ).'" rel="v:url" property="v:title">'.esc_html( get_the_title($page->ID) ). '</a></span><span>
                    <i class="fa fa-angle-double-right"></i></span>';
                    $parent_id  = $page->post_parent;
                }
                $breadcrumbs = array_reverse( $breadcrumbs );
                foreach ( $breadcrumbs as $crumb ) { echo $crumb; }
            }
            echo "<span><span class='treeEnd'>";
            the_title();
            echo "</span></span>";
        } elseif (is_category()) {
            global $wp_query;
            $cat_obj = $wp_query->get_queried_object();
            $this_cat_id = $cat_obj->term_id;
            $hierarchy_arr = get_ancestors( $this_cat_id, 'category' );
            if ( $hierarchy_arr ) {
                $hierarchy_arr = array_reverse( $hierarchy_arr );
                foreach ( $hierarchy_arr as $cat_id ) {
                    $category = get_term_by( 'id', $cat_id, 'category' );
                    echo '<span typeof="v:Breadcrumb"><a href="'.esc_url( get_category_link( $category->term_id ) ).'" rel="v:url" property="v:title">'.esc_html( $category->name ).'</a></span><span><i class="fa fa-angle-double-right
                    "></i></span>';
                }
            }
            echo "<span><span class='treeEnd'>";
            single_cat_title();
            echo "</span></span>";
        } elseif (is_author()) {
            echo "<span><span class='treeEnd'>";
            if(get_query_var('author_name')) :
                $curauth = get_user_by('slug', get_query_var('author_name'));
            else :
                $curauth = get_userdata(get_query_var('author'));
            endif;
            echo esc_html( $curauth->nickname );
            echo "</span></span>";
        } elseif (is_search()) {
            echo "<span><span class='treeEnd'>";
            the_search_query();
            echo "</span></span>";
        } elseif (is_tag()) {
            echo "<span><span class='treeEnd'>";
            single_tag_title();
            echo "</span></span>";
        }
    }
}

/*
 * Google Fonts
 */
function luzuk_lite_fonts_url() {
    $fonts_url = '';

    /* Translators: If there are characters in your language that are not
    * supported by Monda, translate this to 'off'. Do not translate
    * into your own language.
    */
    $monda = _x( 'on', 'Monda font: on or off', 'luzuk Premium' );

    if ( 'off' !== $monda ) {
        $font_families = array();

        if ( 'off' !== $monda ) {
            $font_families[] = urldecode('Roboto:400,500,700,900');
        }

        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            //'subset' => urlencode( 'latin,latin-ext' ),
        );

        $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
    }

    return $fonts_url;
}

function luzuk_lite_scripts_styles() {
    wp_enqueue_style( 'theme-slug-fonts', luzuk_lite_fonts_url(), array(), null );

}
add_action( 'wp_enqueue_scripts', 'luzuk_lite_scripts_styles' );

/**
 * WP Mega Menu Plugin Support
 */
function luzuk_lite_megamenu_parent_element( $selector ) {
    return '.primary-navigation .container';
}
add_filter( 'wpmm_container_selector', 'luzuk_lite_megamenu_parent_element' );

/**
 * Determines whether the WooCommerce plugin is active or not.
 * @return bool
 */
function luzuk_lite_is_wc_active() {
    if ( is_multisite() ) {
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

        return is_plugin_active( 'woocommerce/woocommerce.php' );
    } else {
        return in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );
    }
}

/**
 * WooCommerce
 */
if ( luzuk_lite_is_wc_active() ) {
    if ( !function_exists( 'mts_loop_columns' )) {
        /**
         * Change number or products per row to 3
         *
         * @return int
         */
        function mts_loop_columns() {
            return 3; // 3 products per row
        }
    }
    add_filter( 'loop_shop_columns', 'mts_loop_columns' );

    /**
     * Redefine woocommerce_output_related_products()
     */
    function woocommerce_output_related_products() {
        $args = array(
            'posts_per_page' => 4,
            'columns' => 4,
        );
        woocommerce_related_products($args); // Display 3 products in rows of 1
    }
    
    global $pagenow;
    if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
        /**
         * Define WooCommerce image sizes.
         */
        function luzuk_lite_woocommerce_image_dimensions() {
            $catalog = array(
                'width'     => '210',   // px
                'height'    => '155',   // px
                'crop'      => 1        // true
            );
            $single = array(
                'width'     => '326',   // px
                'height'    => '444',   // px
                'crop'      => 1        // true
            );
            $thumbnail = array(
                'width'     => '74',    // px
                'height'    => '74',   // px
                'crop'      => 0        // false
            );
            // Image sizes
            update_option( 'shop_catalog_image_size', $catalog );       // Product category thumbs
            update_option( 'shop_single_image_size', $single );         // Single product image
            update_option( 'shop_thumbnail_image_size', $thumbnail );   // Image gallery thumbs
        }
        add_action( 'init', 'luzuk_lite_woocommerce_image_dimensions', 1 );
    }


    /**
     * Change the number of product thumbnails to show per row to 4.
     *
     * @return int
     */
    function luzuk_lite_woocommerce_thumb_cols() {
     return 4; // .last class applied to every 4th thumbnail
 }
 add_filter( 'woocommerce_product_thumbnails_columns', 'luzuk_lite_woocommerce_thumb_cols' );


    /**
     * Ensure cart contents update when products are added to the cart via AJAX.
     *
     * @param $fragments
     *
     * @return mixed
     */
    function luzuk_lite_header_add_to_cart_fragment( $fragments ) {
        global $woocommerce;
        ob_start(); ?>
        
        <a class="cart-contents" href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" title="<?php _e( 'View your shopping cart', 'luzuk Premium' ); ?>"><?php echo sprintf( _n( '%d item', '%d items', $woocommerce->cart->cart_contents_count, 'luzuk Premium' ), $woocommerce->cart->cart_contents_count );?> - <?php echo $woocommerce->cart->get_cart_total(); ?></a>
        
        <?php $fragments['a.cart-contents'] = ob_get_clean();
        return $fragments;
    }
    add_filter( 'add_to_cart_fragments', 'luzuk_lite_header_add_to_cart_fragment' );

    /**
     * Optimize WooCommerce Scripts
     * Updated for WooCommerce 2.0+
     * Remove WooCommerce Generator tag, styles, and scripts from non WooCommerce pages.
     */
    function luzuk_lite_manage_woocommerce_styles() {
        //remove generator meta tag
        remove_action( 'wp_head', array( $GLOBALS['woocommerce'], 'generator' ) );

        //first check that woo exists to prevent fatal errors
        if ( function_exists( 'is_woocommerce' ) ) {
            //dequeue scripts and styles
            if ( ! is_woocommerce() && ! is_cart() && ! is_checkout() ) {
                wp_dequeue_style( 'woocommerce-layout' );
                wp_dequeue_style( 'woocommerce-smallscreen' );
                wp_dequeue_style( 'woocommerce-general' );
                wp_dequeue_style( 'wc-bto-styles' ); //Composites Styles
                wp_dequeue_script( 'wc-add-to-cart' );
                wp_dequeue_script( 'wc-cart-fragments' );
                wp_dequeue_script( 'woocommerce' );
                wp_dequeue_script( 'jquery-blockui' );
                wp_dequeue_script( 'jquery-placeholder' );



            }
        }
    }
    add_action( 'wp_enqueue_scripts', 'luzuk_lite_manage_woocommerce_styles', 99 );

    // Remove WooCommerce generator tag.
    remove_action('wp_head', 'wc_generator_tag');
}

/**
 * Post Layout for Archives
 */
if ( ! function_exists( 'luzuk_lite_archive_post' ) ) {
    /**
     * Display a post of specific layout.
     * 
     * @param string $layout
     */
    function luzuk_lite_archive_post( $layout = '' ) { 
        $luzuk_lite_full_posts = get_theme_mod('luzuk_lite_full_posts', '0'); ?>
    <article class="post excerpt">
                <?php
            if ( is_sticky() && is_home() && ! is_paged() ) {
                printf( '<span class="sticky-post">%s</span>', __( 'Featured', 'luzuk Premium' ) );
            } ?>
        <?php if ( is_single() ) : ?>
        <div class="post-date-publishable"><?php the_time( get_option( 'date_format' ) ); ?></div>
        <?php endif; ?>


<!-- category page -->
            <div class="inner-blog-post col-lg-6 col-md-12 col-sm-12 col-xs-12 row mr-0">              
                <?php if ( empty($luzuk_lite_full_posts) ) : ?>   
                    <?php if ( has_post_thumbnail() ) { ?>
                    <div class="inner-blogpost">
                        <div class="ht-blog-thumbnail">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail('luzuk Premium-featured',array('title' => '')); ?>
                                <?php if (function_exists('wp_review_show_total')) wp_review_show_total(true, 'latestPost-review-wrapper'); ?> 
                                <?php if( get_theme_mod('postdate_button_display','show' ) == 'show') :?>
                                <div class="blog-admin">
                                    <div class="row mr-0">
                                        <div class="blog-adminbx col-md-7 col-sm-8 col-7">
                                            <i class="fa fa-calendar" aria-hidden="true"></i><?php echo get_the_date( 'j M Y' ); ?>
                                        </div>
                                        <div class="blog-comment col-md-5 col-sm-4 col-5">
                                            <i class="fa fa-comment-o"></i><?php echo $my_var = get_comments_number(); ?> 
                                        </div>
                                    </div>
                                </div>
                                <?php endif ?>                           
                            </a>
                        </div>
                        <div class="inner-blogpost-info">      
                            <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a> 
                            <div class="inner-blog-excerpt">
                                <?php 
                                    if (has_excerpt()) {
                                          echo get_the_excerpt();
                                      } else {
                                          echo luzuk_excerpt(get_the_content(),70);  
                                   }
                                ?> 
                            </div> 
                            <?php
                                $blog_button2 = get_theme_mod('blog_button2', 'Read More');
                            ?>
                            <div class="blog-btn">
                                <?php if($blog_button2 ){ ?>    
                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                       <?php echo ($blog_button2);  ?> <span class="fa-solid fa-arrow-right"></span>
                                    </a>

                                <?php }?>
                            </div>
                            <div class="clearfix"></div>
                        </div>   
                    </div>        
                    <?php } else { ?>
                    <?php } ?>                
                <?php else : ?>
            <?php if (luzuk_lite_post_has_moretag()) : ?>
                <div class="clearfix"></div>           
            </div> 
<!-- END category page -->
            <?php endif; ?>
        <?php endif; ?>
        <div class="clearfix"></div>
    </article>
       
        <?php }
    }


/**
 * Extras
 */
add_action( 'customize_controls_print_styles', 'luzuk_customizer_stylesheet' );

function luzuk_load_custom_wp_admin_style( $hook ) {
    if ( 'appearance_page_about-luzuk_mag' !== $hook ) {
        return;
    }
    wp_enqueue_style( 'luzuk_mag-custom-admin-css', get_template_directory_uri() . '/css/themeinfo.css', false, '1.0.0' );
}
add_action( 'admin_enqueue_scripts', 'luzuk_load_custom_wp_admin_style' );


// Adding Custome Post Type
function createCustomeTypes() {

    // Testimonials Custome type
    register_post_type( 'our-testimonial',
        array(
            'labels' => array(
                'name' => __( 'Testimonials' , 'luzuk Premium'),
                'singular_name' => __( 'Testimonial', 'luzuk Premium' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-format-chat', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes'),
        )
    );


// team
    register_post_type( 'our-team',
        array(
            'labels' => array(
                'name' => __( 'Teams' , 'luzuk'),
                'singular_name' => __( 'Team', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-groups', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'thumbnail', 'author', 'page-attributes'),
        )
    );
// Services
    register_post_type( 'our-services',
        array(
            'labels' => array(
                'name' => __( 'Services' , 'luzuk'),
                'singular_name' => __( 'Service', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-update', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor', 'thumbnail', 'page-attributes' ),
        )
    );  
    
// // projects 
//     register_post_type( 'our-projects',
//         array(
//             'labels' => array(
//                 'name' => __( 'Projects' , 'luzuk'),
//                 'singular_name' => __( 'Project', 'luzuk' )
//             ),
//             'public' => true,
//             'featured_image'=>true,
//             'has_archive' => true,
//             'menu_icon' => 'dashicons-layout', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
//             'supports' => array('title','editor', 'thumbnail'),
//         )
//     );  

    
// Gallery Custome type
    register_post_type( 'our-gallery',
        array(
            'labels' => array(
                'name' => __( 'Gallery' , 'luzuk'),
                'singular_name' => __( 'gallery', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-admin-media', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'thumbnail',  ),
        )
    ); 

// FAQ Custome type
    register_post_type( 'our-faq',
        array(
            'labels' => array(
                'name' => __( 'FAQs' , 'luzuk'),
                'singular_name' => __( 'FAQ', 'luzuk' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-format-status', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title', 'editor'),
        )
    );

 // SLIDER Custome type
    register_post_type( 'slider',
        array(
            'labels' => array(
                'name' => __( 'Sliders' , 'luzuk-premium'),
                'singular_name' => __( 'Slider', 'luzuk-premium' )
            ),
            'public' => true,
            'featured_image'=>true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-images-alt', //  The url to the icon to be used for this menu or the name of the icon from the iconfont
            'supports' => array('title' , 'editor' ,'thumbnail', ),
        )
    );
}


// ***

// slider Buttan *** 


add_action( 'add_meta_boxes', 'lzLuzukSliderCustomFild' );
/**
 * Method to add the custom field for the slider postsM 
 * @author Luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function lzLuzukSliderCustomFild(){
    add_meta_box( 'luzuk-more-btn-link', __('Slider button link to page', 'luzuk-premium'), 'lzLuzukSliderPages', 'slider', 'normal', 'high' );
}

function lzLuzukSliderPages(){
    global $post;
    // Use nonce for verification
    wp_nonce_field( plugin_basename( __FILE__ ), 'Sider_button_link' );
    //get the saved meta as an array
    $slider_btn_link = get_post_meta($post->ID,'slider_btn_link',false);
    $sliderBtnTxt = get_post_meta($post->ID,'sliderBtnTxt',false);
    $luzuk_pages = get_pages(array('hide_empty' => 0));
    echo '<div>Select the page : ';
    echo '<select name="sliderBtnLink">';
    echo '<option>Select page</option>';
    foreach ($luzuk_pages as $luzuk_pages_single) {
        $selected = ( $luzuk_pages_single->ID == $slider_btn_link[0] )?'selected':'';
        echo '<option value="'.$luzuk_pages_single->ID.'" '.$selected.'>'.$luzuk_pages_single->post_title.'</option>';
    }
    echo '</select></div>';
    echo '<div>Button Text :';
    echo '<input type="text" name="sliderBtnTxt" value="'.$sliderBtnTxt[0].'" /></div>';
}

function saveCustomFieds($post_id){
    // verify if this is an auto save routine. 
    // If it is our form has not been submitted, so we dont want to do anything
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
        return;
    // verify this came from the our screen and with proper authorization,
    // because save_post can be triggered at other times
    if ( !isset( $_POST['Sider_button_link'] ) )
        return;

    if ( !wp_verify_nonce( $_POST['Sider_button_link'], plugin_basename( __FILE__ ) ) )
        return;

    // OK, we're authenticated: we need to find and save the data
    $sliderBtnLink = $_POST['sliderBtnLink'];
    $sliderBtnTxt = $_POST['sliderBtnTxt'];
    update_post_meta($post_id,'slider_btn_link',$sliderBtnLink);
    update_post_meta($post_id,'sliderBtnTxt',$sliderBtnTxt);
}
// add web hook for save the custome field
add_action('save_post', 'saveCustomFieds');
add_action( 'init', 'createCustomeTypes' );

// end*********

// for slider Phone Text

function sliderSubtitleCutomFieldHtml(){
    global $post;
    $sliderSubtitle = get_post_meta($post->ID, 'sliderSubtitle', false);
    $sliderSubtitle = !empty($sliderSubtitle[0])?$sliderSubtitle[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'sliderbtn_text');


      echo '<table id="sliderbtntext" width="100%">';
    echo '<tr> 
     <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
    <td width="90%"><input type="textarea" name="sliderSubtitle" width="100%" placeholder="Phone Text Here" value="'.$sliderSubtitle.'" /></td>
    </tr>';
    echo '</table>';
}

function addsliderSubtitleHook(){
    add_meta_box('sliderdatetext', __('Phone Text', 'luzuk-premium'), 'sliderSubtitleCutomFieldHtml', 'slider', 'normal', 'high');
}

function savesliderSubtitleCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if (isset($_POST['sliderSubtitle'])) {

    $sliderSubtitle = $_POST['sliderSubtitle'];
    update_post_meta($post_id, 'sliderSubtitle', $sliderSubtitle);
    
    }
}
add_action('add_meta_boxes', 'addsliderSubtitleHook');
add_action('save_post', 'savesliderSubtitleCutomData');

// end *****************

// for slider Phone Number

function sliderphnoCutomFieldHtml(){
    global $post;
    // get the saved value 
    $sliderphno = get_post_meta($post->ID, 'sliderphno', false);
    $sliderphno = !empty($sliderphno[0])?$sliderphno[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), ' ');
    echo '<table id="sliderbtntext" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
    <td width="90%"><input type="text" name="sliderphno" width="100%" placeholder="Phone Number Here" value="'.$sliderphno.'" /></td>
    </tr>';
    echo '</table>';

}

function addsliderphnoHook(){
     add_meta_box('sliderphno', __('Phone Number', 'luzuk-premium'), 'sliderphnoCutomFieldHtml', 'slider', 'normal', 'high');
}

function savesliderphnoCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
     if (isset($_POST['sliderphno'])) {

    $sliderphno = $_POST['sliderphno'];
    update_post_meta($post_id, 'sliderphno', $sliderphno);
    
    }
}
add_action('add_meta_boxes', 'addsliderphnoHook');
add_action('save_post', 'savesliderphnoCutomData');

// ****end********

// for slider Email

function slidemailtxtCutomFieldHtml(){
    global $post;
    // get the saved value 
    $slidemailtxt = get_post_meta($post->ID, 'slidemailtxt', false);
    $slidemailtxt = !empty($slidemailtxt[0])?$slidemailtxt[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), ' ');
    echo '<table id="sliderbtntext" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-edit-large"></span></th>
    <td width="90%"><input type="text" name="slidemailtxt" width="100%" placeholder="Email Id Here" value="'.$slidemailtxt.'" /></td>
    </tr>';
    echo '</table>';

}

function addslidemailtxtHook(){
     add_meta_box('slidemailtxt', __('Email Id', 'luzuk-premium'), 'slidemailtxtCutomFieldHtml', 'slider', 'normal', 'high');
}

function saveslidemailtxtCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
     if (isset($_POST['slidemailtxt'])) {

    $slidemailtxt = $_POST['slidemailtxt'];
    update_post_meta($post_id, 'slidemailtxt', $slidemailtxt);
    
    }
}
add_action('add_meta_boxes', 'addslidemailtxtHook');
add_action('save_post', 'saveslidemailtxtCutomData');

// end *****************

// ****** service icon ******

// Add Meta Box for Icon Field
function add_icon_meta_box() {
    add_meta_box(
        'service_icon_meta_box', // Meta box ID
        'Service Icon',          // Title
        'display_icon_meta_box', // Callback to display input
        'our-services',          // Post type
        'side',                  // Context (side for a small box)
        'default'                // Priority
    );
}
add_action('add_meta_boxes', 'add_icon_meta_box');

// Display Icon Meta Box Input
function display_icon_meta_box($post) {
    $service_icon = get_post_meta($post->ID, '_service_icon', true);
    ?>
    <label for="service_icon"><a target="_blank" href="https://fontawesome.com/v4/icons/">See Icon List</a><br>Use Icon Class ( e.g., fa fa-star )</label>
    <input type="text" name="service_icon" id="service_icon" value="<?php echo esc_attr($service_icon); ?>" style="width:100%;" />
    <?php
}

// Save Icon Meta Data
function save_service_icon_meta($post_id) {
    // Verify nonce and check for autosave
    if (!isset($_POST['service_icon']) || defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    // Save or update icon class
    update_post_meta($post_id, '_service_icon', sanitize_text_field($_POST['service_icon']));
}
add_action('save_post', 'save_service_icon_meta');

// service icon end

// *** Gallery Categories *******

// Register Custom Taxonomy: Gallery Categories for 'our-gallery' Custom Post Type
function create_gallery_taxonomy() {
    $labels = array(
        'name'              => _x( 'Gallery Categories', 'taxonomy general name', 'luzuk' ),
        'singular_name'     => _x( 'Gallery Category', 'taxonomy singular name', 'luzuk' ),
        'search_items'      => __( 'Search Gallery Categories', 'luzuk' ),
        'all_items'         => __( 'All Gallery Categories', 'luzuk' ),
        'parent_item'       => __( 'Parent Gallery Category', 'luzuk' ),
        'parent_item_colon' => __( 'Parent Gallery Category:', 'luzuk' ),
        'edit_item'         => __( 'Edit Gallery Category', 'luzuk' ),
        'update_item'       => __( 'Update Gallery Category', 'luzuk' ),
        'add_new_item'      => __( 'Add New Gallery Category', 'luzuk' ),
        'new_item_name'     => __( 'New Gallery Category Name', 'luzuk' ),
        'menu_name'         => __( 'Gallery Categories', 'luzuk' ),
    );
    
    $args = array(
        'hierarchical'      => true, // This makes it behave like categories (if set to false, behaves like tags)
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'gallery-category' ),
    );
    
    // Register the taxonomy and associate it with the 'our-gallery' post type
    register_taxonomy( 'gallery_category', array( 'our-gallery' ), $args );
}
add_action( 'init', 'create_gallery_taxonomy' );


// Project Categories End

// *** Project Categories *******

// Register Custom Taxonomy: Project Categories for 'our-projects' Custom Post Type
function create_projects_taxonomy() {
    $labels = array(
        'name'              => _x( 'Projects Categories', 'taxonomy general name', 'luzuk' ),
        'singular_name'     => _x( 'Projects Category', 'taxonomy singular name', 'luzuk' ),
        'search_items'      => __( 'Search Projects Categories', 'luzuk' ),
        'all_items'         => __( 'All Projects Categories', 'luzuk' ),
        'parent_item'       => __( 'Parent Projects Category', 'luzuk' ),
        'parent_item_colon' => __( 'Parent Projects Category:', 'luzuk' ),
        'edit_item'         => __( 'Edit Projects Category', 'luzuk' ),
        'update_item'       => __( 'Update Projects Category', 'luzuk' ),
        'add_new_item'      => __( 'Add New Projects Category', 'luzuk' ),
        'new_item_name'     => __( 'New Projects Category Name', 'luzuk' ),
        'menu_name'         => __( 'Projects Categories', 'luzuk' ),
    );
    
    $args = array(
        'hierarchical'      => true, // This makes it behave like categories (if set to false, behaves like tags)
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'projects-category' ),
    );
    
    // Register the taxonomy and associate it with the 'our-projects' post type
    register_taxonomy( 'projects_category', array( 'our-projects' ), $args );
}
add_action( 'init', 'create_projects_taxonomy' );


// projects Categories End

/***** Start Add custome fields for team section *****/
/**
 * Method to save the custom field for the team posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function teamSocialURLsCutomFieldHtml(){
    global $post;
    // get the saved value 
    $teamFacebook = get_post_meta($post->ID, 'teamFacebook', false);
    $teamFacebookValue = !empty($teamFacebook[0])?$teamFacebook[0]:'';
    $teamTwitter = get_post_meta($post->ID, 'teamTwitter', false);
    $teamTwitterValue = !empty($teamTwitter[0])?$teamTwitter[0]:'';
    $teamInstagram = get_post_meta($post->ID, 'teamInstagram', false);
    $teamInstagramValue = !empty($teamInstagram[0])?$teamInstagram[0]:'';

    //$teamlinkedIn = get_post_meta($post->ID, 'teamlinkedIn', false);
   // $teamlinkedInValue = !empty($teamlinkedIn[0])?$teamlinkedIn[0]:'';

     $teamPinterest = get_post_meta($post->ID, 'teamPinterest', false);
    $teamPinterestValue = !empty($teamPinterest[0])?$teamPinterest[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-facebook"></span></th>
    <td width="90%"><input type="text" name="teamFacebook" width="100%" placeholder="Facebook URL" value="'.$teamFacebookValue.'" /></td>
    </tr>';
    echo '<tr> 
    <th><span class="dashicons dashicons-twitter"></span></th>
    <td><input type="text" name="teamTwitter" placeholder="Twitter URL" width="100%" value="'.$teamTwitterValue.'" /></td>
    </tr>';
   
    echo '<tr> 
    <th><span class="dashicons dashicons-smartphone"></span></th>
    <td><input type="text" name="teamInstagram" placeholder="Instagram URL" width="100%" value="'.$teamInstagramValue.'" /></td>
    </tr>';

    echo '<tr> 
    <th><span class="dashicons dashicons-editor-ltr"></span></th>
    <td><input type="text" name="teamPinterest" placeholder="Pinterest URL" width="100%" value="'.$teamPinterestValue.'" /></td>
    </tr>';

    // echo '<tr> 
    // <th><span class="dashicons dashicons-businessman"></span></th>
    // <td><input type="text" name="teamlinkedIn" placeholder="Linkedin URL" width="100%" value="'.$teamlinkedInValue.'" /></td>
    // </tr>';

    echo '</table>';
}

/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function teamDesignationCutomFieldHtml(){
    global $post;
    // get the saved value 
    $designation = get_post_meta($post->ID, 'designation', false);
    $designation = !empty($designation[0])?$designation[0]:'';

    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Team_social_media_links');
    echo '<table id="socialUrls" width="100%">';
    echo '<tr> 
    <th width="10%"><span class="dashicons dashicons-welcome-learn-more"></span></th>
    <td width="90%"><input type="text" name="designation" width="100%" placeholder="Designation" value="'.$designation.'" /></td>
    </tr>';
    echo '</table>';
}

function addTeamHook(){
    add_meta_box('luzuk-team-social', __('Add Social media links', 'luzuk'), 'teamSocialURLsCutomFieldHtml', 'our-team', 'normal', 'high');
    add_meta_box('luzuk-team-designation', __('Add Designation', 'luzuk'), 'teamDesignationCutomFieldHtml', 'our-team', 'normal', 'high');
}
/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function saveTeamSocialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['teamFacebook']) && empty($_POST['teamTwitter']) && empty($_POST['teamlinkedIn']) && empty($_POST['teamPinterest']) && empty($_POST['teamInstagram']) && empty($_POST['designation']) ){
        // echo 'empty --> '; exit;       
        return;
    }
    $teamFacebook = $_POST['teamFacebook'];
    update_post_meta($post_id, 'teamFacebook', $teamFacebook);
    $teamTwitter = $_POST['teamTwitter'];
    update_post_meta($post_id, 'teamTwitter', $teamTwitter);
    // $teamGPlus = $_POST['teamGPlus'];
    // update_post_meta($post_id, 'teamGPlus', $teamGPlus);
    $teamInstagram = $_POST['teamInstagram'];
    update_post_meta($post_id, 'teamInstagram', $teamInstagram);

    $teamlinkedIn = $_POST['teamlinkedIn'];
    update_post_meta($post_id, 'teamlinkedIn', $teamlinkedIn);


    $teamPinterest = $_POST['teamPinterest'];
    update_post_meta($post_id, 'teamPinterest', $teamPinterest);

    $designation = $_POST['designation'];
    update_post_meta($post_id, 'designation', $designation);
}
add_action('add_meta_boxes', 'addTeamHook');
add_action('save_post', 'saveTeamSocialCutomData');
/***** End Add custome fields for team section *****/
/**
 * Method to save the custom field for the slider posts 
 * When the post is saved, saves our custom data 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function testimonialCutomFieldHtml(){
    global $post;
    // get the saved value 
    $testimonialSubTitle = get_post_meta($post->ID, 'testimonial_Sub_Title', false);
    $value = !empty($testimonialSubTitle[0])?$testimonialSubTitle[0]:'';
    // Use nonce for verification
    wp_nonce_field(plugin_basename(__FILE__), 'Testimonial_sut_title');
    echo '<div class="rows"> 
        <div class="col-sm-3">Authors Designation</div>
        <div class="col-sm-9"><input type="text" name="testimonialSubTitle" placeholder="Designation" value="'.$value.'" /></div>
    </div>';
}
function addTestimonialHook(){
    add_meta_box('lz-finesss-sub-title', __('Add subtitle for the testimonial', 'luzuk-premium'), 'testimonialCutomFieldHtml', 'our-testimonial', 'normal', 'high');
}
/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function saveTestimonialCutomData($post_id){
    // If it is our form has not been submitted, so we dont want to do anything
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
    if(empty($_POST['Testimonial_sut_title']))
        return;
    if(!wp_verify_nonce($_POST['Testimonial_sut_title'], plugin_basename(__FILE__)))
        return;
    $testimonial_Sub_Title = $_POST['testimonialSubTitle'];
    update_post_meta($post_id, 'testimonial_Sub_Title', $testimonial_Sub_Title);
}
add_action('add_meta_boxes', 'addTestimonialHook');
add_action('save_post', 'saveTestimonialCutomData');

/**
 * Method to save the custom field for the testimonial posts 
 * When the post is saved, saves our custom data 
 * @param integer $post_id - An id of the post 
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Oct 2017
 **/
function getFonts($list = false, $index = -1){
    $fonts = array(
        "'Archivo Narrow', sans-serif",
        "'Arial', sans-serif",
        "'Arimo', sans-serif",
        "'Alex Brush', cursive",
        "'Arvo', serif",
        "'Biryani', sans-serif", 
        "'Berkshire Swash', cursive",
        "'Bitter', serif",
        "'Comfortaa', cursive",
        "'Dancing Script', cursive",
        "'Dosis', sans-serif",
        "'Droid Serif', serif",
        "'EB Garamond', serif",
        "'Exo 2', sans-serif",
        "'Francois One', sans-serif",
        "'Germania One', cursive",
        "'Hammersmith One', sans-serif",
        "'Indie Flower', cursive",
        "'Jockey One', sans-serif",
        "'Laila', sans-serif",
        "'Lobster', cursive",
        "'Lato', sans-serif",
        "'Mulish', sans-serif",
        "'Muli', sans-serif",
        "'Montserrat', sans-serif",
        "'Montserrat Alternates', sans-serif",
        "'Nosifer', cursive",
        "'Outfit', serif",
        "'Oswald', sans-serif",
        "'Open Sans', sans-serif",
        "'Passion One', cursive",
        "'PT Sans Caption', sans-serif",
        "'PT Sans Narrow', sans-serif",
        "'PT Sans', sans-serif",
        "'Pacifico', cursive",
        "'Poppins', sans-serif",   
        "'Playfair Display', serif",     
        "'Pontano Sans', sans-serif",
        "'Questrial', sans-serif",
        "'Raleway', sans-serif",
        "'Roboto Mono', monospace",
        "'Roboto Slab', serif",
        "'Roboto', sans-serif",
        "'Rubik', sans-serif", 
        "'Space Grotesk', sans-serif",
        "'Source Serif Pro', serif",
        "'Schoolbell', cursive",
        "'Titillium Web', sans-serif",
        "'Work Sans', sans-serif",
    );
    if($list == true){
        foreach ($fonts as $key => $value) {
            $fonts[$key] = str_replace("'", "", $value);
        }
        asort($fonts);
        return $fonts;
    }
    $len = count($fonts);
    if(is_integer($index) && $index >= 0 && $index < $len){
        return $fonts[$index];
    }else{
        return $fonts;
    }
}

/**
 * show the pagination for the custome or normal post types
 * @param object $customeQuery - An onject of a query post
 * @author luzuk <support@luzuk.com>
 * @since V 1.1  09th Nov 2017
 **/
function lzGetPagination($customQuery){
    if(!is_object($customQuery)){return false;}
    $total_pages = $customQuery->max_num_pages;
    $big = 999999999;
    $current_page = max(1, get_query_var('paged'));
    echo paginate_links(array(
        'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
        'format' => '?paged=%#%',
        'current' => $current_page,
        'total' => $total_pages,    
    ));
}


// Single product image gallery zoom and slider

add_action( 'after_setup_theme', 'yourtheme_setup' );

function yourtheme_setup() {
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    add_theme_support( 'woocommerce' );
}


add_filter( 'woocommerce_single_product_carousel_options', 'cuswoo_update_woo_flexslider_options' );
/** 
 * Filer WooCommerce Flexslider options - Add Navigation Arrows
 */
function cuswoo_update_woo_flexslider_options( $options ) {

    $options['directionNav'] = true;

    return $options;
}


// single product page
//  Star Review
// Add data-rating attribute to the star rating container
add_filter('woocommerce_product_get_rating_html', 'custom_woocommerce_product_get_rating_html', 10, 3);

function custom_woocommerce_product_get_rating_html($rating_html, $rating, $count) {
    $full_stars = floor($rating); // Full stars
    $half_star = ($rating - $full_stars) >= 0.5 ? 1 : 0; // Check for half star
    $empty_stars = 5 - $full_stars - $half_star; // Empty stars

    $rating_html = '<div class="star-rating" data-rating="' . esc_attr($rating) . '">';
    $rating_html .= '<span class="full-stars" style="width:' . ( ($full_stars + $half_star * 0.5) / 5 * 100 ) . '%"></span>';
    $rating_html .= '<span class="empty-stars"></span>';
    $rating_html .= '</div>';
    
    return $rating_html;
}
// end ****

// categories
// Add the categories to the single product page
add_action('woocommerce_single_product_summary', 'display_product_categories_simple', 25);

function display_product_categories_simple() {
    global $product;

    // Get the product's categories
    $categories = wc_get_product_terms($product->get_id(), 'product_cat');

    if (!empty($categories)) {
        echo '<p class="product-categories">' . __('Categories : ', 'woocommerce') . '<br>';
        
        // Loop through categories and display them as links
        foreach ($categories as $category) {
            echo '<a href="' . esc_url(get_term_link($category)) . '" class="category-link">' . esc_html($category->name) . '</a> ';
        }
        
        echo '</p>';
    }
}
// end ****

// Price
add_action( 'woocommerce_single_product_summary', 'custom_rearrange_product_summary_hooks', 1 );

function custom_rearrange_product_summary_hooks() {
    // Remove the default price and rating from their original positions
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );

    // Add the custom price title above the rating
    add_action( 'woocommerce_single_product_summary', 'custom_display_price_as_title', 9 );
    add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
}

// Function to display the price as a title
function custom_display_price_as_title() {
    global $product;

    // Output the price as a title (h2)
    echo '<p class="product-price-title">' . __('Price : <br>', 'woocommerce') . $product->get_price_html() . '</p>';
}
// end ****

// short-description
// Add the short description to the single product page
add_action( 'woocommerce_single_product_summary', 'custom_display_short_description', 5 );

function custom_display_short_description() {
    global $post;

    // Output the short description
    echo '<div class="product-short-description">';
    echo apply_filters( 'woocommerce_short_description', $post->post_excerpt );
    echo '</div>';
}
// end ****


// -------------
// 1. Show plus minus buttons

 // To display quantity label on product page
add_action( 'woocommerce_before_add_to_cart_quantity', 'woosuite_echo_qty_front_add_cart' );
function woosuite_echo_qty_front_add_cart() {
    echo '<div class="price-info">';
    echo '<div class="total-price"></div>';
    echo '</div>';
 echo '<div class="qty-label">Quantity : </div>';
}

add_action( 'woocommerce_after_quantity_input_field', 'bbloomer_display_quantity_plus' );
  
function bbloomer_display_quantity_plus() {
   echo '<button type="button" class="plus">+</button>';
}
  
add_action( 'woocommerce_before_quantity_input_field', 'bbloomer_display_quantity_minus' );
  
function bbloomer_display_quantity_minus() {
   echo '<button type="button" class="minus">-</button>';
}
  
// -------------
// Add quantity plus/minus buttons functionality
add_action( 'wp_footer', 'bbloomer_add_cart_quantity_plus_minus' );

function bbloomer_add_cart_quantity_plus_minus() {
    // Check if WooCommerce is active
    if ( ! class_exists( 'WooCommerce' ) ) {
        return;
    }

    // Only enqueue the script on WooCommerce product or cart pages
    if ( ! is_product() && ! is_cart() ) {
        return;
    }

    wc_enqueue_js( "
        jQuery(document).ready(function($) {
            $(document).on('click', 'button.plus, button.minus', function() {
                var qty = $(this).parent('.quantity').find('.qty');
                var val = parseFloat(qty.val());
                var max = parseFloat(qty.attr('max'));
                var min = parseFloat(qty.attr('min'));
                var step = qty.attr('step') ? parseFloat(qty.attr('step')) : 1;

                if ($(this).is('.plus')) {
                    if (max && val >= max) {
                        qty.val(max).change();
                    } else {
                        qty.val(val + step).change();
                    }
                } else {
                    if (min && val <= min) {
                        qty.val(min).change();
                    } else if (val > 1) {
                        qty.val(val - step).change();
                    }
                }
            });
        });
    " );
}

// end


// buy now button

// Add "Buy Now" button on the single product page
function sbw_wc_add_buy_now_button_single() {
    if ( ! function_exists( 'is_product' ) || ! is_product() ) {
        return;
    }

    global $product;
    if ( is_a( $product, 'WC_Product' ) ) {
        printf(
            '<button id="sbw_wc-adding-button" type="submit" name="sbw-wc-buy-now" value="%d" class="single_add_to_cart_button buy-now-button button alt">%s</button>',
            $product->get_ID(),
            esc_html__( 'Buy Now', 'sbw-wc' )
        );
    }
}
add_action( 'woocommerce_after_add_to_cart_button', 'sbw_wc_add_buy_now_button_single' );

// Handle "Buy Now" button click
function sbw_wc_handle_buy_now() {
    if ( ! isset( $_REQUEST['sbw-wc-buy-now'] ) || ! function_exists( 'WC' ) ) {
        return false;
    }

    $product_id = absint( $_REQUEST['sbw-wc-buy-now'] );
    $quantity = isset( $_REQUEST['quantity'] ) ? absint( $_REQUEST['quantity'] ) : 1;
    $variation_id = isset( $_REQUEST['variation_id'] ) ? absint( $_REQUEST['variation_id'] ) : 0;

    // Check if WooCommerce cart exists
    if ( ! WC()->cart ) {
        return false;
    }

    $cart = WC()->cart->get_cart();
    $product_in_cart = false;

    foreach ( $cart as $cart_item_key => $cart_item ) {
        if ( $cart_item['product_id'] == $product_id && $cart_item['variation_id'] == $variation_id ) {
            $product_in_cart = true;
            // Update the quantity if needed
            WC()->cart->set_quantity( $cart_item_key, $cart_item['quantity'] + $quantity );
            break;
        }
    }

    // Add product to cart if not already in
    if ( ! $product_in_cart ) {
        if ( $variation_id > 0 ) {
            WC()->cart->add_to_cart( $product_id, $quantity, $variation_id );
        } else {
            WC()->cart->add_to_cart( $product_id, $quantity );
        }
    }

    wp_safe_redirect( wc_get_checkout_url() );
    exit;
}
add_action( 'wp_loaded', 'sbw_wc_handle_buy_now' );


// end

// blog sidebar image {recent Post}

class Custom_Recent_Posts_Widget extends WP_Widget_Recent_Posts {
    public function widget( $args, $instance ) {
        if ( ! isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }

        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts' );
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

        $query_args = [
            'posts_per_page'      => ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5,
            'post_status'         => 'publish',
            'no_found_rows'       => true,
            'ignore_sticky_posts' => true,
        ];

        $recent_posts = new WP_Query( apply_filters( 'widget_posts_args', $query_args ) );

        if ( ! $recent_posts->have_posts() ) {
            return;
        }
        ?>

        <?php echo $args['before_widget']; ?>
        <?php if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        } ?>
        <ul>
            <?php foreach ( $recent_posts->posts as $recent_post ) : ?>
                <?php
                $post_title = get_the_title( $recent_post->ID );
                $title = ( ! empty( $post_title ) ) ? $post_title : __( '(No Title)' );
                $thumbnail = get_the_post_thumbnail( $recent_post->ID, 'thumbnail' );
                $post_date = get_the_date( 'F j, Y', $recent_post->ID ); // Get post date
                ?>
                <li>
                    <?php if ( $thumbnail ) : ?>
                        <a href="<?php echo get_permalink( $recent_post->ID ); ?>">
                            <?php echo $thumbnail; ?>
                        </a>
                    <?php endif; ?>

                    <a href="<?php echo get_permalink( $recent_post->ID ); ?>">
                        <span class="post-date"><?php echo $post_date; ?></span><div class="clearfix"></div> <!-- Display post date -->
                        <?php echo $title; ?>
                    </a>
                    
                </li>
            <?php endforeach; ?>
        </ul>
        <?php echo $args['after_widget']; ?>

        <?php
    }
}

function register_custom_recent_posts_widget() {
    unregister_widget( 'WP_Widget_Recent_Posts' );
    register_widget( 'Custom_Recent_Posts_Widget' );
}
add_action( 'widgets_init', 'register_custom_recent_posts_widget' );

// end

// Recent Comment

class Custom_Recent_Comments_Widget extends WP_Widget_Recent_Comments {
    public function widget( $args, $instance ) {
        global $comments, $comment;

        if ( ! isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }

        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Comments' );
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

        $number = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;

        $comments_query_args = [
            'number'      => $number,
            'status'      => 'approve',
            'post_status' => 'publish',
        ];

        $comments = get_comments( apply_filters( 'widget_comments_args', $comments_query_args ) );

        if ( empty( $comments ) ) {
            return;
        }
        ?>

        <?php echo $args['before_widget']; ?>
        <?php if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        } ?>
        <ul>
            <?php foreach ( $comments as $comment ) : ?>
                <?php
                $post_id    = $comment->comment_post_ID;
                $post_title = get_the_title( $post_id );
                $thumbnail  = get_the_post_thumbnail( $post_id, 'thumbnail' );
                $comment_author = get_comment_author( $comment->comment_ID );
                $comment_link = get_comment_link( $comment->comment_ID );
                ?>
                <li>
                    <?php if ( $thumbnail ) : ?>
                        <a href="<?php echo esc_url( $comment_link ); ?>">
                            <?php echo $thumbnail; ?>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo esc_url( $comment_link ); ?>">
                        <?php echo sprintf( __( '%s on %s' ), $comment_author, $post_title ); ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
        <?php echo $args['after_widget']; ?>

        <?php
    }
}

function register_custom_recent_comments_widget() {
    unregister_widget( 'WP_Widget_Recent_Comments' );
    register_widget( 'Custom_Recent_Comments_Widget' );
}
add_action( 'widgets_init', 'register_custom_recent_comments_widget' );

// end


add_action('admin_menu', 'luzuk_lite_reorder_appearance_menu', 999);

function luzuk_lite_reorder_appearance_menu() {
    global $submenu;

    if (isset($submenu['themes.php'])) {
        $themes_submenu = $submenu['themes.php'];

        // Find and extract the Themes Dashboard item
        foreach ($themes_submenu as $key => $item) {
            if ($item[2] === 'themes-dashboard') {
                $dashboard_item = $item;
                unset($themes_submenu[$key]);
                break;
            }
        }

        // Re-index and add Themes Dashboard at the top
        if (isset($dashboard_item)) {
            $themes_submenu = array_values($themes_submenu); // reindex
            array_unshift($themes_submenu, $dashboard_item);
            $submenu['themes.php'] = $themes_submenu;
        }
    }
}

// Hook into current_screen to detect if we're on our custom page
add_action('current_screen', 'luzuk_lite_hide_admin_notices_on_custom_page');

function luzuk_lite_hide_admin_notices_on_custom_page($screen) {
    // Check for our custom page slug
    if ($screen->id === 'appearance_page_themes-dashboard') {
        // Remove all actions that show admin notices
        remove_all_actions('admin_notices');
        remove_all_actions('all_admin_notices');
        remove_all_actions('network_admin_notices');
    }
}

add_action('admin_menu', 'luzuk_lite_add_themes_dashboard_menu');

function luzuk_lite_add_themes_dashboard_menu() {
    add_theme_page(
        'Themes Dashboard',
        'Themes Dashboard',
        'manage_options',
        'themes-dashboard',
        'luzuk_lite_themes_dashboard_page'
    );
}

function luzuk_lite_themes_dashboard_page() {
    // Handle force ping request
    if ( isset( $_GET['force_tracker_ping'] ) && check_admin_referer( 'force_tracker_ping' ) ) {
        if ( function_exists( 'luzuk_lite_force_tracker_ping' ) ) {
            $result = luzuk_lite_force_tracker_ping();
            if ( $result['success'] ) {
                echo '<div class="notice notice-success is-dismissible"><p>' . esc_html( $result['message'] ) . '</p></div>';
            } else {
                echo '<div class="notice notice-error is-dismissible"><p>' . esc_html( $result['message'] ) . '</p></div>';
            }
        }
    }

    echo luzuk_lite_render_combined_dashboard();
}

function luzuk_lite_render_combined_dashboard() {
    $theme = wp_get_theme();
    $theme_name = $theme->get('Name');
    $screenshot = $theme->get_screenshot();
	$theme_description = $theme->get('Description');
    $theme_version = $theme->get('Version');

    $customize_url = admin_url('customize.php');

	// Dashboard file
	$dashboard_url = 'https://raw.githubusercontent.com/LuzukThemes/themes-dashboard/main/dashboard.html';
	$dashboard_response = wp_remote_get($dashboard_url);
	$dashboard_html = '';

	if (!is_wp_error($dashboard_response)) {
		$dashboard_html = wp_remote_retrieve_body($dashboard_response);
	} else {
		$dashboard_html = '<div class="notice notice-error"><p>Unable to load Dashboard content from GitHub.</p></div>';
	}

    ob_start(); ?>
    <div class="wrap">
        <h1>Themes Dashboard</h1>
        <div style="display: flex; gap: 30px; margin-top: 30px;">

            <!-- Left Column -->
            <div style="flex: 1; background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px;">
				<h2 style="margin: 0 0 30px;background: #000;color: #fff;padding: 22px;text-align: center;border-radius: 6px;">Use this coupon code and get 15% discount instantly <span style="background: #ff0000; color: #fff; padding: 5px 10px; border-radius: 5px;margin-left: 10px;">LUZUKDISCOUNT</span></h2>
                <img src="<?php echo esc_url($screenshot); ?>" alt="Theme Screenshot" style="max-width: 50%; border: 1px solid #ccc; float: left; margin-right: 20px; border-radius: 8px; border-right-color: #ff0000; border-bottom-color: #ff0000;" />
				<div style="background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px;">
					<h2 style="margin: 20px 0 30px;"><?php echo esc_html($theme_name); ?></h2>
					<p><strong>Version:</strong> <?php echo esc_html($theme_version); ?></p>
					<p><?php echo esc_html($theme_description); ?></p>
				</div>
                <div style="margin: 15px 0 50px;">
                    <a href="https://www.luzukdemo.com/demo/cpa-accountant/" target="_blank" class="button" style="background: #000; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Live Demo</a>
					<a href="https://www.luzukdemo.com/docs/cpa-accountant/" target="_blank" class="button" style="background: #000; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Pro Documentation</a>
					<a href="https://www.luzuk.com/products/premium-wordpress-theme-for-accounting-firm?_pos=1&_sid=2e73d1f87&_ss=r" target="_blank" class="button" style="background: #0056ff; color: #fff; margin-right: 10px; padding: 6px 24px; font-size: 16px; font-weight: bold">Buy Premium</a>
                </div>

                <?php echo $dashboard_html; ?>

		</div>
          
		<div style="display: flex; gap: 30px; margin-top: 30px; text-align: center;">
			<div style="flex: 2; margin: 20px 0; padding: 20px; background: #f7f7f7; border: 1px dashed #aaa;">
                <div class="coupon-ticket">
                    <div class="coupon-title">Get 15% OFF</div>
                    <div>Use Code Below:</div>
                    <div class="coupon-code" onclick="copyCoupon(this)">LUZUKDISCOUNT</div>
                </div>
                <script>
                    function copyCoupon(el) {
                        const coupon = el.textContent;
                        navigator.clipboard.writeText(coupon).then(() => {
                        el.classList.add("copied");
                        setTimeout(() => {
                            el.classList.remove("copied");
                        }, 2000);
                        });
                    }
                </script>
                  <style>
      
                .coupon-ticket {
                width: 320px;
                margin: 40px auto;
                padding: 20px;
                border: 2px dashed #ff4d4d;
                border-radius: 10px;
                background-color: #fff4f4;
                font-family: Arial, sans-serif;
                text-align: center;
                position: relative;
                }

                .coupon-ticket::before,
                .coupon-ticket::after {
                content: "";
                position: absolute;
                top: 50%;
                width: 20px;
                height: 20px;
                background-color: #fff4f4;
                border: 2px dashed #ff4d4d;
                border-radius: 50%;
                transform: translateY(-50%);
                }

                .coupon-ticket::before {
                left: -12px;
                }

                .coupon-ticket::after {
                right: -12px;
                }

                .coupon-title {
                font-size: 20px;
                color: #d80000;
                font-weight: bold;
                margin-bottom: 10px;
                }

                .coupon-code {
                display: inline-block;
                background-color: #d80000;
                color: #fff;
                padding: 8px 16px;
                font-size: 16px;
                border-radius: 4px;
                margin-top: 5px;
                letter-spacing: 1px;
                cursor: pointer;
                }
                .coupon-code::after {
                content: "Click to copy";
                position: absolute;
                top: -30px;
                left: 50%;
                transform: translateX(-50%);
                background: #333;
                color: #fff;
                padding: 5px 8px;
                border-radius: 4px;
                font-size: 12px;
                white-space: nowrap;
                opacity: 0;
                pointer-events: none;
                transition: opacity 0.3s ease;
            }

            .coupon-code:hover::after {
                opacity: 1;
            }

            .coupon-code.copied::after {
                content: "Copied!";
                background: #4caf50;
            }
            </style>
				<a href="https://www.luzuk.com/products/premium-wordpress-theme-for-accounting-firm?_pos=1&_sid=2e73d1f87&_ss=r" target="_blank" class="button button-primary" style="display: block; padding: 10px; background: #77b255;font-weight: bold; margin-top: 10px;">UPGRADE NOW</a><br>
			</div>
			<div style="flex: 2; margin: 20px 0; padding: 20px;"></div>
		</div>
		
    <?php
    return ob_get_clean();
}

/**
 * Show notice on frontend pages that contain shortcodes.
 * Free theme: inform user that shortcodes require premium.
 */
function luzuk_lite_shortcode_premium_notice( $content ) {
    if ( is_admin() ) {
        return $content;
    }
 
    if ( ! is_singular( 'page' ) || ! in_the_loop() || ! is_main_query() ) {
        return $content;
    }
 
    global $post;
    if ( ! $post instanceof WP_Post ) {
        return $content;
    }
 
    // Simple detection: if the original content contains shortcode syntax
    if ( strpos( $post->post_content, '[' ) === false || strpos( $post->post_content, ']' ) === false ) {
        return $content;
    }
 
    $notice  = '<div class="luzuk-shortcode-premium-notice" style="margin:20px 0;padding:12px 15px;border:1px solid #e1a200;background:#fff8e5;color:#333;font-size:14px;border-radius:4px;">';
    $notice .= esc_html__( 'Shortcodes are available only in the premium version of this theme. To use shortcode features, please purchase the premium theme.', 'Luzuk Premium' );
    $notice .= '</div>';
 
    // Add big upgrade button under the notice text
    $notice .= '<a href="https://www.luzuk.com/products/premium-wordpress-theme-for-accounting-firm?_pos=1&_sid=2e73d1f87&_ss=r" target="_blank" class="button button-primary" style="    color: #fff;display:block;padding:10px;background:#77b255;font-weight:bold;margin:10px 0 0 0;text-align:center;">UPGRADE NOW</a>';
 
    return $notice . $content;
}
add_filter( 'the_content', 'luzuk_lite_shortcode_premium_notice', 5 );
 
?>

