<?php

$wp_customize->add_panel(
	'luzuk_general_panel',
	array(
		'priority' => 19,
		'title' => __('General Configuration', 'luzuk Premium')
	)
);

//STATIC FRONT PAGE
$wp_customize->add_section( 'static_front_page', array(
	'title' => __( 'Static Front Page', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
	'description' => __( 'Your theme supports a static front page.', 'luzuk Premium'),
) );

//TITLE AND TAGLINE SETTINGS
$wp_customize->add_section( 'title_tagline', array(
	'title' => __( 'Site Logo/Title/Tagline', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

addColorPalatOption($wp_customize, 'header_SiteTitleClr', 'title_tagline', 'Title Color', '#000');

addColorPalatOption($wp_customize, 'header_SiteTaglineClr', 'title_tagline', 'Tagline Color', '#000');

$wp_customize->add_setting( 'head_tagline_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'head_tagline_display', array( 'label' => 'Tagline Display', 'section' => 'title_tagline', 'settings' => 'head_tagline_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show ', 'hide' => 'Hide ', ), ) ); 

//BACKGROUND IMAGE
$wp_customize->add_section( 'background_image', array(
	'title' => __( 'Background Image Setting', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );

//Header IMAGE
$wp_customize->add_section( 'header_image', array(
	'title' => __( 'Header Image', 'luzuk Premium' ),
	'panel' => 'luzuk_general_panel',
) );


//HEADER SETTINGS
$wp_customize->add_section(
	'header_settings',
	array(
		'title' => __( 'Header Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

lzCustomLable($wp_customize, 'stickyheader_view', 'header_settings', 'Sticky Header Settings');
    //ENABLE/DISABLE STICKY HEADER
$wp_customize->add_setting(
    'luzuk_sticky_header_enable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'luzuk_sticky_header_enable',
        array(
            'settings'      => 'luzuk_sticky_header_enable',
            'section'       => 'header_settings',
            'label'         => __( 'Sticky Header', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Enable', 'luzuk-premium' ),
                'off' => __( 'Disable', 'luzuk-premium' )
            )   
        )
    )
);


$sectionHeader = 'header_settings';


lzCustomLable($wp_customize, 'pages_logosetmaxwidth5', 'title_tagline', 'Set Logo Width & Height');

$wp_customize->add_setting(
    'pages_logoTopsetmaxwidth',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '100%', 'luzuk-premium' )

    )
);

// logo width

$wp_customize->add_control(
    'pages_logoTopsetmaxwidth',
    array(
        'settings'      => 'pages_logoTopsetmaxwidth',
        'section'       => 'title_tagline',
        'type'          => 'range',
        'label'         => __( 'Width', 'luzuk-premium' )
    )
);

// logo height

$wp_customize->add_setting(
    'pages_logoTopsetmaxheight',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'pages_logoTopsetmaxheight',
    array(
        'settings'      => 'pages_logoTopsetmaxheight',
        'section'       => 'title_tagline',
        'type'          => 'text',
        'label'         => __( 'Height ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'luzuk_headerlogo_margin', 'header_settings', 'Logo Margin');

$wp_customize->add_setting(
    'logo_logoTmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoTmargin',
    array(
        'settings'      => 'logo_logoTmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoRmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoRmargin',
    array(
        'settings'      => 'logo_logoRmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Right', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoBmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoBmargin',
    array(
        'settings'      => 'logo_logoBmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'logo_logoLmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0px', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'logo_logoLmargin',
    array(
        'settings'      => 'logo_logoLmargin',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Left', 'luzuk-premium' )
    )
);




lzCustomLable($wp_customize, 'header_MenuColorssettings', $sectionHeader, 'Navigation Color');

addColorPalatOption($wp_customize, 'header_mainbrdClr', 'header_settings', 'Header Border Color', '#b4b1ac');

addColorPalatOption($wp_customize, 'header_innpagetopmenusClr', 'header_settings', 'Inner Page Menus Color', '#1C3434');

addColorPalatOption($wp_customize, 'header_topmenusColor', 'header_settings', 'Menus Color', '#1C3434');

addColorPalatOption($wp_customize, 'header_topmenushoverColor', 'header_settings', 'Menus Hover Color', '#17a739');

addColorPalatOption($wp_customize, 'header_topmenusactiveColor', 'header_settings', 'Active Menus Color', '#17a739');

addColorPalatOption($wp_customize, 'header_topsubmenusColor', 'header_settings', 'Header Sub Menus Color', '#000');

addColorPalatOption($wp_customize, 'header_topsubmenusbrdclr', 'header_settings', 'Header Sub Menus Border Color', '#f1f1f1');

addColorPalatOption($wp_customize, 'header_topsubmenushvrColor', 'header_settings', 'Sub Menus Hover & Sub Menus Active Color', '#17a739');

addColorPalatOption($wp_customize, 'header_submenusbgsscColor', 'header_settings', 'Dropdown Box BG Color', '#fff');


lzCustomLable($wp_customize, 'header-btn', 'header_settings', 'Header Button');
$wp_customize->add_setting(
    'h_bttn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'APPOINTMENT', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'h_bttn_text',
    array(
        'settings'      => 'h_bttn_text',
        'section'       => 'header_settings',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('h_bttnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('h_bttnlink',
    array(
        'settings'      => 'h_bttnlink',
        'section'       => 'header_settings',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'header_btntxtclr', 'header_settings', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'header_btntxthvclr', 'header_settings', 'Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'header_btnbgclr', 'header_settings', 'Button BG Color', '#1C3434');

addColorPalatOption($wp_customize, 'header_btnbghvclr', 'header_settings', 'Button BG Hover Color', '#17a739');


lzCustomLable($wp_customize, 'header_colorsfortabandmobview', $sectionHeader, 'Responsive Header Color');

addColorPalatOption($wp_customize, 'header_topheadbgclr', 'header_settings', 'Header BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_respnavtoggbarbgssColor', 'header_settings', 'Toggle Bar Color', '#000');

addColorPalatOption($wp_customize, 'header_respnavbsbgssColor', 'header_settings', ' Navigation Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenutitleColor', 'header_settings', 'Menus Title Color', '#000');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenutitlebgColor', 'header_settings', 'Menus Title BG Color', '#D5D5D8');

addColorPalatOption($wp_customize, 'header_navigationrespnavmenubgColor', 'header_settings', 'Menus BG Color', '#e7e7e7');


// 

//COLOR SETTINGS
$wp_customize->add_section( 'colors', array(
	'title' => __( 'Colors' , 'luzuk Premium'),
	'panel' => 'luzuk_general_panel',
) );


   $wp_customize->add_setting('luzuk_premium_color_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_color_section_lbl',
        array(
            'settings'      => 'luzuk_premium_color_section_lbl',
            'section'       => 'colors',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);


//BREADCRUMB SETTINGS
$wp_customize->add_section(
	'luzuk_breadcrumb_settings',
	array(
		'title' => __( 'Breadcrumb Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

//for breadcrumb to show & hide button

$wp_customize->add_setting( 'breadcrumb_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'breadcrumb_button_display', array( 'label' => 'Breadcrumb Display', 'section' => 'luzuk_breadcrumb_settings', 'settings' => 'breadcrumb_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 


$wp_customize->add_setting(
        'luzuk_breadcrumbhometxt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Home', 'luzuk' )
        )
    );
    $wp_customize->add_control(
        'luzuk_breadcrumbhometxt',
        array(
            'settings'      => 'luzuk_breadcrumbhometxt',
            'section'       => 'luzuk_breadcrumb_settings',
            'type'          => 'text',
            'label'         => __( 'Add Breadcrumb Text Here', 'luzuk' )
        )
    );

//addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlebgcolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box BG Color', '#FC6441');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title Color', '#fff');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbcurrenttitlehovercolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Title Hover Color', '#74FB94');

addColorPalatOption($wp_customize, 'luzuk_template_innerpage_breadcrumbtitlecolor', 'luzuk_breadcrumb_settings', 'Breadcrumb Box Current Title Color', '#74FB94');


// end to show & hide button

//POSTPAGEDATE SETTINGS
$wp_customize->add_section(
	'luzuk_blogpage_settings',
	array(
		'title' => __( 'Inner Blog Page Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

 $wp_customize->add_setting('luzuk_premium_blog_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_blog_section_lbl',
        array(
            'settings'      => 'luzuk_premium_blog_section_lbl',
            'section'       => 'luzuk_blogpage_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);



//FOOTER COPYRIGHT SETTINGS
$wp_customize->add_section(
	'footer_area',
	array(
		'title' => __( 'Footer Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

backgroundManager($wp_customize, 'footer', 'footer_area', $color='#1C3434', get_template_directory_uri().'/images/default.png', 'img');


lzCustomLable($wp_customize, 'footer_areaPadding', 'footer_area', 'Footer Padding');

$wp_customize->add_setting(
    'sec_footerseTpmargin', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '7em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footerseTpmargin',
    array(
        'settings'      => 'sec_footerseTpmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'sec_footersebtmargin',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sec_footersebtmargin',
    array(
        'settings'      => 'sec_footersebtmargin',
        'section'       => 'footer_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


lzCustomLable($wp_customize, 'footerarea_conwidth', 'footer_area', 'Footer Width ');

$wp_customize->add_setting('footer_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'footer_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'footer_area', // Replace with your actual section ID
    'settings' => 'footer_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'footer_copytext', 'footer_area', 'Footer Copyright Text');

$wp_customize->add_setting(
    'footer_area_copyrighttext',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '© Copyright 2025. All Rights Reserved.', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'footer_area_copyrighttext',
    array(
        'settings'      => 'footer_area_copyrighttext',
        'section'       => 'footer_area',
        'type'          => 'textarea',
        'label'         => __( 'Footer Copyright Text', 'luzuk Premium' )
    )
);

addColorPalatOption($wp_customize, 'footerarea_copytxtclr', 'footer_area', 'CopyRight Text Color', '#F4F1EA');

addColorPalatOption($wp_customize, 'footerarea_copytxtbrdclr', 'footer_area', 'CopyRight Border Color', '#F4F1EA');

// 
lzCustomLable($wp_customize, 'footsmedia', 'footer_area', 'CopyRight Social Media');

// pinterest
$wp_customize->add_setting('fter_twitt',array('default'=> 'https://twitter.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('fter_twitt',
    array(
        'settings'      => 'fter_twitt',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Twitter Url', 'luzuk-premium' )
    )
);

// Instagram
$wp_customize->add_setting('fter_insta',array('default'=> 'https://instagram.com/','sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('fter_insta',
    array(
        'settings'      => 'fter_insta',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Instagram Url', 'luzuk-premium' )
    )
);

// TWITTER
$wp_customize->add_setting('fter_pin', array('default'=> 'https://pinterest.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('fter_pin',
    array(
        'settings'      => 'fter_pin',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Pinterest Url', 'luzuk-premium' )
    )
);

// FACEBOOK 
$wp_customize->add_setting('fter_fb', array('default'=> 'https://facebook.com', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('fter_fb',
    array(
        'settings'      => 'fter_fb',
        'section'       => 'footer_area',
        'type'          => 'url',
        'label'         => __( 'Facebook Url', 'luzuk-premium' )
    )
);

// Footer  Color
lzCustomLable($wp_customize, 'footer_allcolor', 'footer_area', 'Footer Color');

addColorPalatOption($wp_customize, 'footerarea_title_color', 'footer_area', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_text_color', 'footer_area', 'Text Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_icon_color', 'footer_area', 'Icon Color', '#74FB94');

addColorPalatOption($wp_customize, 'footerarea_sicon_color', 'footer_area', 'Social Icon Color', '#74FB94');

addColorPalatOption($wp_customize, 'footerarea_siconbghv_clr', 'footer_area', 'Social Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menuicn_color', 'footer_area', 'Menu Icon Color', '#74FB94');

addColorPalatOption($wp_customize, 'footerarea_menu_color', 'footer_area', 'Menu Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_menuhover_clr', 'footer_area', 'Menu Hover Color', '#74FB94');

addColorPalatOption($wp_customize, 'footerarea_activemenu_clr', 'footer_area', 'Active Menu Color', '#74FB94');

addColorPalatOption($wp_customize, 'footerarea_datext_color', 'footer_area', 'Date Text Color', '#fff');

addColorPalatOption($wp_customize, 'FooterAreatabgColor', 'footer_area', 'Form Text BG Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtextlabel_color', 'footer_area', 'Label Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formtext_color', 'footer_area', 'Form Text & Placeholder Text Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formbuttontext_clr', 'footer_area', 'Form Button Text Color', '#000');

addColorPalatOption($wp_customize, 'footerarea_formbtntxthv_clr', 'footer_area', 'Form Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'footerarea_formbuttonbg_clr', 'footer_area', 'Form Button BG Color', '#74fb95');

addColorPalatOption($wp_customize, 'footerarea_formbuttonbrd_clr', 'footer_area', 'Form Button BG Hover Color', '#000');

//SHOP PAGE SIDEBAR SETTINGS
$wp_customize->add_section(
	'luzuk_shopsidebar_settings',
	array(
		'title' => __( 'Shop Page Sidebar Settings', 'luzuk Premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

// to show & hide button
$wp_customize->add_setting( 'cd_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'cd_button_display', array( 'label' => 'Shop Sidebar Display', 'section' => 'luzuk_shopsidebar_settings', 'settings' => 'cd_button_display', 'type' => 'radio', 'choices' => array( 'show' => 'Show', 'hide' => 'Hide', ), ) ); 
// end to show & hide button

$wp_customize->add_section(
	'luzuk_innerpageshortcode_page_settings',
	array(
		'title' => __( 'Color Setting For Shortcode Pages', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

 $wp_customize->add_setting('luzuk_premium_colorsetting_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_colorsetting_section_lbl',
        array(
            'settings'      => 'luzuk_premium_colorsetting_section_lbl',
            'section'       => 'luzuk_innerpageshortcode_page_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);



$wp_customize->add_section(
	'luzuk_innerpagefont_settings',
	array(
		'title' => __( 'Inner Page Settings', 'luzuk-premium' ),
		'panel' => 'luzuk_general_panel',
	)
);

 $wp_customize->add_setting('luzuk_premium_innerpage_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_innerpage_section_lbl',
        array(
            'settings'      => 'luzuk_premium_innerpage_section_lbl',
            'section'       => 'luzuk_innerpagefont_settings',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( '<b>This section available only for PRO version</b><br>If you want this section click on <b>Go Pro</b>', 'luzuk-premium' ),
        )
    )
);
