<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#fff', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'abtarea_conwidth', 'about_area', 'Section Width ');

$wp_customize->add_setting('abt_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'abt_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'about_area', // Replace with your actual section ID
    'settings' => 'abt_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'abtarea_subimag', 'about_area', 'Section Image');

$wp_customize->add_setting(
    'about_subimg',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_subimg',
        array(
            'section' => 'about_area',
            'settings' => 'about_subimg',
            'description' => __('Recommended Image Size: 490X420', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'yer_num',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '20 + Years', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'yer_num',
    array(
        'settings'      => 'yer_num',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Numrical ', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'yer_exp',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'of proven experience', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'yer_exp',
    array(
        'settings'      => 'yer_exp',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Year Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'abtdec_exnumclr', 'about_area', 'Years Number Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_extxtbrdclr', 'about_area', 'Years Box Border Color', '#868686');

addColorPalatOption($wp_customize, 'abtdec_exbxbgclr', 'about_area', 'Years Box BG Color', '#1C3434');

// Right

lzCustomLable($wp_customize, 'aboutarea_rightclr', 'about_area', 'Section Right Side');

$wp_customize->add_setting(
    'about_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'ABOUT CPA, Charlene Assam.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_subtitle',
    array(
        'settings'      => 'about_subtitle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Sub Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abt_subtitleclr', 'about_area', 'Sub Title Color ', '#1C3434');

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Expert CPA Tax Services: Maximizing Savings, Minimizing Stress.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abt_titleclr', 'about_area', 'Title Color ', '#1C3434');

$wp_customize->add_setting(
    'about_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Taxation is the cornerstone of a functioning society, enabling governments to fund essential services such as healthcare, education, infrastructure, and public safety', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_txt',
    array(
        'settings'      => 'about_txt',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abt_txtclr', 'about_area', 'Text Color ', '#1C3434');

$wp_customize->add_setting(
    'about_list_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Taxation is the cornerstone of a functioning society, enabling governments to fund essential services such as healthcare, education, infrastructure, and public safety', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_list_txt',
    array(
        'settings'      => 'about_list_txt',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section List ', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'abt_listclr', 'about_area', 'List Color ', '#1C3434');

lzCustomLable($wp_customize, 'abtsec_btnclr', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'MORE ABOUT ME', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtbtn_text',
    array(
        'settings'      => 'abtbtn_text',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('abtbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abtdec_btntxtclr', 'about_area', 'Button Text Color', '#1C3434');

addColorPalatOption($wp_customize, 'abtdec_btntxthvclr', 'about_area', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_btnBGclr', 'about_area', 'Button BG Color', '#74FB94');

addColorPalatOption($wp_customize, 'abtdec_btnBGhvclr', 'about_area', 'Button BG Hover Color', '#1C3434');

