<?php 
    $wp_customize->add_section(
        'appointment_area',
        array(
            'title' => __( 'Appointment Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'appointment_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'appointment_area_disable',
            array(
                'settings'      => 'appointment_area_disable',
                'section'       => 'appointment_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'appointmentus', 'appointment_area', $color='#1C3434', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'appointmentarea_padding', 'appointment_area', 'Section Padding');

$wp_customize->add_setting(
    'appoinmentsection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_toppadding',
    array(
        'settings'      => 'appoinmentsection_toppadding',
        'section'       => 'appointment_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'appoinmentsection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appoinmentsection_bottompadding',
    array(
        'settings'      => 'appoinmentsection_bottompadding',
        'section'       => 'appointment_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'apparea_conwidth', 'appointment_area', 'Section Width ');

$wp_customize->add_setting('app_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container-fluid'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'app_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'appointment_area', // Replace with your actual section ID
    'settings' => 'app_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'appointmentarea_leftclr', 'appointment_area', 'Section Left Side');

$wp_customize->add_setting(
    'appointment_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'AWARDS', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appointment_subtitle',
    array(
        'settings'      => 'appointment_subtitle',
        'section'       => 'appointment_area',
        'type'          => 'text',
        'label'         => __( 'Sub Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'app_subtitleclr', 'appointment_area', 'Sub Title Color ', '#fff');

$wp_customize->add_setting(
    'appointment_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'UNLOCK FINANCIAL EXCELLENCE WITH <span> CPA BOOKKEEPING SERVICES! </span>', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'appointment_title',
    array(
        'settings'      => 'appointment_title',
        'section'       => 'appointment_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'app_titleclr', 'appointment_area', 'Title Color ', '#fff');

addColorPalatOption($wp_customize, 'app_titlehighclr', 'appointment_area', 'Title Highlight Color ', '#74FB94');


lzCustomLable($wp_customize, 'appsec_btnclr', 'appointment_area' , 'Section Button');

$wp_customize->add_setting(
    'appbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'BOOK A FREE CONSULTAION', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'appbtn_text',
    array(
        'settings'      => 'appbtn_text',
        'section'       => 'appointment_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('appbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('appbtnlink',
    array(
        'settings'      => 'appbtnlink',
        'section'       => 'appointment_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'appdec_btntxtclr', 'appointment_area', 'Button Text Color', '#1C3434');

addColorPalatOption($wp_customize, 'appdec_btntxthvclr', 'appointment_area', 'Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'appdec_btnBGclr', 'appointment_area', 'Button BG Color', '#74FB94');

addColorPalatOption($wp_customize, 'appdec_btnBGhvclr', 'appointment_area', 'Button BG Hover Color', '#1C3434');

lzCustomLable($wp_customize, 'apparea_phset', 'appointment_area', 'Phone Setting');

$wp_customize->add_setting(
    'appbtnphnetxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Free Call Now', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'appbtnphnetxt',
    array(
        'settings'      => 'appbtnphnetxt',
        'section'       => 'appointment_area',
        'type'          => 'text',
        'label'         => __( 'Phone Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'appbtnphneno',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+123 456 7890', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'appbtnphneno',
    array(
        'settings'      => 'appbtnphneno',
        'section'       => 'appointment_area',
        'type'          => 'text',
        'label'         => __( 'Phone Number ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'appdec_phicnbgclr', 'appointment_area', 'Phone Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'appdec_phtxtclr', 'appointment_area', 'Phone Text Color', '#fff');

addColorPalatOption($wp_customize, 'appdec_phnumclr', 'appointment_area', 'Phone Number Color', '#fff');

addColorPalatOption($wp_customize, 'appdec_phnumhvclr', 'appointment_area', 'Phone Number Hover Color', '#74FB94');


lzCustomLable($wp_customize, 'apparea_subimag', 'appointment_area', 'Section Image');

$wp_customize->add_setting(
    'appointment_subimg',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'appointment_subimg',
        array(
            'section' => 'appointment_area',
            'settings' => 'appointment_subimg',
            'description' => __('Recommended Image Size: 570X430', 'luzuk-premium')
        )
    )
);
