<?php
/**
 * Createing a bog pannel for customizer
 *
 *
 */
$categories = get_categories(array('hide_empty' => 0));
foreach ($categories as $category) {
    $cat[$category->term_id] = $category->cat_name;
}
/****************************/
// START BLOG SECTION FOR HOME PAGE
/*============BLOG PANEL============*/
$wp_customize->add_section(
    'blog_area',
    array(
        'title' => __( 'Blog Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel',
        //'priority' => '50',
    )
);
//ENABLE/DISABLE BLOG SECTION
$wp_customize->add_setting(
    'blog_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'blog_section_disable',
        array(
            'settings'      => 'blog_section_disable',
            'section'       => 'blog_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'blog', 'blog_area', $color='#F4F1EA', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'blog_area_blogsectionpadding', 'blog_area', 'Section Padding');

$wp_customize->add_setting(
    'blog_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaTpadding',
    array(
        'settings'      => 'blog_areaTpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'blog_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_areaBpadding',
    array(
        'settings'      => 'blog_areaBpadding',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'blogarea_conwidth', 'blog_area', 'Section Width ');

$wp_customize->add_setting('blog_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'blog_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'blog_area', // Replace with your actual section ID
    'settings' => 'blog_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'blogearea_headingaling', 'blog_area', 'Heading Alignment ');

$wp_customize->add_setting('blog_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'center'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'blog_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'blog_area', // Replace with your actual section ID
    'settings' => 'blog_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );

lzCustomLable($wp_customize, 'blogarea_headingcase', 'blog_area', 'Heading Style');

$wp_customize->add_setting('blog_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'blog_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'blog_area', // Replace with your actual section ID
    'settings' => 'blog_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


$wp_customize->add_setting(
    'blog_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'blog_title_subtitle_heading',
        array(
            'settings'      => 'blog_title_subtitle_heading',
            'section'       => 'blog_area',
            'label'         => __( 'Section Heading ', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'blog_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Latest Blog', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_title',
    array(
        'settings'      => 'blog_title',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'blogarea_headingclr', 'blog_area', 'Heading Color', '#1C3434');

$wp_customize->add_setting(
    'blog_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Nunc consectetur diam sit amet ligula fermentum, sed varius elit consectetur. Suspendisse potenti. Duis sed tellus vitae erat', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'blog_txt',
    array(
        'settings'      => 'blog_txt',
        'section'       => 'blog_area',
        'type'          => 'textarea',
        'label'         => __( 'Heading Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'blogarea_headingtxtclr', 'blog_area', 'Heading Text Color', '#1C3434');

lzCustomLable($wp_customize, 'blog_area_blogspost', 'blog_area', 'Number Of Post ');
//BLOG SETTINGS
$wp_customize->add_setting(
    'blog_post_count',
    array(
        'default'           => '3',
        'sanitize_callback' => 'luzuk_sanitize_choices'
    )
);
$wp_customize->add_control(
    new luzuk_Dropdown_Chooser(
        $wp_customize,
        'blog_post_count',
        array(
            'settings'      => 'blog_post_count',
            'section'       => 'blog_area',
            'label'         => __( 'Number Of Post To Show', 'luzuk-premium' ),
            'choices'       => $luzuk_post_count_choice
        )
    )
);


// CREATING A BLOG SECTION IN CUSTOMIZER FOR BLOG PAGES
$wp_customize->add_section(
    'premium_blog_area',
    array(
        'title' => __( 'Blog Page Settings', 'luzuk-premium' ),
        // 'panel' => 'luzuk_premium_home_panel'
        'priority' =>19
    )
);

$wp_customize->add_setting('blog_categories_settings', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control('blog_categories_settings', array(
    'settings' => 'blog_categories_settings',
    'label'    => __('Posts on Blog Page', 'luzuk-premium'),
    'section'  => 'lpremium_blog_area',
    'type'     => 'radio',
    'choices'  => array(
        '0' => __('Excerpts','luzuk-premium'),
        '1' => __('Full Posts','luzuk-premium'),
    ),
));
// ADDING THE CATEGORY TO SELECT
$wp_customize->add_setting('luzuk_blog_categories', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Checkbox_Multiple(
        $wp_customize,
        'luzuk_blog_categories',
        array(
            'label' => __('Exclude Category From Blog Posts', 'luzuk-premium'),
            'section' => 'premium_blog_area',
            'settings' => 'luzuk_blog_categories',
            'choices' => $luzuk_cat
        )
    )
);

lzCustomLable($wp_customize, 'blog_area_color', 'blog_area', 'Section Color');

addColorPalatOption($wp_customize, 'blogarea_bxbgclr', 'blog_area', 'Box BG Color', '#fff'); 

addColorPalatOption($wp_customize, 'blogarea_bxbrdclr', 'blog_area', 'Box Border Color', '#CFCDCD'); 

addColorPalatOption($wp_customize, 'blogarea_iconadminclr', 'blog_area', 'Date & Comment Color', '#fff');

addColorPalatOption($wp_customize, 'blogarea_iconadminbgclr', 'blog_area', 'Date & Comment BG Color', '#1C3434');

addColorPalatOption($wp_customize, 'blogarea_Titleclr', 'blog_area', 'Title Color', '#1C3434');

addColorPalatOption($wp_customize, 'blogarea_Titlehvclr', 'blog_area', 'Title Hover Color', '#17a739');

addColorPalatOption($wp_customize, 'blogarea_textclr', 'blog_area', 'Text Color', '#1C3434');

lzCustomLable($wp_customize, 'blog_area_btnclr', 'blog_area' , 'Section Button');

$wp_customize->add_setting(
    'blogbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'READ MORE', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'blogbtn_text',
    array(
        'settings'      => 'blogbtn_text',
        'section'       => 'blog_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

addColorPalatOption($wp_customize, 'blogsec_btntxtclr', 'blog_area', 'Button Text Color', '#1C3434');

addColorPalatOption($wp_customize, 'blogsec_btntxthvclr', 'blog_area', 'Button Text Hover Color', '#17a739');
