<?php  

$wp_customize->add_section(
    'counter_area',
    array(
        'title' => __('Counter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

// ENABLE/DISABLE FEATURED SECTION
$wp_customize->add_setting(
    'counter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'counter_area_disable',
        array(
            'settings'      => 'counter_area_disable',
            'section'       => 'counter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'counter', 'counter_area', $color='#1C3434', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'countersection_padding', 'counter_area', ' Section Padding ');

$wp_customize->add_setting(
    'countersection_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'countersection_toppadding',
    array(
        'settings'      => 'countersection_toppadding',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'countersection_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'countersection_bottompadding',
    array(
        'settings'      => 'countersection_bottompadding',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'counterearea_conwidth', 'counter_area', 'Section Width ');

$wp_customize->add_setting('counter_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'counter_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'counter_area', // Replace with your actual section ID
    'settings' => 'counter_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );

lzCustomLable($wp_customize, 'counterearea_leftclr', 'counter_area', 'Section Left Side');

$wp_customize->add_setting(
    'countertitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Awards & Recognition', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'countertitle',
    array(
        'settings'      => 'countertitle',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Section Title ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'counter_sectitlClr', 'counter_area', 'Section Title Color', '#fff');

$wp_customize->add_setting(
    'countertrxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'List any awards, recognitions, or certifications earned by the firm or individual lawyers. This establishes credibility and showcases professional achievements.Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia curae; Sed a congue sem.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'countertrxt',
    array(
        'settings'      => 'countertrxt',
        'section'       => 'counter_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'counter_sectxtClr', 'counter_area', 'Section Text Color', '#fff');

lzCustomLable($wp_customize, 'counterearea_phset', 'counter_area', 'Phone Setting');


$wp_customize->add_setting(
    'phne_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Free Call Now', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'phne_txt',
    array(
        'settings'      => 'phne_txt',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Phone Text ', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'phne_no',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '+123 456 7890', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'phne_no',
    array(
        'settings'      => 'phne_no',
        'section'       => 'counter_area',
        'type'          => 'text',
        'label'         => __( 'Phone Number ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'counter_phicnbgClr', 'counter_area', 'Phone Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'counter_phtxtClr', 'counter_area', 'Phone Text Color', '#fff');

addColorPalatOption($wp_customize, 'counter_phnumClr', 'counter_area', 'Phone Number Color', '#fff');

addColorPalatOption($wp_customize, 'counter_phnumhvClr', 'counter_area', 'Phone Number Hover Color', '#74FB94');


$wp_customize->add_setting('counter_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'counter_npp_heading',
        array(
            'settings'      => 'counter_npp_heading',
            'section'       => 'counter_area',
            'label'         => __( 'Number Of Counter To Show', 'Luzuk Premium' ),
        )
    )
);    


$wp_customize->add_setting('counter_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'counter_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'counter_area', // Replace with your actual section ID
        'settings' => 'counter_npp_count',
        'choices'=>array(1,2,3,4,5,6)
    ) ) );


//FEATURED PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'counter_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'counter_header'.$i,
            array(
                'settings'      => 'counter_header'.$i,
                'section'       => 'counter_area',
                'label'         => __( 'Counter ', 'Luzuk Premium' ).$i
            )
        )
    );


     $wp_customize->add_setting(
        'counter_title_img'.$i,
        array(
            'sanitize_callback' => 'esc_url_raw'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'counter_title_img'.$i,
            array(
                'section' => 'counter_area',
                'settings' => 'counter_title_img'.$i,
                'label' => 'Select Image',
                'description' => __('Recommended Image Size: 65pxX65px', 'luzuk-premium')
            )
        )
    );

lzAddElement($wp_customize, 'counter_page_num'.$i, 'counter_area', $type = 'text', $label="Counter Number", $callback ='luzuk_sanitize_text', $default='150+');

lzAddElement($wp_customize, 'counter_page_title'.$i, 'counter_area', $type = 'text', $label="Counter Title", $callback ='luzuk_sanitize_text', $default='Happy Clients');
    
}


lzCustomLable($wp_customize, 'counter_sectioncolor', 'counter_area', ' Section Color');

addColorPalatOption($wp_customize, 'counter_bxbgClr', 'counter_area', 'Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'counter_bximgbgClr', 'counter_area', 'Box Image BG Color', '#d6e8ea');

addColorPalatOption($wp_customize, 'counter_numClr', 'counter_area', 'Counter Number Color', '#1C3434');

addColorPalatOption($wp_customize, 'counter_titleClr', 'counter_area', 'Counter Title Color', '#1C3434');

