<?php
$wp_customize->add_section(
    'newsletter_area',
    array(
        'title' => __('Newsletter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'newsletter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'newsletter_area_disable',
        array(
            'settings'      => 'newsletter_area_disable',
            'section'       => 'newsletter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'newsletter', 'newsletter_area', $color='#F4F1EA', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'newsletterarea_padding', 'newsletter_area', 'Section Padding');

$wp_customize->add_setting(
    'newsletter_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaTpadding',
    array(
        'settings'      => 'newsletter_areaTpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'newsletter_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaBpadding',
    array(
        'settings'      => 'newsletter_areaBpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newsletter_conwidth', 'newsletter_area', 'Section Width ');

$wp_customize->add_setting('news_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'news_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'newsletter_area', // Replace with your actual section ID
    'settings' => 'news_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


$wp_customize->add_setting(
    'newsletter_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newsletter_page_maintitle_heading',
        array(
            'settings'      => 'newsletter_page_maintitle_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);    
 

$wp_customize->add_setting(
    'newsletter_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'FOR MORE UPDATES AND TIPS', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_maintitle',
    array(
        'settings'      => 'newsletter_page_maintitle',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Section Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletterarea_Headingclr', 'newsletter_area', 'Heading Color', '#1C3434');


lzCustomLable($wp_customize, 'newsletter_Form_label', 'newsletter_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'newsletter_shortcode', 'newsletter_area', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'newsletter_forminputbgColor', 'newsletter_area', 'Form Input BG Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_fminputtextClr', 'newsletter_area', 'Form Input Text / Placeholder Color', '#1C3434');

addColorPalatOption($wp_customize, 'newsletter_formlabelColor', 'newsletter_area', 'Form Label Color', '#101a37');

addColorPalatOption($wp_customize, 'newsletter_fmbtntetClr', 'newsletter_area', 'Form Button Text Color', '#1C3434');

addColorPalatOption($wp_customize, 'newslter_fmbtntxthvClr', 'newsletter_area', 'Form Button Text Hover Color', '#74FB94');

addColorPalatOption($wp_customize, 'newsletter_fmbtnbgClr', 'newsletter_area', 'Form Button BG Color', '#74FB94');

addColorPalatOption($wp_customize, 'newsletter_fmbtnbgHVClr', 'newsletter_area', 'Form Button BG Hover Color', '#1C3434');

