<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Service Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#F4F1EA', get_template_directory_uri().'/images/default-gray.png', 'img');


lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'servicearea_conwidth', 'service_area', 'Section Width ');

$wp_customize->add_setting('ser_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );



lzCustomLable($wp_customize, 'servicearea_headingaling', 'service_area', 'Heading Alignment');

$wp_customize->add_setting('ser_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'left'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'serarea_headingcase', 'service_area', 'Heading Style');

$wp_customize->add_setting('ser_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'ser_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'service_area', // Replace with your actual section ID
    'settings' => 'ser_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );



$wp_customize->add_setting(
    'ser_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'ser_title_heading',
        array(
            'settings'      => 'ser_title_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'ser_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Amazing Services', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_title',
    array(
        'settings'      => 'ser_title',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Heading ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'ser_Heading', 'service_area', 'Heading Color', '#1C3434');

$wp_customize->add_setting(
    'ser_subtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our proactive tax solutions support your business success, letting you focus on your strengths.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_subtxt',
    array(
        'settings'      => 'ser_subtxt',
        'section'       => 'service_area',
        'type'          => 'textarea',
        'label'         => __( 'Heading Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'ser_Headingtxt', 'service_area', 'Heading Text Color', '#1C3434');


$wp_customize->add_setting(
    'sersubbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'GET SERVICE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'sersubbtntxt',
    array(
        'settings'      => 'sersubbtntxt',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('sersublink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('sersublink',
    array(
        'settings'      => 'sersublink',
        'section'       => 'service_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'ser_Hbtntxtclr', 'service_area', 'Heading Box Button Text Color', '#1C3434');

addColorPalatOption($wp_customize, 'ser_Hbtntxthvclr', 'service_area', 'Heading Box Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'ser_Hbtnbgclr', 'service_area', 'Heading Box Button BG Color', '#74FB94');

addColorPalatOption($wp_customize, 'ser_Hbtnbghvclr', 'service_area', 'Heading Box Button BG Hover Color', '#1C3434');


$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        )
    )
);    

$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 4));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'service_npp_count', array(
        'label'    => __( '', 'luzuk' ),
        'section'  => 'service_area', // Replace with your actual section ID
        'settings' => 'service_npp_count',
        'choices'=>array(1,2,3,4,5,6,7,8)
    ) ) );


$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 8; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service Box ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Box ', 'luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-wrench',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_servicesclr', 'service_area', 'Section Color');

addColorPalatOption($wp_customize, 'services_secbxbgClr', 'service_area', 'Box Color ', '#fff');

addColorPalatOption($wp_customize, 'services_secbxbghvClr', 'service_area', 'Box Hover Color ', '#1C3434');

addColorPalatOption($wp_customize, 'services_secicnClr', 'service_area', 'Icon Color ', '#1C3434');

addColorPalatOption($wp_customize, 'services_secicnhvClr', 'service_area', 'Icon Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'services_secTitleClr', 'service_area', 'Title Color ', '#1C3434');

addColorPalatOption($wp_customize, 'services_secTitlehvClr', 'service_area', 'Title Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'ser_sectxtClr', 'service_area', 'Title Text Color ', '#1C3434');

addColorPalatOption($wp_customize, 'ser_sectxthvClr', 'service_area', 'Title Text Hover Color ', '#fff');

lzCustomLable($wp_customize, 'ser_secbtn', 'service_area', 'Section Box Button ');
$wp_customize->add_setting(
    'ser_button',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'READ MORE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_button',
    array(
        'settings'      => 'ser_button',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'ser_secbtntxtClr', 'service_area', 'Button Text Color ', '#1C3434');

addColorPalatOption($wp_customize, 'ser_secbtntxthvClr', 'service_area', 'Button Text Hover Color ', '#fff');