<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonial Section', 'luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);

    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk Premium' ),
                'off' => __( 'No', 'luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#F4F1EA', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_testsectionpadding', 'testimonials_area', 'Section Padding');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk Premium' )
    )
);

lzCustomLable($wp_customize, 'testiarea_conwidth', 'testimonials_area', 'Section Width ');

$wp_customize->add_setting('testi_c_width',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'container'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'testi_c_width', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'testimonials_area', // Replace with your actual section ID
    'settings' => 'testi_c_width',
    'choices'=>array(
       'container' => 'Box Width',
       'container-fluid' => 'Full Width',
       
    )
) ) );


lzCustomLable($wp_customize, 'testiarea_headingaling', 'testimonials_area', 'Heading Alignment');

$wp_customize->add_setting('testi_maintitle_align',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'center'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'testi_maintitle_align', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'testimonials_area', // Replace with your actual section ID
    'settings' => 'testi_maintitle_align',
    'choices'=>array(
       'left' => 'Left',
       'center' => 'Center',
       'right' => 'Right',
    )
) ) );


lzCustomLable($wp_customize, 'testiarea_headingcase', 'testimonials_area', 'Heading Style');

$wp_customize->add_setting('testi_maintitle_case',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 'capitalize'));
$wp_customize->add_control( new Luzuk_Custom_Select_Control( $wp_customize, 'testi_maintitle_case', array(
    'label'    => __( '', 'luzuk' ),
    'section'  => 'testimonials_area', // Replace with your actual section ID
    'settings' => 'testi_maintitle_case',
    'choices'=>array(
       'uppercase' => 'Uppercase',
       'lowercase' => 'Lowercase',
       'capitalize' => 'Capitalize',
    )
) ) );


$wp_customize->add_setting(
    'testi_title_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'testi_title_subtitle_heading',
        array(
            'settings'      => 'testi_title_subtitle_heading',
            'section'       => 'testimonials_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'testi_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Trusted By Our Customers', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testi_title',
    array(
        'settings'      => 'testi_title',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'tessec_Heading', 'testimonials_area', 'Heading Color', '#1C3434');

$wp_customize->add_setting(
    'testi_txt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Proin ornare eget elit eu scelerisque. Phasellus aliquam sollicitudin odio in tristique. Quisque nec nulla mollis, viverra nulla a, luctus ipsum.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'testi_txt',
    array(
        'settings'      => 'testi_txt',
        'section'       => 'testimonials_area',
        'type'          => 'textarea',
        'label'         => __( 'Heading Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'tessec_Headingtxt', 'testimonials_area', 'Heading Text Color', '#1C3434');


$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 7; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client ', 'luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}


lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Section Color');

addColorPalatOption($wp_customize, 'tes_seccontbxbgclr', 'testimonials_area', ' Conten Box BG Color', '#D8E8E8');

addColorPalatOption($wp_customize, 'tes_secconticnclr', 'testimonials_area', 'Icon Color', '#fff');

addColorPalatOption($wp_customize, 'tes_secconticnbgclr', 'testimonials_area', 'Icon BG Color', '#1C3434');

addColorPalatOption($wp_customize, 'tes_sectextclr', 'testimonials_area', ' Text Color', '#1C3434');

addColorPalatOption($wp_customize, 'tes_secNameclr', 'testimonials_area', 'Client Name Color', '#1C3434');

addColorPalatOption($wp_customize, 'tes_secdeginclr', 'testimonials_area', 'Client Designation Color', '#1C3434');




lzCustomLable($wp_customize, 'luzuk_secssbtnclr', 'testimonials_area', 'Slider Dots');

addColorPalatOption($wp_customize, 'tes_slidedotclr', 'testimonials_area', 'Slider Dots Color ', '#1C3434');

addColorPalatOption($wp_customize, 'tes_slideactdotclr', 'testimonials_area', 'Slider Active Dot Color ', '#74FB94');