<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package luzuk Premium
 */
$luzuk_lite_single_breadcrumb_section = get_theme_mod('luzuk_lite_single_breadcrumb_section', '1');
$luzuk_lite_single_tags_section = get_theme_mod('luzuk_lite_single_tags_section', '1');
$luzuk_lite_authorbox_section = get_theme_mod('luzuk_lite_authorbox_section', '1');
$luzuk_lite_relatedposts_section = get_theme_mod('luzuk_lite_relatedposts_section', '1');

get_header(); ?> 
 <?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
 
<header class="page-main-header" > 
    <div class="container">   
        <div class="h_titlebx">
            <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?> 
            <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
            <div class="bdcrmbox ">
                <div class="breadcrumbbox ">
                    <div class='button'>
                      <?php luzuk_lite_the_breadcrumb(); ?> </div>
                    <div class="clearfix"></div>
                </div>
            </div>
            <?php endif ?>
        </div>
        <div class="clearfix"></div>
    </div>
</header>
<?php
    // width 
    $single_c_width = get_theme_mod('single_c_width', 'container');

    if ($single_c_width === 'container') {
        $c_alignment = 'container';
    } elseif ($single_c_width === 'container-fluid') {
        $c_alignment = 'container-fluid';
    } else {
        $text_alignment = 'container'; // Default to 'container' if the setting is invalid
    }
        
?>
<main id="innerpage-box">
    <div class="<?php echo esc_attr($single_c_width); ?>">
        <div class="inner_contentbox">
        <div id="content-box" class="innerpage-whitebox">
            <div class="row mr-0">
                <div class="col-lg-8 col-md-7">
                    <article class="article">       
                        <?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
                        <div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
                            <div class="single_post">
                              
                               <!-- Start Content -->
                               <div id="content" class="post-single-content box mark-links">
                                <?php the_content(); ?>
                            </div><!-- End Content -->
                            
                                <?php comments_template( '', true ); ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </article>
            </div>
            <div class="col-lg-4 col-md-5">
                <div id="sidebars" >
                    <div id="secondary " class="widget-area">
                        <?php  dynamic_sidebar('luzuk-project-sidebar'); ?>                         
                    </div> 
                </div>
            </div>
        </div>

        <!-- End Article -->
        <!-- Start Sidebar -->
        <?php // get_sidebar(); ?>
        <!-- End Sidebar -->
    </div>
    <div class="clearfix"></div>
</div>
  <div class="clearfix"></div>
</div>
</main>
<?php get_template_part('template-parts/section','newsletter'); ?>
<?php get_footer(); ?>