<?php
/**
 *
 * @package luzuk Premium
 */
if(get_theme_mod('blog_section_disable') != 'on' ){ ?>
	<?php 
 	if( get_theme_mod('blog_areaTpadding',true) ) {
 		$blog_areaTpadding = 'padding-top:'.esc_attr(get_theme_mod('blog_areaTpadding')).';';
 	}
 	if( get_theme_mod('blog_areaBpadding',true) ) {
 		$blog_areaBpadding = 'padding-bottom:'.esc_attr(get_theme_mod('blog_areaBpadding')).';';
 	}
 	
 	?>
<div  class="blog-area" id="blog" >	
		<?php
		// width 
		$c_width = get_theme_mod('blog_c_width', 'container');

	    if ($c_width === 'container') {
		    $c_alignment = 'container';
		} elseif ($c_width === 'container-fluid') {
		    $c_alignment = 'container-fluid';
		} else {
		    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
		}

		// Heading Style
    	$heading_case = get_theme_mod('blog_maintitle_case', 'capitalize');

	    if ($heading_case === 'uppercase') {
			$text_case = 'uppercase';
		} elseif ($heading_case === 'lowercase') {
		    $text_case = 'lowercase';
		} elseif ($heading_case === 'capitalize') {
		    $text_case = 'capitalize';
		} else {
		    $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
		}
			 
		// Alientment
        $heading_alignment = get_theme_mod('blog_maintitle_align', 'center');

	    if ($heading_alignment === 'left') {
			$text_alignment = 'left';
		} elseif ($heading_alignment === 'center') {
		    $text_alignment = 'center';
		} elseif ($heading_alignment === 'right') {
		    $text_alignment = 'right';
		} else {
		    $text_alignment = 'left'; // Default to 'left' if the setting is invalid
		}
    ?>
	<?php
        $blog_title = get_theme_mod('blog_title', 'Latest Blog');
        $blog_txt = get_theme_mod('blog_txt', 'Nunc consectetur diam sit amet ligula fermentum, sed varius elit consectetur. Suspendisse potenti. Duis sed tellus vitae erat');  
    ?>
    <div class="<?php echo esc_attr($c_width); ?>">
	      <div class="section-title">                         
	          <h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"> <?php echo ($blog_title);  ?> </h3>
	          <p> <?php echo ($blog_txt); ?> </p>
	      </div>                  
	  </div> 
		<div class="<?php echo esc_attr($c_width); ?>">
			<div class="blog-area-wrap">
				<div class="blog-posts">
					<div class="row">
						<?php 
							$blog_post_count = get_theme_mod('blog_post_count', 3 );
							$blog_cat_exclude = get_theme_mod('blog_cat_exclude');
							$blog_cat_exclude = explode(',', $blog_cat_exclude);
							$args = array(
								'posts_per_page' => absint($blog_post_count),
								'category__not_in' => $blog_cat_exclude
							);
							$query = new WP_Query($args);
							if($query -> have_posts()):
								while($query -> have_posts()) : $query -> the_post();
								$luzuk_blog_image = wp_get_attachment_image_src(get_post_thumbnail_id() , 'total-blog-thumb');
								?>
								<?php 
								if(has_post_thumbnail()){
									$img = esc_url($luzuk_blog_image[0]);
								}
								if(empty($luzuk_blog_image)){
									$img = get_template_directory_uri().'/images/blog.jpg';
								}
						?>
						<div class="blog-post col-xl-4 col-lg-4 col-md-6 col-sm-6">
							<div class="box-area-S ">
								<div class="blog-image">
									<a href="<?php the_permalink(); ?>">
										<img class="blog-img" src="<?php echo $img; ?>" alt="<?php the_title(); ?>">
										<div class="blog-admin">
											<div class="row mr-0">
												<div class="blog-adminbx col-md-7 col-sm-8 col-7">
														<i class="fa fa-calendar" aria-hidden="true"></i><?php echo get_the_date( 'j M Y' ); ?>
												</div>
												<div class="blog-comment col-md-5 col-sm-4 col-5">
														<i class="fa fa-comment-o"></i><?php echo $my_var = get_comments_number(); ?> 
												</div>
											</div>
										</div>
									</a>
								</div>							
								<div class="blog-single">	
									<a href="<?php the_permalink(); ?>">
										<h4 class="inner-area-title"><?php the_title(); ?></h4>
									</a>
									<p>
									<?php 
										if(has_excerpt()){
											echo get_the_excerpt();
										}else{
											echo luzuk_excerpt( get_the_content() , 60 );
										}
									?>
									</p>
									<?php
										$blogbtn_text = get_theme_mod('blogbtn_text', 'READ MORE');
									?>
	                  				<div class="blog-btn">
										<?php if($blogbtn_text ){ ?>	
										<a href="<?php echo esc_url(get_permalink()); ?>">
											<?php echo ($blogbtn_text); ?><span class="fa-solid fa-arrow-right"></span>
										</a>
										<?php }?>
									</div>	
									<div class="clearfix"></div>
								</div>
							</div>
							<div class="clearfix"></div>
						</div>
						<?php
							endwhile;
							endif;
							wp_reset_postdata();
						?>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>	
		</div>
		<div class="clearfix"></div>
</div>

<?php }