<?php

if(get_theme_mod('counter_area_disable') != 'on' ){ ?>
	<div class="counter-area" id="counter" >
		<?php
				// width 
				$c_width = get_theme_mod('counter_c_width', 'container');

		    if ($c_width === 'container') {
				    $c_alignment = 'container';
				} elseif ($c_width === 'container-fluid') {
				    $c_alignment = 'container-fluid';
				} else {
				    $text_alignment = 'container'; // Default to 'container' if the setting is invalid
				} 

				$counter_title = get_theme_mod('countertitle', 'Awards & Recognition');
				$counter_trxt = get_theme_mod('countertrxt', 'List any awards, recognitions, or certifications earned by the firm or individual lawyers. This establishes credibility and showcases professional achievements.Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia curae; Sed a congue sem.');

				$phne_txt = get_theme_mod('phne_txt', 'Free Call Now');
				$phne_no = get_theme_mod('phne_no', '+123 456 7890');

	  ?>
    
	 	<?php
	      $showStatic = true;
	      for( $i = 1; $i < 9; $i++ ){
	        $counter_page_id = get_theme_mod('counter_title_img'.$i); 
	        if(!empty($counter_page_id)){
	          $showStatic = false;
	          break;
	        }
	      }
    ?>

			<div class="<?php echo esc_attr($c_width); ?>"> 
					<div class="row mr-0">
							<div class="txt-box">
									<h4><?php echo ($counter_title); ?></h4>
									<p><?php echo ($counter_trxt); ?></p>

									<?php if($phne_no ){ ?>			
									<div class="ph-btn" >
											<div class="phimg">
					            			<?php 
												$counter_phimg = get_theme_mod('counter_phimg');
												if(!empty($counter_phimg)){
													echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($counter_phimg).'" class="img-responsive secondry-bg-img" />';
												}else{
													echo '<img src="'.get_template_directory_uri().'/images/ph.png" class="img-responsive" />';
												}
											?> 
											</div>
											<div class="phbx">
													<div class="phtxt"><?php echo($phne_txt); ?> </div>
													<a href="tel:<?php echo $phne_no;?>" ><?php echo($phne_no); ?> </a>
											</div>
									</div>
									<?php }?>
							</div>
							<div class="counter-single-area">  

							<?php
							$cols = get_theme_mod('counter_npp_count', 3);
							$cols++;
										// echo '$cold: '.$cols;
							switch($cols){
								case 1:
											$colCls = 'col-lg-12 col-md-12 col-sm-12 col-xs-12 col-12';
											break;
											case 2:	
											$colCls = 'col-lg-6 col-md-6 col-sm-12 col-xs-12 col-12';
											break;
											case 3:
											case 5:
											case 6:
											case 9:
											case 11:
											case 13:
											case 15:
											$colCls = 'col-lg-6 col-md-6 col-sm-12 col-xs-12 col-12';
											break;
											default: 
											$colCls = 'col-lg-6 col-md-6 col-sm-12 col-xs-12 col-12';
											break;
							}
							$icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell');
							?>
			 						<div class=" counter-post-boxes">
			 								<div class="row mr-0">
			            <?php
			            for( $i = 1; $i <= $cols; $i++ ){
			              if($showStatic === false){
			               	$counter_page_id = get_theme_mod('counter_page'.$i);
			                	$counter_page_title = get_theme_mod('counter_page_title'.$i, 'Happy Clients');
			                	$counter_page_num = get_theme_mod('counter_page_num'.$i, '150+');
			            		$counter_title_img = get_theme_mod('counter_title_img'.$i);
			            if($counter_title_img){
			                ?>
				                <div class="<?php echo $colCls;?> single-top ">
				                    <div class="cd-single">
					                    	<div class="row mr-0">
					                    			<div class="imgbx">
																				<div class="imgbxinn">
																					<?php
																							echo '<img src="'.esc_url($counter_title_img).'" class="img-responsive secondry-bg-img" />';
																						?>
																				</div>
																		</div>
						                      	<div class="d-bx">
						                      			<div class="cd-num count"><?php echo $counter_page_num; ?></div>
						                      			<div class="cd-title ">	<?php echo $counter_page_title; ?></div>
						                      	</div>
					                      </div>
				                    		<div class="clearfix"></div>
				                  	</div>
				              	</div>
			                <?php
			                    }                  
			                }else{?>
												<div class="<?php echo $colCls;?> single-top ">
														<div class="cd-single">			
																<div class="row mr-0">
																		<div class="imgbx">
																				<div class="imgbxinn">
																					<img class="img-responsive" src="<?php echo esc_url(get_template_directory_uri().'/images/count3.png');?>"  />
																				</div>
																		</div>
																		<div class="d-bx">
																				<div class="cd-num count">150+</div>
																				<div class="cd-title ">Happy Clients</div>
																		</div>
																</div>
																<div class="clearfix"></div>
														</div>
												</div>
			                <?php }
			              }?>
			              <div class="clearfix"></div>
			         			</div>
									</div>
							</div>
					</div>
			</div>
	</div> 

	<script>
  $(document).ready(function () {
    var counters = $(".count");
    var countersQuantity = counters.length;
    var counterValues = [];

    // Extract initial values and split numbers from text/symbols
    for (let i = 0; i < countersQuantity; i++) {
      let value = counters[i].innerHTML.trim();
      let numberMatch = value.match(/\d+/); // Extract the numeric part
      let prefix = value.replace(/\d+.*/, ""); // Extract prefix (non-numeric before number)
      let suffix = value.replace(/.*\d+/, ""); // Extract suffix (non-numeric after number)

      counterValues[i] = {
        original: value,
        number: numberMatch ? parseInt(numberMatch[0]) : null,
        prefix: prefix,
        suffix: suffix,
      };
    }

    // Function to animate numeric counter
    var count = function (start, end, prefix, suffix, id) {
      let current = start;
      let interval = setInterval(function () {
        if (current < end) {
          current++;
          counters[id].innerHTML = prefix + current + suffix;
        } else {
          clearInterval(interval);
        }
      }, 40);
    };

    // Start counting
    for (let j = 0; j < countersQuantity; j++) {
      let counter = counterValues[j];
      if (counter.number !== null) {
        // Animate numbers
        count(0, counter.number, counter.prefix, counter.suffix, j);
      } else {
        // Display non-numeric values directly
        counters[j].innerHTML = counter.original;
      }
    }
  });
</script>
<?php } 