<?php 
/**
 * 
 * @package luzuk
 */

if(get_theme_mod('testimonials_area_disable') != 'on' ){ ?> 
 
<div id="testimonials"class="testimonials-area " >
    <?php
        // width 
        $c_width = get_theme_mod('testi_c_width', 'container');

          if ($c_width === 'container') {
              $c_alignment = 'container';
          } elseif ($c_width === 'container-fluid') {
              $c_alignment = 'container-fluid';
          } else {
              $text_alignment = 'container'; // Default to 'container' if the setting is invalid
          }

          // Heading Style
          $heading_case = get_theme_mod('testi_maintitle_case', 'capitalize');

          if ($heading_case === 'uppercase') {
            $text_case = 'uppercase';
          } elseif ($heading_case === 'lowercase') {
              $text_case = 'lowercase';
          } elseif ($heading_case === 'capitalize') {
              $text_case = 'capitalize';
          } else {
              $text_case = 'capitalize'; // Default to 'left' if the setting is invalid
          }
           
          // Alignment
      $heading_alignment = get_theme_mod('testi_maintitle_align', 'center');

        if ($heading_alignment === 'left') {
          $text_alignment = 'left';
        } elseif ($heading_alignment === 'center') {
            $text_alignment = 'center';
        } elseif ($heading_alignment === 'right') {
            $text_alignment = 'right';
        } else {
            $text_alignment = 'right'; // Default to 'left' if the setting is invalid
        }
      ?>

    <?php             
      $testi_title = get_theme_mod('testi_title', 'Trusted By Our Customers');
      $testi_txt = get_theme_mod('testi_txt', 'Proin ornare eget elit eu scelerisque. Phasellus aliquam sollicitudin odio in tristique. Quisque nec nulla mollis, viverra nulla a, luctus ipsum.');
      
    ?>
    <div class="section-title">
        <div class="<?php echo esc_attr($c_width); ?>">
            <div class="titlebx">
              <h3 style="text-align: <?php echo esc_attr($text_alignment); ?>; text-transform: <?php echo esc_attr($heading_case); ?>;"><?php echo ($testi_title); ?></h3>
              <p> <?php echo ($testi_txt); ?> </p>
            </div>
        </div>
    </div>

    <div class="<?php echo esc_attr($c_width); ?>">   
        <div class="row mr-0">
              <div class="tesbox">
                <div class="testimonials-single-area"> 
                    <div class="owl-carousel "> 
                      <?php  
                        $showStatic = true;
                        $cols = get_theme_mod('test_npp_count', 5);
                        $cols++;
                        switch($cols){
                          case 1:
                            $colCls = 'col-md-12 col-sm-12 col-xs-12';
                            break;
                          case 2:
                            $colCls = 'col-md-6 col-sm-6 col-xs-12';
                            break;
                          case 3:
                          case 5:
                          case 6:
                          case 7:
                          case 8:
                          case 9:
                          case 10:
                          case 11:
                          case 12:
                            $colCls = 'col-md-4 col-sm-6 col-xs-12';
                            break;
                          default:
                            $colCls = 'col-md-3 col-sm-6 col-xs-12';
                            break;
                        }
                        $icons = array(1=>'heart', 2=>'star', 3=>'flash', 4=>'bell',5=>'heart', 6=>'star', 7=>'flash', 8=>'bell'); 

                        for( $i = 1; $i <= $cols; $i++ ){
                          $testimonials_page_id = get_theme_mod('testimonials_page'.$i); 
                          $testimonials_page_icon = get_theme_mod('testimonials_page_icon'.$i);
                          if($testimonials_page_id){
                            $showStatic = false;
                            echo testimonialShortCode($testimonials_page_id, $isCustomizer=true, $i);
                        }
                      }

                        // adding the static content
                        if($showStatic === true){
                          for( $i = 1; $i <= $cols; $i++ ){ ?>
                        <div class="item items innertest-item ">        
                            <div class="ts-area-single ">
                                <div class="icnbx"><i class="fa fa-quote-left"></i></div>
                                <div class="ts-area-c">   
                                    <p>Proin ornare eget elit eu scelerisque. Phasellus aliquam sollicitudin odio in tristique. Quisque nec nulla mollis, viverra nulla a, luctus ipsum. Pellentesque vestibulum nisl turpis.</p>
                                </div>  
                                <div class="ts-area-content">
                                    <div class="row mr-0">
                                        <div class="ts-area-thumb">
                                            <div class="testiimginn">
                                                <img class="img-responsive" src="<?php echo get_template_directory_uri(); ?>/images/testi.jpg" alt="">
                                            </div>
                                        </div>
                                        <div class="ts-area-bx">
                                            <h3 class="ts-area-title">Alina Parker</h3>
                                            <div class="text-designation">CEO, of the company</div>
                                            <div class="clearfix"></div>
                                        </div>
                                    <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                          <?php }

                        }?>
                    </div>   
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
        <div class="clearfix"></div>
    </div>
</div>
<script>
    $(document).ready(function() {
      $('.testimonials-area .owl-carousel').owlCarousel({
        refreshClass: 'owl-refresh',
        autoplayTimeout:5000,
        loop: true,
        margin: 30,
        autoHeight: false,
        autoWidth: false,
        autoplay: true,
        // animateIn: 'zoomIn',
        // animateOut: 'zoomOut',
        responsiveClass: true,
        responsive: {
          0: {
            items: 1,
            nav: true,
            margin: 10
          },
          600: {
            items:1,
            nav: true,
            margin: 10
          },

          760: {
            items:2,
            nav: true,
            margin: 10
          },

          1000: {
            items:3,
            nav: true,
            loop: true,
            margin: 50
          }
        }
      })
    })
</script> 

<?php } 

