<?php
/**
 * Template Name: Contact Page
 *
 * @package luzuk Premium
 */
get_header(); 
?>

<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>

<header class="page-main-header" >
    <div class="container">   
    	<div class="h_titlebx">
    		<?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?>
	        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
	        <div class="bdcrmbox ">
	            <div class="breadcrumbbox ">
	                <div class='button'>
	                  <?php luzuk_lite_the_breadcrumb(); ?> </div>
	                <div class="clearfix"></div>
	            </div>
	        </div>
	        <?php endif ?>     
	    </div>
        <div class="clearfix"></div>
    </div>
</header>
<main id="innerpage-box" >
	<?php
        // width 
        $c_width = get_theme_mod('innpg_c_width', 'container-fluid');

        if ($c_width === 'container') {
            $c_alignment = 'container';
        } elseif ($c_width === 'container-fluid') {
            $c_alignment = 'container-fluid';
        } else {
            $text_alignment = 'container'; // Default to 'container' if the setting is invalid
        }
            
    ?>
	<?php 
		
		$s_title = get_theme_mod('stitle', 'Contact Us');
		$m_title = get_theme_mod('mtitle', 'We’re Here To Provide ');
		$title_txt = get_theme_mod('titletxt', '24X7 Support ');

		$address = get_theme_mod('luzuk_contactus_address', 'Add Address here..');
		$phone = get_theme_mod('luzuk_contactus_phone', '+ 1111-222-333');
		$email = get_theme_mod('luzuk_contactus_email', 'Info@Gmail.Com');

		$shortcode = get_theme_mod('luzuk_contactus_shortcode', 'Add form shortcode ');
		$iframe = get_theme_mod('luzuk_contactus_embade', 'Add your Embed code in customizer');
			
	?>	
	<div class="contact-address-area ">
		<div class="<?php echo esc_attr($c_width); ?>"> 
			<div class="row mr-0">	
				<div class="detalbx ">
					<div class="titlebx">
						<?php if( $s_title ){ ?>
						<div class="subtitle"> 
							<svg fill="#000000" height="200px" width="200px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 58 58" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <g> <path d="M57.484,28.125l-19-10.5c-0.311-0.171-0.687-0.165-0.992,0.014C37.187,17.818,37,18.146,37,18.5v5h-6 c-0.552,0-1,0.448-1,1v9c0,0.552,0.448,1,1,1h6v5c0,0.354,0.187,0.682,0.492,0.861C37.648,40.453,37.824,40.5,38,40.5 c0.167,0,0.333-0.042,0.484-0.125l19-10.5C57.802,29.699,58,29.364,58,29S57.802,28.301,57.484,28.125z M39,37.805V33.5 c0-0.552-0.448-1-1-1h-6v-7h6c0.552,0,1-0.448,1-1v-4.305L54.933,29L39,37.805z"></path> <path d="M27,23.5h-6v-5c0-0.354-0.187-0.682-0.492-0.861c-0.305-0.179-0.682-0.185-0.992-0.014l-19,10.5 C0.198,28.301,0,28.636,0,29c0,0.364,0.198,0.699,0.516,0.875l19,10.5C19.667,40.458,19.833,40.5,20,40.5 c0.176,0,0.352-0.046,0.508-0.139C20.813,40.182,21,39.854,21,39.5v-5h6c0.552,0,1-0.448,1-1v-9C28,23.948,27.552,23.5,27,23.5z M26,32.5h-6c-0.552,0-1,0.448-1,1v4.305L3.067,29L19,20.195V24.5c0,0.552,0.448,1,1,1h6V32.5z"></path> </g> </g> </g></svg>
						 <?php echo $s_title;?>
						</div>
						<?php } ?>
						<div class="title inner-area-title"> <?php echo $m_title;?></div>
						<div class="titletxt"> <?php echo $title_txt;?></div>
					</div>
					<div class="cntpgbx ">
					   	<?php if( $address ){ ?>
				   		<div class="cntpgtxt">				
					   		<p> <i class="fa fa-home" ></i> <?php echo $address;?></p>	   			
				   		</div>
					   <?php } ?>

					   	<?php if( $phone ){ ?>
					   	<div class=" cntpgtxt">		
							<a class="" href="tel:<?php echo $phone;?>"><p> <i class="fa fa-phone"></i><?php echo $phone;?></p></a>
				   		</div>
					   	<?php } ?>

					   	<?php if( $email ){ ?>
				   		<div class=" cntpgtxt">		
				   			<a href="mailto:<?php echo $email;?>"><p> <i class="fa fa-envelope"></i><?php echo $email;?></p></a>	  	
				   		</div>
					   	<?php } ?>
				    </div>							
					<div class="clearfix"></div>	
				</div>
				
				<div class="fmbxout ">			
					<?php if( $shortcode ){ ?>			
					<div id="ht-contactus-wrap">	
						<div class="fmbx">														     			
			          		<div class="ctform"><?php echo do_shortcode($shortcode);?></div>		
							<div class="clearfix"></div>	
						</div>											
					</div>				
					<?php } ?>				    
				</div>	
			</div>			
		</div>
		<div class="contact-mapbox ">
			<?php echo $iframe; ?>
		</div>
	</div>
	<div class="clearfix"></div>
</main>
<?php get_template_part('template-parts/section','newsletter'); ?>
<?php get_footer(); ?>

